/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.render.layer;

import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerHeldItem
implements LayerRenderer<EntityLivingBase> {
    protected final RenderLivingBase<?> livingEntityRenderer;

    public LayerHeldItem(RenderLivingBase<?> livingEntityRendererIn) {
        this.livingEntityRenderer = livingEntityRendererIn;
    }

    public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemStack itemstack1 = entity.func_184614_ca();
        ItemStack itemstack = entity.func_184592_cb();
        if (!itemstack.func_190926_b() || !itemstack1.func_190926_b()) {
            HeldModel model = new HeldModel((ModelCustom)this.livingEntityRenderer.func_177087_b());
            model.limbSwing = limbSwing;
            model.limbSwingAmount = limbSwingAmount;
            model.ageInTicks = ageInTicks;
            model.netHeadYaw = netHeadYaw;
            model.headPitch = headPitch;
            model.scale = scale;
            LayerHeldItem.renderHeldItem(entity, itemstack1, model, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT);
            LayerHeldItem.renderHeldItem(entity, itemstack, model, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, EnumHandSide.LEFT);
            model.model.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, (Entity)entity);
        }
    }

    public static void renderHeldItem(EntityLivingBase entity, ItemStack item, HeldModel model, ItemCameraTransforms.TransformType transform, EnumHandSide handSide) {
        if (!item.func_190926_b()) {
            for (ModelCustomRenderer arm : model.model.getRenderForArm(handSide)) {
                boolean flag = handSide == EnumHandSide.LEFT;
                model.setup(entity);
                GlStateManager.func_179094_E();
                LayerHeldItem.applyTransform(arm);
                Minecraft.func_71410_x().func_175597_ag().func_187462_a(entity, item, transform, flag);
                GlStateManager.func_179121_F();
            }
        }
    }

    public static void renderHeldItem(EntityLivingBase entity, ItemStack item, ModelCustom model, ItemCameraTransforms.TransformType transform, EnumHandSide handSide) {
        if (item != null) {
            for (ModelCustomRenderer arm : model.getRenderForArm(handSide)) {
                boolean flag = handSide == EnumHandSide.LEFT;
                GlStateManager.func_179094_E();
                LayerHeldItem.applyTransform(arm);
                Minecraft.func_71410_x().func_175597_ag().func_187462_a(entity, item, transform, flag);
                GlStateManager.func_179121_F();
            }
        }
    }

    private static void applyTransform(ModelCustomRenderer arm) {
        float x = (float)arm.limb.size[0] * (0.5f - arm.limb.anchor[0]) * 0.0625f;
        float y = (float)arm.limb.size[1] * ((float)arm.limb.size[1] * (1.0f - arm.limb.anchor[1]) / (float)arm.limb.size[1]) * -0.0625f;
        float z = (float)arm.limb.size[2] * arm.limb.anchor[2] * 0.0625f;
        if (arm.limb.size[0] > arm.limb.size[1]) {
            x = (float)arm.limb.size[0] * 0.8333333f * 0.0625f;
        }
        arm.func_78794_c(0.0625f);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)x, (float)z, (float)y);
        if (arm.limb.size[0] > arm.limb.size[1]) {
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)arm.limb.itemScale, (float)arm.limb.itemScale, (float)arm.limb.itemScale);
    }

    public boolean func_177142_b() {
        return false;
    }

    public static class HeldModel {
        public float limbSwing;
        public float limbSwingAmount;
        public float ageInTicks;
        public float netHeadYaw;
        public float headPitch;
        public float scale;
        public ModelCustom model;
        public ModelPose pose;

        public HeldModel(ModelCustom model) {
            this.model = model;
            this.pose = model.pose;
        }

        public void setup(EntityLivingBase entity) {
            this.model.pose = this.pose;
            this.model.func_78087_a(this.limbSwing, this.limbSwingAmount, this.ageInTicks, this.netHeadYaw, this.headPitch, this.scale, (Entity)entity);
        }
    }
}

