/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.render;

import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.common.entity.EntityGunProjectile;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderGunProjectile
extends Render<EntityGunProjectile> {
    protected RenderGunProjectile(RenderManager renderManager) {
        super(renderManager);
    }

    public boolean shouldRender(EntityGunProjectile livingEntity, ICamera camera, double camX, double camY, double camZ) {
        if (((Boolean)Blockbuster.actorAlwaysRender.get()).booleanValue()) {
            return true;
        }
        return super.func_177071_a((Entity)livingEntity, camera, camX, camY, camZ);
    }

    protected ResourceLocation getEntityTexture(EntityGunProjectile entity) {
        return null;
    }

    public void doRender(EntityGunProjectile entity, double x, double y, double z, float entityYaw, float partialTicks) {
        AbstractMorph morph = entity.morph.get();
        if (entity.props != null && morph != null) {
            float timer = (float)entity.field_70173_aa + partialTicks;
            int length = entity.props.lifeSpan;
            float scale = Interpolations.envelope((float)(timer > (float)length ? (float)length : timer), (float)0.0f, (float)entity.props.fadeIn, (float)(length - entity.props.fadeOut), (float)length);
            if (entity.vanish && entity.props.vanishDelay > 0) {
                scale = Interpolations.envelope((float)((float)entity.vanishDelay - partialTicks), (float)0.0f, (float)entity.props.fadeOut, (float)entity.props.vanishDelay, (float)entity.props.vanishDelay);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            boolean captured = MatrixUtils.captureMatrix();
            GlStateManager.func_179152_a((float)(scale += (float)(entity.func_145782_y() % 100) / 10000.0f), (float)scale, (float)scale);
            if (entity.props.yaw) {
                GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (entity.props.pitch) {
                GlStateManager.func_179114_b((float)(-(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks) + 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            entity.props.projectileTransform.transform();
            entity.props.createEntity();
            morph.render(entity.props.getEntity(entity), 0.0, 0.0, 0.0, 0.0f, partialTicks);
            if (captured) {
                MatrixUtils.releaseMatrix();
            }
            GlStateManager.func_179121_F();
        }
    }

    public static class FactoryGunProjectile
    implements IRenderFactory<EntityGunProjectile> {
        public Render<? super EntityGunProjectile> createRenderFor(RenderManager manager) {
            return new RenderGunProjectile(manager);
        }
    }
}

