/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.render;

import java.util.Map;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import mchorse.blockbuster_pack.morphs.CustomMorph;
import mchorse.mclib.utils.MatrixUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCustomModel
extends RenderLivingBase<EntityLivingBase> {
    public static ResourceLocation lastTexture;
    public CustomMorph current;
    private int captured;
    private boolean capturedByMe;

    public static void bindLastTexture(ResourceLocation location) {
        lastTexture = location;
        RenderCustomModel.bindLastTexture();
    }

    public static void bindLastTexture() {
        if (lastTexture != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(lastTexture);
        }
    }

    public RenderCustomModel(RenderManager renderManagerIn, ModelBase modelBaseIn, float shadowSizeIn) {
        super(renderManagerIn, null, shadowSizeIn);
    }

    protected ResourceLocation getEntityTexture(EntityLivingBase entity) {
        return this.field_77045_g == null ? null : ((ModelCustom)this.field_77045_g).model.defaultTexture;
    }

    protected boolean bindEntityTexture(EntityLivingBase entity) {
        ResourceLocation texture;
        if (this.field_77045_g != null && ((ModelCustom)this.field_77045_g).model.providesMtl && (texture = this.getEntityTexture(entity)) == null) {
            return true;
        }
        return super.func_180548_c((Entity)entity);
    }

    public void func_110776_a(ResourceLocation location) {
        lastTexture = location;
        super.func_110776_a(location);
    }

    protected boolean func_177070_b(EntityLivingBase entity) {
        return super.func_177070_b(entity) && entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i;
    }

    public void func_76986_a(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.setupModel(entity, partialTicks);
        if (this.field_77045_g != null) {
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }
        if (this.captured > 0) {
            --this.captured;
            if (this.captured == 0 && this.capturedByMe) {
                MatrixUtils.releaseMatrix();
                this.capturedByMe = false;
            }
        }
    }

    protected void func_77039_a(EntityLivingBase entityLivingBaseIn, double x, double y, double z) {
        super.func_77039_a(entityLivingBaseIn, x, y, z);
        if (this.captured == 0) {
            this.capturedByMe = MatrixUtils.captureMatrix();
        }
        ++this.captured;
    }

    public void setupModel(EntityLivingBase entity, float partialTicks) {
        Map<String, ModelCustom> models = ModelCustom.MODELS;
        ModelCustom model = null;
        ModelPose pose = null;
        if (this.current != null) {
            model = models.get(this.current.getKey());
            pose = this.current.getPose(entity, partialTicks);
        }
        if (model != null) {
            if (pose == null) {
                pose = model.model.getPose("standing");
            }
            model.materials = this.current.materials;
            model.shapes = this.current.getShapesForRendering(partialTicks);
            model.pose = pose;
            model.current = this.current;
            this.field_77045_g = model;
        }
    }

    protected void func_77041_b(EntityLivingBase entity, float partialTickTime) {
        Model model = ((ModelCustom)this.field_77045_g).model;
        float scale = this.current == null ? 1.0f : this.current.scale;
        GlStateManager.func_179152_a((float)(model.scale[0] * scale), (float)(model.scale[1] * scale), (float)(model.scale[2] * scale));
    }

    protected void func_77043_a(EntityLivingBase entity, float pitch, float yaw, float partialTicks) {
        if (entity.func_70089_S() && entity.func_70608_bn()) {
            GlStateManager.func_179114_b((float)((EntityPlayer)entity).func_71051_bG(), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.func_77037_a(entity), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (entity.func_184613_cA()) {
            super.func_77043_a(entity, pitch, yaw, partialTicks);
            float f = (float)entity.func_184599_cB() + partialTicks;
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            Vec3d vec3d = entity.func_70676_i(partialTicks);
            double d0 = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            GlStateManager.func_179114_b((float)(f1 * (-90.0f - entity.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (entity.field_70159_w * vec3d.field_72450_a + entity.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = entity.field_70159_w * vec3d.field_72449_c - entity.field_70179_y * vec3d.field_72450_a;
                GlStateManager.func_179114_b((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            super.func_77043_a(entity, pitch, yaw, partialTicks);
        }
    }

    public void renderRightArm(EntityPlayer player) {
        ResourceLocation texture = this.getEntityTexture((EntityLivingBase)player);
        if (texture != null) {
            this.func_110776_a(texture);
        }
        this.field_77045_g.field_78095_p = 0.0f;
        this.field_77045_g.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        for (ModelCustomRenderer arm : ((ModelCustom)this.field_77045_g).right) {
            arm.field_78795_f = 0.0f;
            arm.field_78800_c = -6.0f;
            arm.field_78797_d = 13.8f - (float)(arm.limb.size[1] > 8 ? arm.limb.size[1] : arm.limb.size[1] + 2);
            arm.field_78798_e = 0.0f;
            arm.func_78785_a(0.0625f);
        }
        GlStateManager.func_179084_k();
    }

    public void renderLeftArm(EntityPlayer player) {
        ResourceLocation texture = this.getEntityTexture((EntityLivingBase)player);
        if (texture != null) {
            this.func_110776_a(texture);
        }
        this.field_77045_g.field_78095_p = 0.0f;
        this.field_77045_g.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        for (ModelCustomRenderer arm : ((ModelCustom)this.field_77045_g).left) {
            arm.field_78795_f = 0.0f;
            arm.field_78800_c = 6.0f;
            arm.field_78797_d = 13.8f - (arm.limb.size[1] > 8 ? (float)arm.limb.size[1] : (float)arm.limb.size[1] + 2.0f);
            arm.field_78798_e = 0.0f;
            arm.func_78785_a(0.0625f);
        }
        GlStateManager.func_179084_k();
    }
}

