/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.particles.components.lifetime;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mchorse.blockbuster.client.particles.components.BedrockComponentBase;
import mchorse.blockbuster.client.particles.components.lifetime.BedrockComponentLifetime;
import mchorse.blockbuster.client.particles.emitter.BedrockEmitter;
import mchorse.mclib.math.molang.MolangException;
import mchorse.mclib.math.molang.MolangParser;
import mchorse.mclib.math.molang.expressions.MolangExpression;

public class BedrockComponentLifetimeLooping
extends BedrockComponentLifetime {
    public MolangExpression sleepTime = MolangParser.ZERO;

    @Override
    public BedrockComponentBase fromJson(JsonElement elem, MolangParser parser) throws MolangException {
        if (!elem.isJsonObject()) {
            return super.fromJson(elem, parser);
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("sleep_time")) {
            this.sleepTime = parser.parseJson(element.get("sleep_time"));
        }
        return super.fromJson((JsonElement)element, parser);
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = (JsonObject)super.toJson();
        if (!MolangExpression.isZero((MolangExpression)this.sleepTime)) {
            object.add("sleep_time", this.sleepTime.toJson());
        }
        return object;
    }

    @Override
    public void update(BedrockEmitter emitter) {
        double active = this.activeTime.get();
        double sleep = this.sleepTime.get();
        double age = emitter.getAge();
        emitter.lifetime = (int)(active * 20.0);
        if (age >= active && emitter.playing) {
            emitter.stop();
        }
        if (age >= sleep && !emitter.playing) {
            emitter.start();
        }
    }
}

