/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.particles;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mchorse.blockbuster.client.particles.BedrockCurveType;
import mchorse.mclib.math.Variable;
import mchorse.mclib.math.molang.MolangException;
import mchorse.mclib.math.molang.MolangParser;
import mchorse.mclib.math.molang.expressions.MolangExpression;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MathUtils;

public class BedrockCurve {
    public BedrockCurveType type = BedrockCurveType.LINEAR;
    public MolangExpression[] nodes = new MolangExpression[]{MolangParser.ZERO, MolangParser.ONE, MolangParser.ZERO};
    public MolangExpression input;
    public MolangExpression range;
    public Variable variable;

    public double compute() {
        return this.computeCurve(this.input.get() / this.range.get());
    }

    private double computeCurve(double factor) {
        int length = this.nodes.length;
        if (length == 0) {
            return 0.0;
        }
        if (length == 1) {
            return this.nodes[0].get();
        }
        if (factor < 0.0) {
            factor = -(1.0 + factor);
        }
        factor = MathUtils.clamp((double)factor, (double)0.0, (double)1.0);
        if (this.type == BedrockCurveType.HERMITE) {
            if (length <= 3) {
                return this.nodes[length - 2].get();
            }
            int index = (int)(factor *= (double)(length - 3)) + 1;
            MolangExpression beforeFirst = this.getNode(index - 1);
            MolangExpression first = this.getNode(index);
            MolangExpression next = this.getNode(index + 1);
            MolangExpression afterNext = this.getNode(index + 2);
            return Interpolations.cubicHermite((double)beforeFirst.get(), (double)first.get(), (double)next.get(), (double)afterNext.get(), (double)(factor % 1.0));
        }
        int index = (int)(factor *= (double)(length - 1));
        MolangExpression first = this.getNode(index);
        MolangExpression next = this.getNode(index + 1);
        return Interpolations.lerp((double)first.get(), (double)next.get(), (double)(factor % 1.0));
    }

    private MolangExpression getNode(int index) {
        if (index < 0) {
            return this.nodes[0];
        }
        if (index >= this.nodes.length) {
            return this.nodes[this.nodes.length - 1];
        }
        return this.nodes[index];
    }

    public void fromJson(JsonObject object, MolangParser parser) throws MolangException {
        if (object.has("type")) {
            this.type = BedrockCurveType.fromString(object.get("type").getAsString());
        }
        if (object.has("input")) {
            this.input = parser.parseJson(object.get("input"));
        }
        if (object.has("horizontal_range")) {
            this.range = parser.parseJson(object.get("horizontal_range"));
        }
        if (object.has("nodes")) {
            JsonArray nodes = object.getAsJsonArray("nodes");
            MolangExpression[] result = new MolangExpression[nodes.size()];
            int c = result.length;
            for (int i = 0; i < c; ++i) {
                result[i] = parser.parseJson(nodes.get(i));
            }
            this.nodes = result;
        }
    }

    public JsonElement toJson() {
        JsonObject curve = new JsonObject();
        JsonArray nodes = new JsonArray();
        curve.addProperty("type", this.type.id);
        curve.add("nodes", (JsonElement)nodes);
        curve.add("input", this.input.toJson());
        curve.add("horizontal_range", this.range.toJson());
        for (MolangExpression expression : this.nodes) {
            nodes.add(expression.toJson());
        }
        return curve;
    }
}

