/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.model.parsing;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.api.formats.IMeshes;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import mchorse.blockbuster.client.model.parsing.IModelCustom;
import mchorse.metamorph.Metamorph;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelParser {
    public String key;
    public Map<String, IMeshes> meshes;

    public static ModelCustom parse(String key, Model data) {
        return ModelParser.parse(key, data, ModelCustom.class, null);
    }

    public static ModelCustom parse(String key, Model data, Map<String, IMeshes> meshes) {
        return ModelParser.parse(key, data, ModelCustom.class, meshes);
    }

    public static ModelCustom parse(String key, Model data, Class<? extends ModelCustom> clazz, Map<String, IMeshes> meshes) {
        try {
            return new ModelParser(key, meshes).parseModel(data, clazz);
        }
        catch (Exception e) {
            System.out.println("Model for key '" + key + "' couldn't converted to ModelCustom!");
            e.printStackTrace();
            return null;
        }
    }

    public ModelParser(String key, Map<String, IMeshes> meshes) {
        if (meshes == null) {
            meshes = new HashMap<String, IMeshes>();
        }
        this.key = key;
        this.meshes = meshes;
    }

    public ModelCustom parseModel(Model data, Class<? extends ModelCustom> clazz) throws Exception {
        ModelCustom model = clazz.getConstructor(Model.class).newInstance(data);
        this.generateLimbs(data, model);
        if (model instanceof IModelCustom) {
            ((IModelCustom)((Object)model)).onGenerated();
        }
        return model;
    }

    protected void generateLimbs(Model data, ModelCustom model) {
        ModelLimb limb;
        HashMap<String, ModelCustomRenderer> limbs = new HashMap<String, ModelCustomRenderer>();
        ArrayList<ModelLimb> renderable = new ArrayList<ModelLimb>();
        ArrayList<ModelCustomRenderer> left = new ArrayList<ModelCustomRenderer>();
        ArrayList<ModelCustomRenderer> right = new ArrayList<ModelCustomRenderer>();
        ArrayList<ModelCustomRenderer> armor = new ArrayList<ModelCustomRenderer>();
        ModelPose standing = data.poses.get("standing");
        for (Map.Entry<String, ModelLimb> entry : data.limbs.entrySet()) {
            limb = entry.getValue();
            ModelTransform transform = standing.limbs.get(entry.getKey());
            ModelCustomRenderer renderer = this.createRenderer(model, data, limb, transform);
            if (limb.holding == ModelLimb.Holding.LEFT) {
                left.add(renderer);
            }
            if (limb.holding == ModelLimb.Holding.RIGHT) {
                right.add(renderer);
            }
            if (limb.slot != ModelLimb.ArmorSlot.NONE) {
                armor.add(renderer);
            }
            limbs.put(entry.getKey(), renderer);
        }
        for (Map.Entry<String, ModelLimb> entry : limbs.entrySet()) {
            limb = data.limbs.get(entry.getKey());
            if (!limb.parent.isEmpty()) {
                ((ModelCustomRenderer)((Object)limbs.get(limb.parent))).func_78792_a((ModelRenderer)entry.getValue());
            } else {
                renderable.add(entry.getValue());
            }
            if (!(model instanceof IModelCustom)) continue;
            try {
                Field field = ((Object)((Object)model)).getClass().getField(entry.getKey());
                if (field == null) continue;
                field.set((Object)model, entry.getValue());
            }
            catch (Exception e) {
                Metamorph.log((String)("Field '" + entry.getKey() + "' was not found or is not accessible for " + ((Object)((Object)model)).getClass().getSimpleName()));
            }
        }
        model.left = left.toArray(new ModelCustomRenderer[left.size()]);
        model.right = right.toArray(new ModelCustomRenderer[right.size()]);
        model.armor = armor.toArray(new ModelCustomRenderer[armor.size()]);
        model.limbs = limbs.values().toArray(new ModelCustomRenderer[limbs.size()]);
        model.renderable = renderable.toArray(new ModelCustomRenderer[renderable.size()]);
    }

    protected ModelCustomRenderer createRenderer(ModelCustom model, Model data, ModelLimb limb, ModelTransform transform) {
        ModelCustomRenderer renderer = null;
        float w = limb.size[0];
        float h = limb.size[1];
        float d = limb.size[2];
        float ax = 1.0f - limb.anchor[0];
        float ay = limb.anchor[1];
        float az = limb.anchor[2];
        IMeshes meshes = this.meshes.get(limb.name);
        if (meshes != null) {
            renderer = meshes.createRenderer(data, model, limb, transform);
        }
        if (renderer == null) {
            renderer = new ModelCustomRenderer(model, limb, transform);
            renderer.field_78809_i = limb.mirror;
            renderer.func_78790_a(-ax * w, -ay * h, -az * d, (int)w, (int)h, (int)d, limb.sizeOffset);
        }
        renderer.applyTransform(transform);
        return renderer;
    }
}

