/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.model.parsing;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import mchorse.mclib.McLib;
import mchorse.mclib.client.render.VertexBuilder;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.resources.MultiResourceLocation;
import mchorse.mclib.utils.resources.MultiskinThread;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ModelExtrudedLayer {
    public static final byte TOP_BIT = 1;
    public static final byte BOTTOM_BIT = 2;
    public static final byte FRONT_BIT = 4;
    public static final byte BACK_BIT = 8;
    public static final byte LEFT_BIT = 16;
    public static final byte RIGHT_BIT = 32;
    protected static Map<ModelCustomRenderer, Map<ResourceLocation, Integer>> layers = new HashMap<ModelCustomRenderer, Map<ResourceLocation, Integer>>();
    protected static Map<ResourceLocation, CachedImage> images = new HashMap<ResourceLocation, CachedImage>();

    public static void forceReload(ResourceLocation location, BufferedImage image) {
        CachedImage cached = new CachedImage(image);
        cached.timer = Integer.MAX_VALUE;
        images.put(location, cached);
    }

    public static void render3DLayer(ModelCustomRenderer renderer, ResourceLocation texture) {
        Integer callId;
        Map<ResourceLocation, Integer> map = layers.get((Object)renderer);
        int id = -1;
        if (map == null) {
            map = new HashMap<ResourceLocation, Integer>();
            layers.put(renderer, map);
        }
        if (!map.containsKey(texture)) {
            ModelExtrudedLayer.generateLayer(renderer, texture, map);
        }
        if ((callId = map.get(texture)) != null) {
            id = callId;
        }
        if (id != -1) {
            GL11.glCallList((int)id);
        }
    }

    public static void tickCache() {
        if (!images.isEmpty()) {
            Iterator<CachedImage> it = images.values().iterator();
            while (it.hasNext()) {
                CachedImage image = it.next();
                if (image.timer <= 0) {
                    image.image.flush();
                    it.remove();
                }
                --image.timer;
            }
        }
    }

    private static void generateLayer(ModelCustomRenderer renderer, ResourceLocation texture, Map<ResourceLocation, Integer> map) {
        int id = -1;
        try {
            CachedImage image = images.get(texture);
            if (image == null) {
                if (texture instanceof MultiResourceLocation && ((Boolean)McLib.multiskinMultiThreaded.get()).booleanValue()) {
                    MultiskinThread.add((MultiResourceLocation)((MultiResourceLocation)texture));
                    return;
                }
                image = new CachedImage(ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b()));
                images.put(texture, image);
            }
            if (image.timer > 20) {
                image.timer = 20;
            }
            Chunk chunk = ModelExtrudedLayer.fillChunk(image.image, renderer);
            if (chunk.stats > 0) {
                id = ModelExtrudedLayer.generateDisplayList(chunk, renderer);
            }
        }
        catch (Exception e) {
            System.err.println("An error occurred during construction of extruded 3D layer for texture " + texture + " and limb " + renderer.limb.name);
            e.printStackTrace();
        }
        map.put(texture, id);
    }

    private static Chunk fillChunk(BufferedImage image, ModelCustomRenderer renderer) {
        int k;
        int alpha;
        int j;
        int i;
        int threshold = 128;
        int ef = renderer.model.model.extrudeMaxFactor;
        int stepX = (int)((float)image.getWidth() / renderer.field_78801_a);
        int stepY = (int)((float)image.getHeight() / renderer.field_78799_b);
        int oStepX = stepX;
        int oStepY = stepY;
        if (ef > 1) {
            ef = Math.min(ef, Math.min(stepX, stepY));
            if (stepX > 1) {
                stepX = (int)((float)image.getWidth() / (renderer.field_78801_a * (float)ef));
            }
            if (stepY > 1) {
                stepY = (int)((float)image.getHeight() / (renderer.field_78799_b * (float)ef));
            }
        }
        int efi = MathUtils.clamp((int)renderer.model.model.extrudeInwards, (int)1, (int)ef);
        int w = renderer.limb.size[0];
        int h = renderer.limb.size[1];
        int d = renderer.limb.size[2];
        Chunk chunk = new Chunk(w, h, d, ef);
        int offsetX = renderer.limb.texture[0];
        int offsetY = renderer.limb.texture[1];
        int x = (offsetX + d) * oStepX;
        int y = offsetY * oStepY;
        for (i = 0; i < chunk.w; ++i) {
            for (j = 0; j < chunk.d; ++j) {
                alpha = image.getRGB(x + i * stepX, y + j * stepY) >> 24 & 0xFF;
                if (alpha < 128) continue;
                for (k = 0; k < efi; ++k) {
                    chunk.setBlockBit(i, chunk.h - 1 - k, j, (byte)1);
                }
            }
        }
        x = (offsetX + d + w) * oStepX;
        y = offsetY * oStepY;
        for (i = 0; i < chunk.w; ++i) {
            for (j = 0; j < chunk.h; ++j) {
                alpha = image.getRGB(x + i * stepX, y + j * stepY) >> 24 & 0xFF;
                if (alpha < 128) continue;
                for (k = 0; k < efi; ++k) {
                    chunk.setBlockBit(i, k, j, (byte)2);
                }
            }
        }
        x = (offsetX + d) * oStepX;
        y = (offsetY + d) * oStepY;
        for (i = 0; i < chunk.w; ++i) {
            for (j = 0; j < chunk.h; ++j) {
                alpha = image.getRGB(x + i * stepX, y + j * stepY) >> 24 & 0xFF;
                if (alpha < 128) continue;
                for (k = 0; k < efi; ++k) {
                    chunk.setBlockBit(i, chunk.h - j - 1, chunk.d - 1 - k, (byte)4);
                }
            }
        }
        x = (offsetX + d * 2 + w) * oStepX;
        y = (offsetY + d) * oStepY;
        for (i = 0; i < chunk.w; ++i) {
            for (j = 0; j < chunk.h; ++j) {
                alpha = image.getRGB(x + i * stepX, y + j * stepY) >> 24 & 0xFF;
                if (alpha < 128) continue;
                for (k = 0; k < efi; ++k) {
                    chunk.setBlockBit(chunk.w - i - 1, chunk.h - j - 1, k, (byte)8);
                }
            }
        }
        x = offsetX * oStepX;
        y = (offsetY + d) * oStepY;
        for (i = 0; i < chunk.d; ++i) {
            for (j = 0; j < chunk.h; ++j) {
                alpha = image.getRGB(x + i * stepX, y + j * stepY) >> 24 & 0xFF;
                if (alpha < 128) continue;
                for (k = 0; k < efi; ++k) {
                    chunk.setBlockBit(k, chunk.h - j - 1, i, (byte)16);
                }
            }
        }
        x = (offsetX + d + w) * oStepX;
        y = (offsetY + d) * oStepY;
        for (i = 0; i < chunk.d; ++i) {
            for (j = 0; j < chunk.h; ++j) {
                int xx = x + i * stepX;
                int yy = y + j * stepY;
                int color = image.getRGB(xx, yy);
                int alpha2 = color >> 24 & 0xFF;
                if (alpha2 < 128) continue;
                for (int k2 = 0; k2 < efi; ++k2) {
                    chunk.setBlockBit(chunk.w - 1 - k2, chunk.h - j - 1, chunk.d - i - 1, (byte)32);
                }
            }
        }
        return chunk;
    }

    private static int generateDisplayList(Chunk chunk, ModelCustomRenderer renderer) {
        int id = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)id, (int)4864);
        ModelExtrudedLayer.generateGeometry(chunk, renderer);
        GlStateManager.func_187415_K();
        return id;
    }

    private static void generateGeometry(Chunk chunk, ModelCustomRenderer renderer) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        int ef = chunk.ef;
        int w = renderer.limb.size[0] * ef;
        int h = renderer.limb.size[1] * ef;
        int d = renderer.limb.size[2] * ef;
        float f = 0.0625f / (float)ef;
        float so = renderer.limb.sizeOffset * (float)ef;
        float tw = renderer.field_78801_a * (float)ef;
        float th = renderer.field_78799_b * (float)ef;
        int offsetX = renderer.limb.texture[0] * ef;
        int offsetY = renderer.limb.texture[1] * ef;
        boolean mirror = renderer.limb.mirror;
        Offset off = new Offset(0.0f, 0.0f);
        Offset offmax = new Offset(0.0f, 0.0f);
        buffer.func_181668_a(7, VertexBuilder.getFormat((boolean)false, (boolean)true, (boolean)false, (boolean)true));
        for (int x = 0; x < chunk.w; ++x) {
            for (int y = 0; y < chunk.h; ++y) {
                for (int z = 0; z < chunk.d; ++z) {
                    int blockX = mirror ? w - x - 1 : x;
                    byte block = chunk.getBlock(blockX, y, z);
                    if (block == 0) continue;
                    float sw = (float)w + so * 2.0f;
                    float sh = (float)h + so * 2.0f;
                    float sd = (float)d + so * 2.0f;
                    float aX = -renderer.limb.anchor[0] * sw + sw;
                    float aY = -renderer.limb.anchor[1] * sh + sh;
                    float aZ = -renderer.limb.anchor[2] * sd + sd;
                    float mnx = ((float)(x + (mirror ? 1 : 0)) * (sw / (float)w) - aX) * f;
                    float mmx = ((float)(x + (mirror ? 0 : 1)) * (sw / (float)w) - aX) * f;
                    float mny = -((float)y * (sh / (float)h) - aY) * f;
                    float mmy = -((float)(y + 1) * (sh / (float)h) - aY) * f;
                    float mnz = -((float)z * (sd / (float)d) - aZ) * f;
                    float mmz = -((float)(z + 1) * (sd / (float)d) - aZ) * f;
                    if (!chunk.hasBlock(blockX, y + 1, z)) {
                        if (!ModelExtrudedLayer.calculateOffset(off, offmax, (byte)(block & 1), offsetX, offsetY, w, h, d, blockX, y, z, tw, th)) {
                            ModelExtrudedLayer.calculateOffset(off, offmax, block, offsetX, offsetY, w, h, d, blockX, y, z, tw, th);
                        }
                        buffer.func_181662_b((double)mnx, (double)mmy, (double)mnz).func_187315_a((double)off.x, (double)off.y).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        buffer.func_181662_b((double)mnx, (double)mmy, (double)mmz).func_187315_a((double)off.x, (double)offmax.y).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mmy, (double)mmz).func_187315_a((double)offmax.x, (double)offmax.y).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mmy, (double)mnz).func_187315_a((double)offmax.x, (double)off.y).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    }
                    if (!chunk.hasBlock(blockX, y - 1, z)) {
                        if (!ModelExtrudedLayer.calculateOffset(off, offmax, (byte)(block & 2), offsetX, offsetY, w, h, d, blockX, y, z, tw, th)) {
                            ModelExtrudedLayer.calculateOffset(off, offmax, block, offsetX, offsetY, w, h, d, blockX, y, z, tw, th);
                        }
                        buffer.func_181662_b((double)mnx, (double)mny, (double)mnz).func_187315_a((double)off.x, (double)off.y).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mny, (double)mnz).func_187315_a((double)offmax.x, (double)off.y).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mny, (double)mmz).func_187315_a((double)offmax.x, (double)offmax.y).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        buffer.func_181662_b((double)mnx, (double)mny, (double)mmz).func_187315_a((double)off.x, (double)offmax.y).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    }
                    if (!chunk.hasBlock(blockX, y, z + 1)) {
                        if (!ModelExtrudedLayer.calculateOffset(off, offmax, (byte)(block & 4), offsetX, offsetY, w, h, d, blockX, y, z, tw, th)) {
                            ModelExtrudedLayer.calculateOffset(off, offmax, block, offsetX, offsetY, w, h, d, blockX, y, z, tw, th);
                        }
                        buffer.func_181662_b((double)mnx, (double)mmy, (double)mmz).func_187315_a((double)off.x, (double)off.y).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                        buffer.func_181662_b((double)mnx, (double)mny, (double)mmz).func_187315_a((double)off.x, (double)offmax.y).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mny, (double)mmz).func_187315_a((double)offmax.x, (double)offmax.y).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mmy, (double)mmz).func_187315_a((double)offmax.x, (double)off.y).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    }
                    if (!chunk.hasBlock(blockX, y, z - 1)) {
                        if (!ModelExtrudedLayer.calculateOffset(off, offmax, (byte)(block & 8), offsetX, offsetY, w, h, d, blockX, y, z, tw, th)) {
                            ModelExtrudedLayer.calculateOffset(off, offmax, block, offsetX, offsetY, w, h, d, blockX, y, z, tw, th);
                        }
                        buffer.func_181662_b((double)mnx, (double)mmy, (double)mnz).func_187315_a((double)offmax.x, (double)off.y).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mmy, (double)mnz).func_187315_a((double)off.x, (double)off.y).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mny, (double)mnz).func_187315_a((double)off.x, (double)offmax.y).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        buffer.func_181662_b((double)mnx, (double)mny, (double)mnz).func_187315_a((double)offmax.x, (double)offmax.y).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    }
                    if (!chunk.hasBlock(blockX + 1, y, z)) {
                        if (!ModelExtrudedLayer.calculateOffset(off, offmax, (byte)(block & 0x20), offsetX, offsetY, w, h, d, blockX, y, z, tw, th)) {
                            ModelExtrudedLayer.calculateOffset(off, offmax, block, offsetX, offsetY, w, h, d, blockX, y, z, tw, th);
                        }
                        buffer.func_181662_b((double)mmx, (double)mmy, (double)mnz).func_187315_a((double)offmax.x, (double)off.y).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mmy, (double)mmz).func_187315_a((double)off.x, (double)off.y).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mny, (double)mmz).func_187315_a((double)off.x, (double)offmax.y).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                        buffer.func_181662_b((double)mmx, (double)mny, (double)mnz).func_187315_a((double)offmax.x, (double)offmax.y).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    }
                    if (chunk.hasBlock(blockX - 1, y, z)) continue;
                    if (!ModelExtrudedLayer.calculateOffset(off, offmax, (byte)(block & 0x10), offsetX, offsetY, w, h, d, blockX, y, z, tw, th)) {
                        ModelExtrudedLayer.calculateOffset(off, offmax, block, offsetX, offsetY, w, h, d, blockX, y, z, tw, th);
                    }
                    buffer.func_181662_b((double)mnx, (double)mmy, (double)mnz).func_187315_a((double)off.x, (double)off.y).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)mnx, (double)mny, (double)mnz).func_187315_a((double)off.x, (double)offmax.y).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)mnx, (double)mny, (double)mmz).func_187315_a((double)offmax.x, (double)offmax.y).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)mnx, (double)mmy, (double)mmz).func_187315_a((double)offmax.x, (double)off.y).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                }
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private static boolean calculateOffset(Offset offset, Offset max, byte block, int offsetX, int offsetY, int w, int h, int d, int x, int y, int z, float tw, float th) {
        float offX = -1.0f;
        float offY = -1.0f;
        if ((block & 1) != 0) {
            offX = offsetX + d + x;
            offY = offsetY + z;
        } else if ((block & 2) != 0) {
            offX = offsetX + d + w + x;
            offY = offsetY + z;
        } else if ((block & 4) != 0) {
            offX = offsetX + d + x;
            offY = offsetY + d + h - y - 1;
        } else if ((block & 8) != 0) {
            offX = offsetX + d * 2 + w * 2 - x - 1;
            offY = offsetY + d + h - y - 1;
        } else if ((block & 0x10) != 0) {
            offX = offsetX + z;
            offY = offsetY + d + h - y - 1;
        } else if ((block & 0x20) != 0) {
            offX = offsetX + d + w + d - z - 1;
            offY = offsetY + d + h - y - 1;
        }
        if (offX == -1.0f && offY == -1.0f) {
            return false;
        }
        float offMX = (offX + 1.0f) / tw;
        float offMY = (offY + 1.0f) / th;
        offset.set(offX /= tw, offY /= th);
        max.set(offMX, offMY);
        return true;
    }

    public static void clear() {
        for (Map<ResourceLocation, Integer> map : layers.values()) {
            for (Integer i : map.values()) {
                if (i == -1) continue;
                GL11.glDeleteLists((int)i, (int)1);
            }
        }
        layers.clear();
    }

    public static void clearByTexture(ResourceLocation texture) {
        for (Map<ResourceLocation, Integer> map : layers.values()) {
            int i;
            if (!map.containsKey(texture) || (i = map.remove(texture).intValue()) == -1) continue;
            GL11.glDeleteLists((int)i, (int)1);
        }
    }

    public static void clearByModel(ModelCustom model) {
        if (model == null) {
            return;
        }
        for (ModelCustomRenderer renderer : model.limbs) {
            Map<ResourceLocation, Integer> map;
            if (!renderer.limb.is3D || (map = layers.remove((Object)renderer)) == null) continue;
            for (Integer i : map.values()) {
                GL11.glDeleteLists((int)i, (int)1);
            }
        }
    }

    public static class Offset {
        public float x;
        public float y;

        public Offset(float x, float y) {
            this.set(x, y);
        }

        public void set(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Chunk {
        protected byte[] data;
        public final int w;
        public final int h;
        public final int d;
        public int stats;
        public int ef;

        public Chunk(int w, int h, int d, int ef) {
            this.w = w *= ef;
            this.h = h *= ef;
            this.d = d *= ef;
            this.ef = ef;
            this.data = new byte[w * h * d];
        }

        public void setBlock(int x, int y, int z, byte block) {
            if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
                return;
            }
            byte old = this.data[x + y * this.w + z * this.w * this.h];
            this.data[x + y * this.w + z * this.w * this.h] = block;
            if (block != old) {
                this.stats += block == 0 ? -1 : 1;
            }
        }

        public void setBlockBit(int x, int y, int z, byte bit) {
            byte block;
            if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
                return;
            }
            byte old = this.data[x + y * this.w + z * this.w * this.h];
            this.data[x + y * this.w + z * this.w * this.h] = block = (byte)(old | bit);
            if (block != old) {
                this.stats += block == 0 ? -1 : 1;
            }
        }

        public boolean hasBlock(int x, int y, int z) {
            return this.getBlock(x, y, z) != 0;
        }

        public byte getBlock(int x, int y, int z) {
            if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
                return 0;
            }
            return this.data[x + y * this.w + z * this.w * this.h];
        }
    }

    public static class CachedImage {
        public BufferedImage image;
        public int timer = 10;

        public CachedImage(BufferedImage image) {
            this.image = image;
        }
    }
}

