/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.model.parsing;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.ModelUtils;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.ResourceLocation;

public class ModelExporter {
    private EntityLivingBase entity;
    private RenderLivingBase<EntityLivingBase> render;
    private int limbId;

    public ModelExporter(EntityLivingBase entity, RenderLivingBase<EntityLivingBase> render) {
        this.entity = entity;
        this.render = render;
    }

    private ModelBase getModel() {
        return this.render.func_177087_b();
    }

    public Model exportModel(String name) {
        Model data = new Model();
        this.limbId = 0;
        this.render.func_76986_a(this.entity, 0.0, -420.0, 0.0, 0.0f, 0.0f);
        ModelBase model = this.getModel();
        this.setupProperties(data, model, name);
        Map<String, ModelRenderer> limbs = this.generateLimbs(data, model);
        this.render.func_76986_a(this.entity, 0.0, -420.0, 0.0, 0.0f, 0.0f);
        this.savePose("standing", data, limbs);
        this.savePose("sleeping", data, limbs);
        this.savePose("flying", data, limbs);
        this.setSneaking(this.entity);
        if (this.render.func_177087_b() instanceof ModelBiped) {
            ModelBiped biped = (ModelBiped)this.render.func_177087_b();
            boolean old = biped.field_78117_n;
            biped.field_78117_n = true;
            this.render.func_76986_a(this.entity, 0.0, -420.0, 0.0, 0.0f, 0.0f);
            biped.field_78117_n = old;
        } else {
            this.render.func_76986_a(this.entity, 0.0, -420.0, 0.0, 0.0f, 0.0f);
        }
        this.savePose("sneaking", data, limbs);
        this.setDefaultTexture(data);
        return data;
    }

    public String exportJSON(String name) {
        return ModelUtils.toJson(this.exportModel(name));
    }

    private void setDefaultTexture(Model data) {
        Class<Render> clazz = Render.class;
        for (Method method : clazz.getDeclaredMethods()) {
            Class<?>[] args = method.getParameterTypes();
            boolean hasEntityArg = args.length == 1 && args[0].isAssignableFrom(Entity.class);
            boolean returnsRL = method.getReturnType().isAssignableFrom(ResourceLocation.class);
            if (!hasEntityArg || !returnsRL) continue;
            try {
                method.setAccessible(true);
                data.defaultTexture = (ResourceLocation)method.invoke(this.render, this.entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
    }

    private void setSneaking(EntityLivingBase entity) {
        if (entity instanceof EntityTameable) {
            ((EntityTameable)entity).func_70904_g(true);
        } else {
            entity.func_70095_a(true);
        }
    }

    private void savePose(String poseName, Model data, Map<String, ModelRenderer> limbs) {
        ModelPose pose = new ModelPose();
        float width = this.entity.field_70130_N;
        float height = this.entity.field_70131_O;
        pose.size = new float[]{width, height, width};
        for (Map.Entry<String, ModelRenderer> entry : limbs.entrySet()) {
            String key = entry.getKey();
            ModelRenderer renderer = entry.getValue();
            ModelTransform transform = new ModelTransform();
            float PI = (float)Math.PI;
            float rx = renderer.field_78795_f * 180.0f / PI;
            float ry = renderer.field_78796_g * 180.0f / PI;
            float rz = renderer.field_78808_h * 180.0f / PI;
            float x = renderer.field_78800_c;
            float y = renderer.field_78797_d;
            float z = renderer.field_78798_e;
            if (data.limbs.get((Object)key).parent.isEmpty()) {
                x *= -1.0f;
                y = -(y - 24.0f);
                z *= -1.0f;
            } else {
                x *= -1.0f;
                y *= -1.0f;
                z *= -1.0f;
            }
            transform.rotate = new float[]{rx, ry, rz};
            transform.translate = new float[]{x, y, z};
            pose.limbs.put(key, transform);
        }
        data.poses.put(poseName, pose);
    }

    private void setupProperties(Model data, ModelBase model, String name) {
        data.name = name;
        data.texture = new int[]{model.field_78090_t, model.field_78089_u};
    }

    private Map<String, ModelRenderer> generateLimbs(Model data, ModelBase model) {
        HashMap<String, ModelRenderer> limbs = new HashMap<String, ModelRenderer>();
        int width = 0;
        int height = 0;
        for (ModelRenderer renderer : this.getModelRenderers(model)) {
            this.generateLimbs(limbs, renderer, data, model, "");
            width = Math.max(width, (int)renderer.field_78801_a);
            height = Math.max(height, (int)renderer.field_78799_b);
        }
        if (data.texture[0] != width || data.texture[1] != height && width != 0 && height != 0) {
            data.texture = new int[]{width, height};
        }
        return limbs;
    }

    private void generateLimbs(Map<String, ModelRenderer> limbs, ModelRenderer renderer, Model data, ModelBase model, String parentName) {
        int j = 0;
        String firstName = "";
        for (ModelBox box : renderer.field_78804_l) {
            String name;
            ModelLimb limb = new ModelLimb();
            String boxName = box.field_78247_g != null ? box.field_78247_g : "";
            String string = name = boxName.isEmpty() ? "limb_" + this.limbId : boxName;
            if (j == 0) {
                limb.mirror = renderer.field_78809_i;
                limb.parent = parentName;
                firstName = name;
                limbs.put(name, renderer);
            } else {
                limb.parent = firstName;
            }
            limb.size = this.getModelSize(box);
            limb.texture = this.getModelOffset(box, renderer, model);
            limb.anchor = this.getAnchor(box, limb.size);
            data.limbs.put(name, limb);
            ++this.limbId;
            ++j;
        }
        if (renderer.field_78805_m == null) {
            return;
        }
        for (ModelRenderer child : renderer.field_78805_m) {
            this.generateLimbs(limbs, child, data, model, firstName);
        }
    }

    private int[] getModelSize(ModelBox box) {
        int w = (int)(box.field_78248_d - box.field_78252_a);
        int h = (int)(box.field_78249_e - box.field_78250_b);
        int d = (int)(box.field_78246_f - box.field_78251_c);
        return new int[]{w, h, d};
    }

    private int[] getModelOffset(ModelBox box, ModelRenderer renderer, ModelBase model) {
        TexturedQuad[] quads;
        TextureOffset offset = model.func_78084_a(box.field_78247_g);
        if (offset != null) {
            return new int[]{offset.field_78783_a, offset.field_78782_b};
        }
        int[] zero = new int[]{0, 0};
        Field field = this.getFieldByType(TexturedQuad[].class, ModelBox.class);
        field.setAccessible(true);
        try {
            quads = (TexturedQuad[])field.get(box);
        }
        catch (Exception e) {
            e.printStackTrace();
            return zero;
        }
        float minX = 1.0f;
        float minY = 1.0f;
        for (TexturedQuad quad : quads) {
            for (PositionTextureVertex vertex : quad.field_78239_a) {
                minX = Math.min(vertex.field_78241_b, minX);
                minY = Math.min(vertex.field_78242_c, minY);
            }
        }
        return new int[]{(int)(minX *= renderer.field_78801_a), (int)(minY *= renderer.field_78799_b)};
    }

    private float[] getAnchor(ModelBox box, int[] size) {
        float w = size[0] != 0 ? -box.field_78252_a / (float)size[0] : 0.0f;
        float h = size[1] != 0 ? -box.field_78250_b / (float)size[1] : 0.0f;
        float d = size[2] != 0 ? -box.field_78251_c / (float)size[2] : 0.0f;
        return new float[]{w, h, d};
    }

    private List<ModelRenderer> getModelRenderers(ModelBase model) {
        ArrayList<ModelRenderer> renderers = new ArrayList<ModelRenderer>();
        Class<ModelRenderer> rClass = ModelRenderer.class;
        Class<ModelRenderer[]> aRClass = ModelRenderer[].class;
        for (Field field : ModelExporter.getInheritedFields(model.getClass())) {
            Class<Object> type = field.getType();
            if (!type.isAssignableFrom(rClass) && !type.isAssignableFrom(aRClass)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                ModelRenderer[] moreRenderers;
                if (type.isAssignableFrom(rClass)) {
                    ModelRenderer renderer = (ModelRenderer)field.get(model);
                    if (renderer == null || renderers.indexOf(renderer) != -1) continue;
                    renderers.add(renderer);
                    continue;
                }
                if (!type.isAssignableFrom(aRClass)) continue;
                for (ModelRenderer renderer : moreRenderers = (ModelRenderer[])field.get(model)) {
                    if (renderer == null || renderers.indexOf(renderer) != -1) continue;
                    renderers.add(renderer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<ModelRenderer> roots = new ArrayList<ModelRenderer>();
        for (ModelRenderer child : renderers) {
            boolean isChild = false;
            for (ModelRenderer parent : renderers) {
                if (parent.field_78805_m == null || !parent.field_78805_m.contains(child)) continue;
                isChild = true;
                break;
            }
            if (isChild) continue;
            roots.add(child);
        }
        return roots;
    }

    private Field getFieldByType(Class<?> type, Class<?> subject) {
        for (Field field : subject.getDeclaredFields()) {
            if (!field.getType().equals(type)) continue;
            return field;
        }
        return null;
    }

    public static List<Field> getInheritedFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }
}

