/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.model;

import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.api.formats.Mesh;
import mchorse.blockbuster.api.formats.vox.MeshesVOX;
import mchorse.blockbuster.api.formats.vox.data.VoxTexture;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import mchorse.blockbuster.client.render.RenderCustomModel;
import mchorse.mclib.client.render.VertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelVoxRenderer
extends ModelCustomRenderer {
    public static final ResourceLocation VOXTEX = new ResourceLocation("blockbuster", "textures/dynamic_vox");
    public MeshesVOX mesh;
    public VoxTexture texture;

    public ModelVoxRenderer(ModelCustom model, ModelLimb limb, ModelTransform transform, MeshesVOX mesh) {
        super(model, limb, transform);
        this.mesh = mesh;
        this.min = mesh.getMin();
        this.max = mesh.getMax();
    }

    @Override
    protected void func_78788_d(float scale) {
        if (this.mesh != null) {
            BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
            Mesh mesh = this.mesh.mesh;
            int id = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)id, (int)4864);
            renderer.func_181668_a(4, VertexBuilder.getFormat((boolean)false, (boolean)true, (boolean)false, (boolean)true));
            int c = mesh.triangles;
            for (int i = 0; i < c; ++i) {
                float x = (mesh.posData[i * 3] - this.limb.origin[0]) / 16.0f;
                float y = -(mesh.posData[i * 3 + 1] - this.limb.origin[1]) / 16.0f;
                float z = (mesh.posData[i * 3 + 2] - this.limb.origin[2]) / 16.0f;
                float u = mesh.texData[i * 2];
                float v = mesh.texData[i * 2 + 1];
                float nx = mesh.normData[i * 3];
                float ny = -mesh.normData[i * 3 + 1];
                float nz = mesh.normData[i * 3 + 2];
                renderer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)u, (double)v).func_181663_c(nx, ny, nz).func_181675_d();
                if (i % 3 != 2) continue;
                VertexBuilder.calcTangent((BufferBuilder)renderer, (boolean)false);
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_187415_K();
            this.field_78811_r = id;
            this.texture = new VoxTexture(this.mesh.document.palette, this.limb.specular);
            this.field_78812_q = true;
            this.mesh = null;
        } else {
            super.func_78788_d(scale);
        }
    }

    @Override
    protected void renderDisplayList() {
        if (this.texture != null) {
            TextureManager mgr = Minecraft.func_71410_x().func_110434_K();
            mgr.func_110579_a(VOXTEX, (ITextureObject)this.texture);
            mgr.func_110577_a(VOXTEX);
            GL11.glCallList((int)this.field_78811_r);
            RenderCustomModel.bindLastTexture();
        }
    }

    @Override
    public void delete() {
        super.delete();
        if (this.texture != null) {
            this.texture.func_147631_c();
            this.texture = null;
        }
    }
}

