/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.api.formats.obj.ShapeKey;
import mchorse.blockbuster.client.KeyboardHandler;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import mchorse.blockbuster.client.model.ModelOBJRenderer;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.OrientedBB;
import mchorse.blockbuster.common.item.ItemGun;
import mchorse.blockbuster.utils.EntityUtils;
import mchorse.blockbuster.utils.NBTUtils;
import mchorse.blockbuster_pack.morphs.CustomMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelCustom
extends ModelBiped {
    public static final Map<String, ModelCustom> MODELS = new HashMap<String, ModelCustom>();
    public Model model;
    public ModelPose pose;
    public CustomMorph current;
    public ModelCustomRenderer[] limbs;
    public ModelCustomRenderer[] renderable;
    public ModelCustomRenderer[] left;
    public ModelCustomRenderer[] right;
    public ModelCustomRenderer[] armor;
    public Map<String, ResourceLocation> materials;
    public List<ShapeKey> shapes;

    public ModelCustom(Model model) {
        this.model = model;
        this.field_78090_t = model.texture[0];
        this.field_78089_u = model.texture[1];
    }

    public ModelCustomRenderer get(String name) {
        for (ModelCustomRenderer renderer : this.limbs) {
            if (!renderer.limb.name.equals(name)) continue;
            return renderer;
        }
        return null;
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        boolean keying = this.current != null && this.current.keying;
        GlStateManager.func_179147_l();
        if (keying) {
            GlStateManager.func_187398_d((int)32779);
            GlStateManager.func_179112_b((int)0, (int)0);
        } else {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        if (this.current != null) {
            for (List list : this.current.orientedBBlimbs.values()) {
                for (OrientedBB obb : list) {
                    obb.center.set(entityIn.field_70169_q + (entityIn.field_70165_t - entityIn.field_70169_q) * (double)Minecraft.func_71410_x().func_184121_ak(), entityIn.field_70167_r + (entityIn.field_70163_u - entityIn.field_70167_r) * (double)Minecraft.func_71410_x().func_184121_ak(), entityIn.field_70166_s + (entityIn.field_70161_v - entityIn.field_70166_s) * (double)Minecraft.func_71410_x().func_184121_ak());
                }
            }
        }
        for (ModelCustomRenderer limb : this.renderable) {
            limb.func_78785_a(scale);
        }
        if (keying) {
            GlStateManager.func_187398_d((int)32774);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        GlStateManager.func_179084_k();
        this.current = null;
    }

    public void renderForStencil(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (int i = 0; i < this.limbs.length; ++i) {
            this.limbs[i].setupStencilRendering(i + 1);
        }
        for (ModelCustomRenderer limb : this.renderable) {
            limb.func_78785_a(scale);
        }
        GlStateManager.func_179084_k();
    }

    public void setHands(EntityLivingBase entity) {
        ItemStack rightItem = entity.func_184614_ca();
        ItemStack leftItem = entity.func_184592_cb();
        ModelBiped.ArmPose right = ModelBiped.ArmPose.EMPTY;
        ModelBiped.ArmPose left = ModelBiped.ArmPose.EMPTY;
        if (!rightItem.func_190926_b()) {
            right = ModelBiped.ArmPose.ITEM;
            if (entity.func_184605_cv() > 0) {
                EnumAction enumaction = rightItem.func_77975_n();
                if (enumaction == EnumAction.BLOCK) {
                    right = ModelBiped.ArmPose.BLOCK;
                } else if (enumaction == EnumAction.BOW) {
                    right = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
            if (rightItem.func_77973_b() instanceof ItemGun) {
                GunProps props = NBTUtils.getGunProps(rightItem);
                if (props.alwaysArmsShootingPose) {
                    right = ModelBiped.ArmPose.BOW_AND_ARROW;
                } else if (props.enableArmsShootingPose && KeyboardHandler.gunShoot.func_151470_d()) {
                    right = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        if (!leftItem.func_190926_b()) {
            EnumAction action;
            left = ModelBiped.ArmPose.ITEM;
            if (entity.func_184605_cv() > 0 && (action = leftItem.func_77975_n()) == EnumAction.BLOCK) {
                left = ModelBiped.ArmPose.BLOCK;
            }
        }
        this.field_187076_m = right;
        this.field_187075_l = left;
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            this.setHands((EntityLivingBase)entityIn);
        } else {
            this.field_187075_l = ModelBiped.ArmPose.EMPTY;
            this.field_187076_m = ModelBiped.ArmPose.EMPTY;
        }
        for (ModelCustomRenderer limb : this.limbs) {
            boolean mirror = limb.limb.mirror;
            boolean invert = limb.limb.invert;
            if (limb instanceof ModelOBJRenderer) {
                ModelOBJRenderer obj = (ModelOBJRenderer)limb;
                obj.materials = this.materials;
                obj.shapes = this.shapes;
            }
            float factor = mirror ^ invert ? -1.0f : 1.0f;
            float PI = (float)Math.PI;
            float anim = this.applyLimbPose(limb);
            float rotateX = limb.field_78795_f;
            float rotateY = limb.field_78796_g;
            float rotateZ = limb.field_78808_h;
            if (limb.limb.cape && entityIn instanceof EntityLivingBase && this.current != null) {
                float partialTicks = Minecraft.func_71410_x().func_184121_ak();
                EntityLivingBase living = (EntityLivingBase)entityIn;
                double dX = this.current.prevCapeX + (this.current.capeX - this.current.prevCapeX) * (double)partialTicks - (living.field_70169_q + (living.field_70165_t - living.field_70169_q) * (double)partialTicks);
                double dY = this.current.prevCapeY + (this.current.capeY - this.current.prevCapeY) * (double)partialTicks - (living.field_70167_r + (living.field_70163_u - living.field_70167_r) * (double)partialTicks);
                double dZ = this.current.prevCapeZ + (this.current.capeZ - this.current.prevCapeZ) * (double)partialTicks - (living.field_70166_s + (living.field_70161_v - living.field_70166_s) * (double)partialTicks);
                float bodyYaw = living.field_70760_ar + (living.field_70761_aq - living.field_70760_ar) * partialTicks;
                double sin = MathHelper.func_76126_a((float)(bodyYaw / 180.0f * PI));
                double cos = -MathHelper.func_76134_b((float)(bodyYaw / 180.0f * PI));
                float h = (float)MathHelper.func_151237_a((double)(dY * 10.0), (double)-6.0, (double)32.0);
                float pitch = (float)(dX * sin + dZ * cos) * 100.0f;
                float yaw = (float)(dX * cos - dZ * sin) * 100.0f;
                if (pitch > 0.0f) {
                    pitch = -pitch;
                }
                float cameraYaw = 0.0f;
                if (living instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)living;
                    cameraYaw = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * partialTicks;
                }
                limb.field_78795_f += (6.0f + pitch / 2.0f + (h += MathHelper.func_76126_a((float)((living.field_70141_P + (living.field_70140_Q - living.field_70141_P) * partialTicks) * 6.0f)) * 32.0f * cameraYaw)) / 180.0f * PI;
                limb.field_78796_g += yaw / 2.0f * 0.0f / 180.0f * PI;
            }
            if ((limb.limb.lookX || limb.limb.lookY) && !limb.limb.wheel) {
                if (limb.limb.lookX) {
                    limb.field_78795_f += headPitch * ((float)Math.PI / 180);
                }
                if (limb.limb.lookY) {
                    if (invert) {
                        limb.field_78808_h += netHeadYaw * ((float)Math.PI / 180);
                    } else {
                        limb.field_78796_g += netHeadYaw * ((float)Math.PI / 180);
                    }
                }
            }
            if (limb.limb.swinging) {
                boolean flag = entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_184599_cB() > 4;
                float f = 1.0f;
                if (flag) {
                    f = (float)(entityIn.field_70159_w * entityIn.field_70159_w + entityIn.field_70181_x * entityIn.field_70181_x + entityIn.field_70179_y * entityIn.field_70179_y);
                    f /= 0.2f;
                    f = f * f * f;
                }
                if (f < 1.0f) {
                    f = 1.0f;
                }
                float f2 = mirror ^ invert ? 1.0f : 0.0f;
                float f3 = limb.limb.holding == ModelLimb.Holding.NONE ? 1.4f : 1.0f;
                limb.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + PI * f2)) * f3 * limbSwingAmount / f;
            }
            if (limb.limb.idle) {
                limb.field_78808_h += (MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f) * factor;
                limb.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f * factor;
            }
            if (limb.limb.swiping && !limb.limb.wing && this.field_78095_p > 0.0f) {
                float swing = this.field_78095_p;
                float bodyY = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swing) * PI * 2.0f)) * 0.2f;
                swing = 1.0f - swing;
                swing = swing * swing * swing;
                swing = 1.0f - swing;
                float sinSwing = MathHelper.func_76126_a((float)(swing * PI));
                float sinSwing2 = MathHelper.func_76126_a((float)(this.field_78095_p * PI)) * 0.7f * 0.75f;
                limb.field_78795_f -= sinSwing * 1.2f + sinSwing2;
                limb.field_78796_g += bodyY * 2.0f * factor;
                limb.field_78808_h += MathHelper.func_76126_a((float)(this.field_78095_p * PI)) * -0.4f * factor;
            }
            if (limb.limb.holding != ModelLimb.Holding.NONE) {
                boolean right = limb.limb.holding == ModelLimb.Holding.RIGHT;
                ModelBiped.ArmPose pose = right ? this.field_187076_m : this.field_187075_l;
                ModelBiped.ArmPose opposite = right ? this.field_187075_l : this.field_187076_m;
                switch (pose) {
                    case BLOCK: {
                        limb.field_78795_f = limb.field_78795_f * 0.5f - 0.9424779f;
                        limb.field_78796_g = 0.5235988f * (float)(right ? -1 : 1);
                        break;
                    }
                    case ITEM: {
                        if (!limb.limb.hold) break;
                        limb.field_78795_f = limb.field_78795_f * 0.5f - PI / 10.0f;
                    }
                }
                float rotateAngleX = headPitch * ((float)Math.PI / 180);
                float rotateAngleY = netHeadYaw * ((float)Math.PI / 180);
                if (right && pose == ModelBiped.ArmPose.BOW_AND_ARROW) {
                    limb.field_78796_g = -0.1f + rotateAngleY - 0.4f;
                    limb.field_78796_g = 0.1f + rotateAngleY;
                    limb.field_78795_f = -1.5707964f + rotateAngleX;
                    limb.field_78795_f = -1.5707964f + rotateAngleX;
                } else if (!right && opposite == ModelBiped.ArmPose.BOW_AND_ARROW) {
                    limb.field_78796_g = -0.1f + rotateAngleY;
                    limb.field_78796_g = 0.1f + rotateAngleY + 0.4f;
                    limb.field_78795_f = -1.5707964f + rotateAngleX;
                    limb.field_78795_f = -1.5707964f + rotateAngleX;
                }
            }
            if (limb.limb.wheel) {
                limb.field_78795_f += limbSwing * factor;
                if (limb.limb.lookY) {
                    limb.field_78796_g = netHeadYaw / 180.0f * (float)Math.PI;
                }
            }
            if (limb.limb.wing) {
                float wingFactor = MathHelper.func_76134_b((float)(ageInTicks * 1.3f)) * (float)Math.PI * 0.25f * (0.5f + limbSwingAmount) * factor;
                if (limb.limb.swiping) {
                    limb.field_78808_h = wingFactor;
                } else {
                    limb.field_78796_g = wingFactor;
                }
            }
            if (limb.limb.roll) {
                limb.field_78808_h += -EntityUtils.getRoll(entityIn, ageInTicks % 1.0f) / 180.0f * PI;
            }
            limb.field_78795_f = (limb.field_78795_f - rotateX) * anim + rotateX;
            limb.field_78796_g = (limb.field_78796_g - rotateY) * anim + rotateY;
            limb.field_78808_h = (limb.field_78808_h - rotateZ) * anim + rotateZ;
        }
    }

    public float applyLimbPose(ModelCustomRenderer limb) {
        ModelTransform trans = this.pose.limbs.get(limb.limb.name);
        limb.applyTransform(trans == null ? ModelTransform.DEFAULT : trans);
        if (trans instanceof CustomMorph.LimbProperties) {
            return 1.0f - ((CustomMorph.LimbProperties)trans).fixed;
        }
        return 1.0f;
    }

    public ModelCustomRenderer[] getRenderForArm(EnumHandSide side) {
        if (side == EnumHandSide.LEFT) {
            return this.left;
        }
        if (side == EnumHandSide.RIGHT) {
            return this.right;
        }
        return null;
    }

    public void delete() {
        for (ModelCustomRenderer renderer : this.limbs) {
            renderer.delete();
        }
    }
}

