/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections;

import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.GuiSectionManager;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.GuiSnowstorm;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormSection;
import mchorse.blockbuster.client.particles.BedrockMaterial;
import mchorse.blockbuster.client.particles.BedrockScheme;
import mchorse.blockbuster.client.particles.components.appearance.BedrockComponentAppearanceBillboard;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTexturePicker;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiSnowstormGeneralSection
extends GuiSnowstormSection {
    public GuiTextElement identifier;
    public GuiButtonElement pick;
    public GuiCirculateElement material;
    public GuiCirculateElement play;
    public GuiTexturePicker texture;

    public GuiSnowstormGeneralSection(Minecraft mc, GuiSnowstorm parent) {
        super(mc, parent);
        this.identifier = new GuiTextElement(mc, 100, str -> {
            this.scheme.identifier = str;
            this.parent.dirty();
        });
        this.identifier.tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.general.identifier"));
        this.pick = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.snowstorm.general.pick"), b -> {
            GuiElement container = this.getParentContainer();
            this.texture.fill(this.scheme.texture);
            this.texture.flex().relative(container).wh(1.0f, 1.0f);
            this.texture.resize();
            container.add((IGuiElement)this.texture);
        });
        this.material = new GuiCirculateElement(mc, b -> {
            this.scheme.material = BedrockMaterial.values()[this.material.getValue()];
            this.parent.dirty();
        });
        this.material.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.general.particles_opaque"));
        this.material.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.general.particles_alpha"));
        this.material.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.general.particles_blend"));
        this.material.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.general.particles_additive"));
        this.texture = new GuiTexturePicker(mc, rl -> {
            if (rl == null) {
                rl = BedrockScheme.DEFAULT_TEXTURE;
            }
            this.setTextureSize((ResourceLocation)rl);
            this.scheme.texture = rl;
            this.parent.dirty();
        });
        this.play = new GuiCirculateElement(mc, b -> {
            this.parent.renderer.playing = this.play.getValue() == 0;
        });
        this.play.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.general.play_playing"));
        this.play.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.general.play_paused"));
        this.fields.add(new IGuiElement[]{this.identifier, Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.pick, this.material}), this.play});
    }

    @Override
    protected void collapseState() {
        GuiSectionManager.setDefaultState(((Object)((Object)this)).getClass().getSimpleName(), false);
        super.collapseState();
    }

    private void setTextureSize(ResourceLocation rl) {
        BedrockComponentAppearanceBillboard component = this.scheme.get(BedrockComponentAppearanceBillboard.class);
        if (component == null) {
            return;
        }
        this.mc.field_71446_o.func_110577_a(rl);
        component.textureWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        component.textureHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    @Override
    public String getTitle() {
        return "blockbuster.gui.snowstorm.general.title";
    }

    @Override
    public void setScheme(BedrockScheme scheme) {
        super.setScheme(scheme);
        this.identifier.setText(scheme.identifier);
        this.material.setValue(scheme.material.ordinal());
        this.play.setValue(0);
    }
}

