/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.snowstorm;

import mchorse.blockbuster.api.formats.obj.Vector3f;
import mchorse.blockbuster.client.particles.BedrockScheme;
import mchorse.blockbuster.client.particles.components.expiration.BedrockComponentKillPlane;
import mchorse.blockbuster.client.particles.emitter.BedrockEmitter;
import mchorse.mclib.client.Draw;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class GuiSnowstormRenderer
extends GuiModelRenderer {
    public BedrockEmitter emitter;
    public boolean playing = true;
    private Vector3f vector = new Vector3f(0.0f, 0.0f, 0.0f);

    public GuiSnowstormRenderer(Minecraft mc) {
        super(mc);
        this.emitter = new BedrockEmitter();
    }

    public void setScheme(BedrockScheme scheme) {
        this.emitter = new BedrockEmitter();
        this.emitter.setScheme(scheme);
        this.playing = true;
    }

    protected void update() {
        super.update();
        if (this.playing && this.emitter != null) {
            this.emitter.rotation.setIdentity();
            this.emitter.update();
        }
    }

    protected void drawUserModel(GuiContext context) {
        if (this.emitter == null || this.emitter.scheme == null) {
            return;
        }
        this.emitter.cYaw = this.yaw;
        this.emitter.cPitch = this.pitch;
        this.emitter.cX = this.temp.x;
        this.emitter.cY = this.temp.y;
        this.emitter.cZ = this.temp.z;
        this.emitter.perspective = 100;
        this.emitter.rotation.setIdentity();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179090_x();
        Draw.axis((float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179126_j();
        this.emitter.render(this.playing ? context.partialTicks : 1.0f);
        BedrockComponentKillPlane plane = this.emitter.scheme.get(BedrockComponentKillPlane.class);
        if (plane.a != 0.0f || plane.b != 0.0f || plane.c != 0.0f) {
            this.drawKillPlane(plane.a, plane.b, plane.c, plane.d);
        }
        GlStateManager.func_179145_e();
    }

    private void drawKillPlane(float a, float b, float c, float d) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GL11.glPointSize((float)4.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.calculate(0.0f, 0.0f, a, b, c, d);
        buffer.func_181662_b((double)this.vector.x, (double)this.vector.y, (double)this.vector.z).func_181666_a(0.0f, 1.0f, 0.0f, 0.5f).func_181675_d();
        this.calculate(1.0f, 0.0f, a, b, c, d);
        buffer.func_181662_b((double)this.vector.x, (double)this.vector.y, (double)this.vector.z).func_181666_a(0.0f, 1.0f, 0.0f, 0.5f).func_181675_d();
        this.calculate(1.0f, 1.0f, a, b, c, d);
        buffer.func_181662_b((double)this.vector.x, (double)this.vector.y, (double)this.vector.z).func_181666_a(0.0f, 1.0f, 0.0f, 0.5f).func_181675_d();
        this.calculate(0.0f, 1.0f, a, b, c, d);
        buffer.func_181662_b((double)this.vector.x, (double)this.vector.y, (double)this.vector.z).func_181666_a(0.0f, 1.0f, 0.0f, 0.5f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    private void calculate(float i, float j, float a, float b, float c, float d) {
        float radius = 5.0f;
        if (b != 0.0f) {
            this.vector.x = -5.0f + 10.0f * i;
            this.vector.z = -5.0f + 10.0f * j;
            this.vector.y = (a * this.vector.x + c * this.vector.z + d) / -b;
        } else if (a != 0.0f) {
            this.vector.y = -5.0f + 10.0f * i;
            this.vector.z = -5.0f + 10.0f * j;
            this.vector.x = (b * this.vector.y + c * this.vector.z + d) / -a;
        } else if (c != 0.0f) {
            this.vector.x = -5.0f + 10.0f * i;
            this.vector.y = -5.0f + 10.0f * j;
            this.vector.z = (b * this.vector.y + a * this.vector.x + d) / -c;
        }
    }
}

