/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.recording_editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mchorse.blockbuster.client.gui.dashboard.panels.recording_editor.GuiRecordingEditorPanel;
import mchorse.blockbuster.network.server.recording.actions.ServerHandlerActionsChange;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.ActionRegistry;
import mchorse.blockbuster.recording.actions.MorphAction;
import mchorse.blockbuster_pack.morphs.SequencerMorph;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.ScrollArea;
import mchorse.mclib.client.gui.utils.ScrollDirection;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.ICopy;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.BodyPartManager;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;

public class GuiRecordTimeline
extends GuiElement {
    public GuiRecordingEditorPanel panel;
    public ScrollArea scroll;
    public ScrollArea vertical;
    private Action current;
    private final List<List<Action>> selection = new ArrayList<List<Action>>();
    private int fromTick = -1;
    private Selection currentTick = new Selection(-1, -1);
    private Selection lastClicked = new Selection(-1, -1);
    public boolean lastDragging = false;
    public int lastX;
    public int lastY;
    private int lastLeftX;
    private int lastLeftY;
    public int lastH;
    public int lastV;
    private int movingDx = -1;
    private int movingDy = -1;
    private int areaScrollDx = -1;
    private int areaScrollDy = -1;
    public boolean canMove;
    public boolean moving;
    private boolean canSelectArea;
    private boolean selectingArea;
    public int cursor = -1;
    private boolean preventMouseReleaseSelect = false;
    private int adaptiveMaxIndex;
    private final int itemHeight = 20;
    private final int morphActionHandleWidth = 4;
    private final Set<MorphAction> selectedTimeHandles = Collections.newSetFromMap(new IdentityHashMap());
    private boolean movingMorphActionTimeHandle = false;
    private final Map<Integer, Integer> clickedTick = new HashMap<Integer, Integer>();

    public GuiRecordTimeline(Minecraft mc, GuiRecordingEditorPanel panel) {
        super(mc);
        this.scroll = new ScrollArea(34);
        this.scroll.direction = ScrollDirection.HORIZONTAL;
        this.scroll.scrollSpeed = 68;
        this.vertical = new ScrollArea(this.itemHeight);
        this.vertical.direction = ScrollDirection.VERTICAL;
        this.panel = panel;
        IKey category = IKey.lang((String)"blockbuster.gui.aperture.keys.category");
        this.keys().register(IKey.lang((String)"blockbuster.gui.aperture.keys.add_morph_action"), 50, () -> this.createAction("morph")).held(new int[]{29}).category(category);
        this.keys().register(IKey.lang((String)"blockbuster.gui.record_editor.deselect"), 1, this::deselect).category(category).active(() -> this.isActive());
        this.keys().register(IKey.lang((String)"blockbuster.gui.record_editor.select_all"), 30, this::selectAll).held(new int[]{29}).category(category);
        this.keys().register(IKey.lang((String)"blockbuster.gui.record_editor.copy"), 46, this::copyActions).held(new int[]{29}).category(category);
        this.keys().register(IKey.lang((String)"blockbuster.gui.record_editor.paste"), 47, this::pasteActions).held(new int[]{29}).category(category);
        this.keys().register(IKey.lang((String)"blockbuster.gui.record_editor.cut"), 45, this::cutActions).held(new int[]{29}).category(category);
        this.keys().register(IKey.lang((String)"blockbuster.gui.duplicate"), 32, this::dupeActions).held(new int[]{42}).category(category);
        this.keys().register(IKey.lang((String)"blockbuster.gui.remove"), 211, this::removeActions).category(category);
    }

    public int getCurrentTick() {
        return this.currentTick.tick;
    }

    public int getCurrentIndex() {
        return this.currentTick.index;
    }

    public boolean isActive() {
        return !this.selection.isEmpty() && (this.selection.size() != 1 || !this.isFrameEmpty(this.selection.get(0)));
    }

    public void resize() {
        super.resize();
        this.scroll.copy(this.area);
        this.vertical.copy(this.area);
    }

    public void reset() {
        if (this.panel.record != null) {
            this.selection.clear();
            this.selectCurrent(MathUtils.clamp((int)this.fromTick, (int)0, (int)(this.panel.record.actions.size() - 1)), -1);
            this.scroll.setSize(this.panel.record.actions.size());
            this.scroll.clamp();
            this.recalculateVertical();
        }
    }

    public void recalculateVertical() {
        int max = 0;
        if (this.panel.record != null) {
            for (List<Action> actions : this.panel.record.actions) {
                if (actions == null || actions.size() <= max) continue;
                max = actions.size();
            }
            ++max;
        }
        this.vertical.setSize(max);
        this.vertical.clamp();
    }

    public boolean mouseClicked(GuiContext context) {
        this.lastX = context.mouseX;
        this.lastY = context.mouseY;
        int tick = this.scroll.getIndex(context.mouseX, context.mouseY);
        int index = this.vertical.getIndex(context.mouseX, context.mouseY);
        this.clickedTick.put(context.mouseButton, tick);
        if (context.mouseButton == 0) {
            boolean abort = false;
            if (this.clickMorphActionTimeHandle(context.mouseX, context.mouseY)) {
                abort = true;
            }
            this.lastClicked = new Selection(tick, index);
            this.lastLeftX = this.lastX;
            this.lastLeftY = this.lastY;
            if (abort) {
                return true;
            }
        }
        if (context.mouseButton == 1) {
            if (this.moving || this.selectingArea) {
                this.preventMouseReleaseSelect = true;
            }
            this.moving = false;
            this.canMove = false;
            this.selectingArea = false;
            this.movingMorphActionTimeHandle = false;
        }
        if (context.mouseButton == 2 && this.area.isInside(context)) {
            this.lastDragging = true;
            this.lastH = this.scroll.scroll;
            this.lastV = this.vertical.scroll;
            return true;
        }
        if (super.mouseClicked(context) || this.scroll.mouseClicked(context) || this.vertical.mouseClicked(context)) {
            this.preventMouseReleaseSelect = true;
            return true;
        }
        if (this.scroll.isInside(context) && !this.moving && context.mouseButton == 0 && tick >= 0 && tick < this.panel.record.actions.size()) {
            this.selectMouseClicked(tick, index);
        }
        return false;
    }

    private List<int[]> getMorphActionHandles(int mouseX, int mouseY) {
        int tick = this.scroll.getIndex(mouseX, mouseY);
        int index = this.vertical.getIndex(mouseX, mouseY);
        ArrayList<int[]> tickHandles = new ArrayList<int[]>();
        if (tick < 0 || index < 0) {
            return tickHandles;
        }
        for (int t = tick; t >= 0; --t) {
            List<Action> actions = this.panel.record.actions.get(t);
            if (actions == null || index >= actions.size() || !(actions.get(index) instanceof MorphAction)) continue;
            MorphAction morphAction = (MorphAction)actions.get(index);
            int ticks = this.getAnimationLength(this.getMaxAnimationLengthMorph(morphAction.morph));
            int test = this.scroll.x - this.scroll.scroll + (tick + 1) * this.scroll.scrollItemSize;
            if (ticks <= 1 || tick != t + ticks - 1 || mouseX < test - this.morphActionHandleWidth) continue;
            tickHandles.add(new int[]{t, index});
        }
        return tickHandles;
    }

    private List<int[]> getMorphActionHandlesRange(int fromTick, int toTick, int fromIndex, int toIndex) {
        if (fromTick < 0 || toTick < 0 || fromIndex < 0 || toIndex < 0) {
            return new ArrayList<int[]>();
        }
        int tick0 = Math.min(fromTick, toTick);
        int tick1 = Math.max(fromTick, toTick);
        int index0 = Math.min(fromIndex, toIndex);
        int index1 = Math.max(fromIndex, toIndex);
        ArrayList<int[]> tickHandles = new ArrayList<int[]>();
        for (int t = tick1; t >= 0; --t) {
            List<Action> actions = this.panel.record.actions.get(t);
            if (actions == null || actions.isEmpty()) continue;
            for (int i = index0; i < actions.size() && i <= index1; ++i) {
                int animationEndTick;
                int ticks;
                if (!(actions.get(i) instanceof MorphAction) || (ticks = this.getAnimationLength(this.getMaxAnimationLengthMorph(((MorphAction)actions.get((int)i)).morph))) <= 1 || (animationEndTick = t + ticks - 1) < tick0 || animationEndTick > tick1) continue;
                tickHandles.add(new int[]{t, i});
            }
        }
        return tickHandles;
    }

    private boolean clickMorphActionTimeHandle(int mouseX, int mouseY) {
        List<int[]> selections = this.getMorphActionHandles(mouseX, mouseY);
        if (selections.isEmpty()) {
            this.selectedTimeHandles.clear();
            return false;
        }
        boolean cleared = false;
        List<int[]> lastClickedSelection = this.getMorphActionHandles(this.lastLeftX, this.lastLeftY);
        if (GuiScreen.func_146272_n() && !lastClickedSelection.isEmpty()) {
            int tick = this.scroll.getIndex(mouseX, mouseY);
            int index = this.vertical.getIndex(mouseX, mouseY);
            selections = this.getMorphActionHandlesRange(tick, this.lastClicked.tick, index, this.lastClicked.index);
        }
        for (int[] selection : selections) {
            int tick = selection[0];
            int index = selection[1];
            MorphAction action = (MorphAction)this.panel.record.getAction(tick, index);
            if (GuiScreen.func_146272_n()) {
                this.selectedTimeHandles.add(action);
            } else if (GuiScreen.func_146271_m()) {
                if (this.selectedTimeHandles.contains(action)) {
                    this.selectedTimeHandles.remove(action);
                } else {
                    this.selectedTimeHandles.add(action);
                }
            } else if (!this.selectedTimeHandles.contains(action)) {
                if (!cleared) {
                    this.selectedTimeHandles.clear();
                    cleared = true;
                }
                this.selectedTimeHandles.add(action);
            }
            boolean actionFound = this.selection.stream().anyMatch(frame -> {
                if (frame != null && !frame.isEmpty()) {
                    return frame.stream().anyMatch(actionTest -> actionTest == action);
                }
                return false;
            });
            this.deselect();
            if (!actionFound) continue;
            this.fromTick = tick;
            this.selectCurrentSaveOld(tick, index);
            this.preventMouseReleaseSelect = true;
        }
        this.movingMorphActionTimeHandle = true;
        return true;
    }

    private void releaseMorphActionTimeHandle(GuiContext context) {
        int tick;
        int diff;
        List<int[]> selections = this.getMorphActionHandles(context.mouseX, context.mouseY);
        for (int[] selection : selections) {
            int tick2 = selection[0];
            int index = selection[1];
            MorphAction action = (MorphAction)this.panel.record.getAction(tick2, index);
            if (GuiScreen.func_146272_n() || GuiScreen.func_146271_m() || !this.selectedTimeHandles.contains(action)) continue;
            this.selectedTimeHandles.clear();
            this.selectedTimeHandles.add(action);
            boolean actionFound = this.selection.stream().anyMatch(frame -> {
                if (frame != null && !frame.isEmpty()) {
                    return frame.stream().anyMatch(actionTest -> actionTest == action);
                }
                return false;
            });
            this.deselect();
            if (!actionFound) continue;
            this.fromTick = tick2;
            this.selectCurrentSaveOld(tick2, index);
            this.preventMouseReleaseSelect = true;
        }
        if (this.movingMorphActionTimeHandle && this.clickedTick.containsKey(0) && (diff = (tick = this.scroll.getIndex(context.mouseX, context.mouseY)) - this.clickedTick.get(0)) != 0) {
            for (MorphAction action : this.selectedTimeHandles) {
                if (action.morph == null) continue;
                if (GuiScreen.func_175283_s()) {
                    AbstractMorph morph = this.getMaxAnimationLengthMorph(action.morph);
                    if (morph instanceof IAnimationProvider) {
                        Animation animation = ((IAnimationProvider)morph).getAnimation();
                        if (animation.animates) {
                            animation.duration = Math.max(0, animation.duration + diff);
                        }
                    }
                } else {
                    this.addAnimationDuration(action.morph, diff);
                }
                int[] found = this.panel.record.findAction(action);
                ServerHandlerActionsChange.editAction(action, this.panel.record, found[0], found[1]);
            }
        }
        this.movingMorphActionTimeHandle = false;
    }

    private void addAnimationDuration(AbstractMorph morph, int delta) {
        if (morph instanceof IAnimationProvider) {
            Animation animation = ((IAnimationProvider)morph).getAnimation();
            if (animation.animates) {
                animation.duration = Math.max(0, animation.duration + delta);
            }
        }
        if (morph instanceof IBodyPartProvider) {
            BodyPartManager manager = ((IBodyPartProvider)morph).getBodyPart();
            for (BodyPart part : manager.parts) {
                if (part.morph.isEmpty() || part.limb == null || part.limb.isEmpty()) continue;
                this.addAnimationDuration(part.morph.get(), delta);
            }
        }
    }

    private void selectMouseClicked(int tick, int index) {
        if (this.isInSelection(tick, index)) {
            if (GuiScreen.func_146271_m()) {
                this.removeFromSelection(tick, index);
            } else if (GuiScreen.func_146272_n()) {
                this.canSelectArea = true;
            } else {
                this.awaitMoving();
            }
        } else if (GuiScreen.func_146272_n()) {
            if (this.currentTick.tick != -1 && this.currentTick.index != -1) {
                List<List<Action>> actionRange = this.panel.record.getActions(tick, this.currentTick.tick, index, this.currentTick.index);
                this.addToSelection(Math.min(tick, this.currentTick.tick), actionRange);
            }
            this.selectCurrentSaveOld(tick, index);
        } else if (GuiBase.func_146271_m()) {
            if (this.panel.record.getAction(tick, index) != null) {
                this.selectCurrentSaveOld(tick, index);
            }
        } else if (this.panel.record.getAction(tick, index) != null) {
            this.selection.clear();
            this.fromTick = tick;
            this.selectCurrentSaveOld(tick, index);
            this.awaitMoving();
        } else {
            this.canSelectArea = true;
        }
    }

    private void awaitMoving() {
        this.canMove = true;
        this.moving = false;
    }

    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        this.releaseMorphActionTimeHandle(context);
        this.clickedTick.remove(context.mouseButton);
        if (context.mouseButton == 0) {
            if (this.moving) {
                this.moveSelectionTo(this.scroll.getIndex(context.mouseX, context.mouseY), this.vertical.getIndex(context.mouseX, context.mouseY));
            } else if (this.selectingArea) {
                int frameSize;
                if (!GuiScreen.func_146272_n()) {
                    this.selection.clear();
                }
                int scrollIndex = this.scroll.getIndex(context.mouseX, context.mouseY);
                int verticalIndex = this.vertical.getIndex(context.mouseX, context.mouseY);
                scrollIndex = scrollIndex == -1 ? 0 : (scrollIndex == -2 ? this.panel.record.actions.size() - 1 : scrollIndex);
                int n = frameSize = this.panel.record.getActions(scrollIndex) == null ? 1 : this.panel.record.getActions(scrollIndex).size();
                verticalIndex = verticalIndex == -1 ? 0 : (verticalIndex == -2 ? frameSize - 1 : verticalIndex);
                int fromSt = Math.min(this.lastClicked.tick, scrollIndex);
                int toSt = Math.max(this.lastClicked.tick, scrollIndex);
                int fromSi = Math.min(this.lastClicked.index, verticalIndex);
                int toSi = Math.max(this.lastClicked.index, verticalIndex);
                List<List<Action>> actionRange = this.panel.record.getActions(fromSt, toSt, fromSi, toSi);
                int startShift = this.trimSelectionBeginning(actionRange);
                this.trimSelectionEnd(actionRange);
                this.addToSelection(fromSt + startShift, actionRange);
            } else if (!this.preventMouseReleaseSelect) {
                int tick = this.scroll.getIndex(context.mouseX, context.mouseY);
                int index = this.vertical.getIndex(context.mouseX, context.mouseY);
                if (!(index == -1 || 0 > tick || tick >= this.panel.record.actions.size() || GuiScreen.func_146272_n() || GuiScreen.func_146271_m() || !this.isInSelection(tick, index) && this.panel.record.getAction(tick, index) != null)) {
                    this.selection.clear();
                    this.selectCurrentSaveOld(tick, index);
                }
            }
            this.preventMouseReleaseSelect = false;
            this.canSelectArea = false;
            this.selectingArea = false;
            this.canMove = false;
            this.moving = false;
        }
        this.lastDragging = false;
        this.scroll.mouseReleased(context);
        this.vertical.mouseReleased(context);
    }

    private void addToSelection(int tick, List<List<Action>> actions) {
        int start;
        if (actions.isEmpty() || this.panel.record.actions.size() <= tick || tick < 0) {
            return;
        }
        this.selectTick(tick);
        this.selectTick(tick + actions.size() - 1);
        int i = start = tick - this.fromTick;
        for (int c = 0; i < this.selection.size() && c < actions.size(); ++i, ++c) {
            if (this.selection.get(i) == null && actions.get(c) != null) {
                this.selection.set(i, new ArrayList(actions.get(c)));
                continue;
            }
            if (this.selection.get(i) == null || actions.get(c) == null) continue;
            this.selection.get(i).removeAll((Collection)actions.get(c));
            this.selection.get(i).addAll((Collection<Action>)actions.get(c));
        }
    }

    public boolean mouseScrolled(GuiContext context) {
        if (super.mouseScrolled(context)) {
            return true;
        }
        boolean shift = GuiScreen.func_146272_n();
        boolean alt = GuiScreen.func_175283_s();
        if (shift && !alt) {
            return this.vertical.mouseScroll(context);
        }
        if (alt && !shift) {
            int scale = this.scroll.scrollItemSize;
            this.scroll.scrollItemSize = MathUtils.clamp((int)(this.scroll.scrollItemSize + (int)Math.copySign(2.0f, context.mouseWheel)), (int)6, (int)50);
            this.scroll.setSize(this.panel.record.actions.size());
            this.scroll.clamp();
            if (this.scroll.scrollItemSize != scale) {
                int value = this.scroll.scroll + (context.mouseX - this.area.x);
                this.scroll.scroll = (int)(((float)value - (float)(value - this.scroll.scroll) * ((float)scale / (float)this.scroll.scrollItemSize)) * ((float)this.scroll.scrollItemSize / (float)scale));
            }
            return true;
        }
        return this.scroll.mouseScroll(context);
    }

    private boolean isInSelection(int tick, int index) {
        if (tick < this.fromTick || this.selection.isEmpty() || this.fromTick == -1) {
            return false;
        }
        Action action = this.panel.record.getAction(tick, index);
        int t = tick - this.fromTick;
        if (action == null || t >= this.selection.size()) {
            return false;
        }
        return this.selection.get(t) != null ? this.selection.get(t).contains(action) : false;
    }

    private void removeFromSelection(int tick, int index) {
        if (tick < this.fromTick) {
            return;
        }
        int t = tick - this.fromTick;
        Action remove = this.panel.record.getAction(tick, index);
        if (remove == null || t >= this.selection.size()) {
            return;
        }
        if (this.selection.get(t) != null) {
            this.selection.get(t).remove(remove);
        }
        if (t == this.selection.size() - 1) {
            this.trimSelectionEnd(this.selection);
        } else if (t == 0) {
            this.fromTick += this.trimSelectionBeginning(this.selection);
        } else if (this.selection.get(t).isEmpty()) {
            this.selection.set(t, null);
        }
        if (this.current == remove) {
            this.selectCurrentSaveOld(-1, -1);
        }
    }

    public void deselect() {
        this.selection.clear();
        this.selectCurrentSaveOld(this.currentTick.tick, -1);
    }

    public void selectAll() {
        this.selection.clear();
        this.addToSelection(0, this.panel.record.getActions(0, this.panel.record.actions.size() - 1));
        this.selectCurrentSaveOld(this.currentTick.tick, this.currentTick.index);
    }

    private int trimSelectionBeginning(List<List<Action>> selection) {
        int shift = 0;
        for (int start = 0; start < selection.size() && this.isFrameEmpty(selection.get(start)); ++start) {
            selection.remove(start);
            --start;
            ++shift;
        }
        return shift;
    }

    private boolean isFrameEmpty(List<Action> frame) {
        boolean empty = true;
        if (frame != null && !frame.isEmpty()) {
            for (int a = 0; a < frame.size(); ++a) {
                if (frame.get(a) == null) continue;
                empty = false;
            }
        }
        return empty;
    }

    private int trimSelectionEnd(List<List<Action>> selection) {
        int shift = 0;
        for (int end = selection.size() - 1; end >= 0 && this.isFrameEmpty(selection.get(end)); --end) {
            selection.remove(end);
            ++shift;
        }
        return shift;
    }

    public void selectCurrent(int tick, int index) {
        Action selected = this.panel.record.getAction(tick, index);
        if (selected != null) {
            if (this.fromTick == -1 || this.selection.isEmpty()) {
                this.selection.clear();
                this.fromTick = tick;
                this.selection.add(null);
            } else {
                this.selectTick(tick);
            }
            int t = tick - this.fromTick;
            if (this.selection.get(t) != null) {
                if (!this.selection.get(t).contains(selected)) {
                    this.selection.get(t).add(selected);
                }
            } else {
                this.selection.set(t, new ArrayList<Action>(Arrays.asList(selected)));
            }
        } else if (this.fromTick == -1 || this.selection.isEmpty()) {
            this.selection.clear();
            this.fromTick = tick;
            this.selection.add(null);
        }
        this.current = selected;
        this.currentTick.tick = tick;
        this.currentTick.index = index;
        this.panel.selectAction(this.current);
    }

    public void selectCurrentSaveOld(int tick, int index) {
        this.saveAction();
        this.selectCurrent(tick, index);
    }

    public void saveAction() {
        this.panel.saveAction();
    }

    private void selectTick(int tick) {
        int start;
        int t = tick - this.fromTick;
        int n = tick < this.fromTick ? 0 : (start = t >= this.selection.size() ? this.selection.size() : 0);
        int end = tick < this.fromTick ? this.fromTick - tick : (t >= this.selection.size() ? t + 1 : 0);
        for (int i = start; i < end; ++i) {
            this.selection.add(i, null);
        }
        if (tick < this.fromTick) {
            this.fromTick = tick;
        }
    }

    private void sortToOriginal(List<List<Action>> actions) {
        for (int tick = 0; tick < actions.size(); ++tick) {
            if (actions.get(tick) == null || actions.get(tick).isEmpty()) continue;
            ArrayList<Action> frameList = new ArrayList<Action>();
            boolean added = false;
            for (int a = 0; a < actions.get(tick).size(); ++a) {
                int newIndex = this.panel.record.getActionIndex(this.fromTick + tick, actions.get(tick).get(a));
                if (newIndex == -1) continue;
                if (newIndex >= frameList.size()) {
                    frameList.addAll(Arrays.asList(new Action[newIndex - frameList.size() + 1]));
                }
                frameList.set(newIndex, actions.get(tick).get(a));
                if (added) continue;
                added = actions.get(tick).get(a) != null;
            }
            if (!added) continue;
            this.removeNulls(frameList);
            actions.set(tick, frameList);
        }
    }

    private void removeNulls(List<Action> frame) {
        int s = 0;
        for (int e = frame.size() - 1; s < frame.size() && e >= 0; ++s, --e) {
            if (frame.get(e) == null) {
                frame.remove(e);
                --e;
            }
            if (frame.get(s) == null) {
                frame.remove(s);
                --s;
                --e;
            }
            if (s >= e) break;
        }
    }

    private void moveSelectionTo(int tick, int index) {
        tick = tick == -1 ? 0 : (tick == -2 ? this.panel.record.actions.size() - this.selection.size() : tick + this.fromTick - this.lastClicked.tick);
        if (index == -1) {
            index = 0;
        } else if (index == -2) {
            index = this.panel.record.actions.get(tick) == null ? 0 : this.panel.record.actions.get(tick).size() - 1;
        }
        ArrayList<List<Action>> selectionCopy = new ArrayList<List<Action>>(this.selection);
        this.sortToOriginal(selectionCopy);
        int start = this.trimSelectionBeginning(selectionCopy);
        this.trimSelectionEnd(selectionCopy);
        if (selectionCopy.isEmpty()) {
            return;
        }
        Action current = this.current;
        int dT = this.currentTick.tick - this.fromTick;
        this.removeActions();
        this.selection.clear();
        this.selection.addAll(selectionCopy);
        if ((tick += start) < 0) {
            tick = 0;
        } else if (tick + this.selection.size() - 1 >= this.panel.record.actions.size()) {
            tick -= tick + this.selection.size() - 1 - this.panel.record.actions.size() + 1;
        }
        this.fromTick = tick;
        this.currentTick.tick = tick + dT - start;
        this.addActions(tick, index, selectionCopy);
        this.selectCurrent(this.currentTick.tick, this.panel.record.getActionIndex(this.currentTick.tick, current));
    }

    public void cutActions() {
        if (this.fromTick == -1 || this.selection.isEmpty()) {
            return;
        }
        this.copyActions();
        this.removeActions();
    }

    public void copyActions() {
        if (this.fromTick == -1 || this.selection.isEmpty()) {
            return;
        }
        ArrayList<List<Action>> selectionCopy = new ArrayList<List<Action>>(this.selection);
        this.sortToOriginal(selectionCopy);
        this.trimSelectionBeginning(selectionCopy);
        this.trimSelectionEnd(selectionCopy);
        if (selectionCopy.isEmpty()) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (List list2 : selectionCopy) {
            NBTTagList frameNBT = new NBTTagList();
            if (list2 != null) {
                for (Action action : list2) {
                    if (action == null) continue;
                    NBTTagCompound actionNBT = new NBTTagCompound();
                    actionNBT.func_74778_a("ActionType", (String)ActionRegistry.NAME_TO_CLASS.inverse().get(action.getClass()));
                    action.toNBT(actionNBT);
                    frameNBT.func_74742_a((NBTBase)actionNBT);
                }
            }
            list.func_74742_a((NBTBase)frameNBT);
        }
        this.panel.buffer = new NBTTagCompound();
        this.panel.buffer.func_74782_a("Actions", (NBTBase)list);
    }

    public void pasteActions() {
        if (this.panel.buffer == null || !this.panel.buffer.func_74764_b("Actions") || this.currentTick.tick == -1) {
            return;
        }
        ArrayList<List<Action>> copied = new ArrayList<List<Action>>();
        if (this.panel.buffer.func_74781_a("Actions") instanceof NBTTagList) {
            NBTTagList nbtList = (NBTTagList)this.panel.buffer.func_74781_a("Actions");
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                if (nbtList.func_179238_g(i) == null || !(nbtList.func_179238_g(i) instanceof NBTTagList)) {
                    copied.add(null);
                    continue;
                }
                ArrayList<Action> frame = null;
                NBTTagList frameNBT = (NBTTagList)nbtList.func_179238_g(i);
                for (int a = 0; a < frameNBT.func_74745_c(); ++a) {
                    NBTTagCompound actionNBT;
                    if (!(frameNBT.func_179238_g(a) instanceof NBTTagCompound) || !(actionNBT = (NBTTagCompound)frameNBT.func_179238_g(a)).func_74764_b("ActionType")) continue;
                    try {
                        Action action = ActionRegistry.fromName(actionNBT.func_74779_i("ActionType"));
                        action.fromNBT(actionNBT);
                        if (frame == null) {
                            frame = new ArrayList<Action>();
                        }
                        frame.add(action);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                copied.add(frame);
            }
        }
        this.trimSelectionBeginning(copied);
        this.trimSelectionEnd(copied);
        if (copied.isEmpty()) {
            return;
        }
        this.saveAction();
        if (this.currentTick.index < 0 || this.current == null) {
            this.addActions(this.currentTick.tick, -1, copied);
        } else {
            this.addActions(this.currentTick.tick, this.currentTick.index, copied);
        }
        this.selection.clear();
        this.selection.addAll(copied);
        this.selectCurrent(this.currentTick.tick, -1);
    }

    public void createAction(String str) {
        if (!ActionRegistry.NAME_TO_CLASS.containsKey((Object)str) || this.currentTick.tick < 0 || this.currentTick.tick >= this.panel.record.actions.size()) {
            return;
        }
        try {
            Action action = ActionRegistry.fromName(str);
            int tick = this.currentTick.tick;
            int index = this.currentTick.index;
            ArrayList<List<Action>> insert = new ArrayList<List<Action>>();
            insert.add(new ArrayList<Action>(Arrays.asList(action)));
            this.addActions(tick, index, insert);
            this.selection.clear();
            this.selectCurrentSaveOld(tick, this.panel.record.getActionIndex(tick, action));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dupeActions() {
        if (this.fromTick < 0 || this.selection.isEmpty()) {
            return;
        }
        int tick = this.fromTick;
        int index = this.currentTick.index == -1 ? 0 : (this.currentTick.index == -2 ? -1 : this.currentTick.index);
        ArrayList<List<Action>> selectionCopy = new ArrayList<List<Action>>(this.selection);
        if (selectionCopy.isEmpty()) {
            return;
        }
        this.sortToOriginal(selectionCopy);
        int start = this.trimSelectionBeginning(selectionCopy);
        this.trimSelectionEnd(selectionCopy);
        Action newCurrent = null;
        for (int t = 0; t < selectionCopy.size(); ++t) {
            if (selectionCopy.get(t) == null || ((List)selectionCopy.get(t)).isEmpty()) continue;
            for (int a = 0; a < ((List)selectionCopy.get(t)).size(); ++a) {
                if (((List)selectionCopy.get(t)).get(a) == null) continue;
                try {
                    Action newAction = ActionRegistry.fromType(ActionRegistry.getType((Action)((List)selectionCopy.get(t)).get(a)));
                    NBTTagCompound tag = new NBTTagCompound();
                    ((Action)((List)selectionCopy.get(t)).get(a)).toNBT(tag);
                    newAction.fromNBT(tag);
                    if (((List)selectionCopy.get(t)).get(a) == this.current) {
                        newCurrent = newAction;
                    }
                    ((List)selectionCopy.get(t)).set(a, newAction);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.addActions(tick += start, index, selectionCopy);
        this.selection.clear();
        this.addToSelection(tick, selectionCopy);
        this.selectCurrentSaveOld(this.currentTick.tick, this.panel.record.getActionIndex(this.currentTick.tick, newCurrent));
    }

    private void addActions(int tick, int index, List<List<Action>> actions) {
        if (index < 0) {
            ServerHandlerActionsChange.addActions(actions, this.panel.record, tick);
        } else {
            ServerHandlerActionsChange.addActions(actions, this.panel.record, tick, index);
        }
        this.recalculateVertical();
    }

    public void removeActions() {
        if (this.fromTick == -1 || this.selection.isEmpty()) {
            return;
        }
        ArrayList<List<Action>> selectionCopy = new ArrayList<List<Action>>(this.selection);
        int startShift = this.trimSelectionBeginning(selectionCopy);
        this.trimSelectionEnd(selectionCopy);
        if (selectionCopy.isEmpty()) {
            return;
        }
        int from = this.fromTick + startShift;
        List<List<Boolean>> deletionMask = this.panel.record.getActionsMask(from, selectionCopy);
        this.saveAction();
        ServerHandlerActionsChange.deleteActions(this.panel.record, from, deletionMask);
        this.selection.clear();
        this.selectCurrent(this.currentTick.tick, -1);
        this.recalculateVertical();
    }

    public void draw(GuiContext context) {
        int x;
        int i;
        int index;
        if (this.panel.record == null) {
            return;
        }
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        int count = this.panel.record.actions.size();
        if (this.lastDragging) {
            this.scroll.scroll = this.lastH + (this.lastX - mouseX);
            this.scroll.clamp();
            this.vertical.scroll = this.lastV + (this.lastY - mouseY);
            this.vertical.clamp();
        }
        if (!(this.moving || Math.abs(mouseX - this.lastX) <= 2 && Math.abs(mouseY - this.lastY) <= 2)) {
            if (this.canMove) {
                this.moving = true;
            }
            if (this.canSelectArea) {
                this.selectingArea = true;
            }
        }
        this.scroll.drag(mouseX, mouseY);
        this.vertical.drag(mouseX, mouseY);
        this.scroll.draw(-2013265920);
        Gui.func_73734_a((int)this.area.ex(), (int)this.area.y, (int)(this.area.ex() + 20), (int)this.area.ey(), (int)-14540254);
        Gui.func_73734_a((int)(this.area.x - 20), (int)this.area.y, (int)this.area.x, (int)this.area.ey(), (int)-14540254);
        GuiDraw.drawHorizontalGradientRect((int)(this.area.ex() - 8), (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)0, (int)-2013265920, (float)0.0f);
        GuiDraw.drawHorizontalGradientRect((int)this.area.x, (int)this.area.y, (int)(this.area.x + 8), (int)this.area.ey(), (int)-2013265920, (int)0, (float)0.0f);
        int max = this.area.x + this.scroll.scrollItemSize * count;
        if (max < this.area.ex()) {
            Gui.func_73734_a((int)max, (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)-1442840576);
        }
        GuiDraw.scissor((int)this.area.x, (int)this.area.y, (int)this.area.w, (int)this.area.h, (GuiContext)context);
        int w = this.scroll.scrollItemSize;
        int diff = index = this.scroll.scroll / w;
        index = (index -= this.adaptiveMaxIndex) < 0 ? 0 : index;
        this.adaptiveMaxIndex = 0;
        int c = i + this.area.w / w + 2 + (diff -= index);
        for (i = index; i < c; ++i) {
            List<Action> actions;
            int toTick;
            x = this.scroll.x - this.scroll.scroll + i * w;
            if (i < count) {
                Gui.func_73734_a((int)x, (int)this.scroll.y, (int)(x + 1), (int)this.scroll.ey(), (int)0x22FFFFFF);
            }
            int n = toTick = this.selection.isEmpty() ? this.fromTick : this.fromTick + this.selection.size() - 1;
            if (this.fromTick <= i && i <= toTick) {
                Gui.func_73734_a((int)x, (int)this.scroll.y, (int)(x + w + 1), (int)this.scroll.ey(), (int)1140885759);
            }
            if (i < 0 || i >= count || (actions = this.panel.record.actions.get(i)) == null) continue;
            int j = 0;
            for (Action action : actions) {
                boolean selected;
                if (this.moving && this.isInSelection(i, j)) {
                    ++j;
                    continue;
                }
                int y = this.scroll.y + j * this.itemHeight - this.vertical.scroll;
                int scrollIndex = this.scroll.getIndex(mouseX, mouseY);
                int verticalIndex = this.vertical.getIndex(mouseX, mouseY);
                int n2 = scrollIndex == -1 ? 0 : (scrollIndex = scrollIndex == -2 ? count - 1 : scrollIndex);
                verticalIndex = verticalIndex == -1 ? 0 : (verticalIndex == -2 ? actions.size() - 1 : verticalIndex);
                int fromSt = Math.min(this.lastClicked.tick, scrollIndex);
                int toSt = Math.max(this.lastClicked.tick, scrollIndex);
                int fromSi = Math.min(this.lastClicked.index, verticalIndex);
                int toSi = Math.max(this.lastClicked.index, verticalIndex);
                if (this.selectingArea) {
                    boolean bl = selected = fromSt <= i && i <= toSt && fromSi <= j && j <= toSi;
                    if (GuiScreen.func_146272_n()) {
                        selected = selected || this.isInSelection(i, j);
                    }
                } else {
                    selected = this.isInSelection(i, j);
                }
                this.drawAction(action, context, String.valueOf(j), x, y, selected);
                ++j;
            }
        }
        c = i + this.area.w / w + 2 + diff;
        for (i = index; i < c; ++i) {
            if (i % 5 != 0 || i >= count || i == this.cursor) continue;
            x = this.scroll.x - this.scroll.scroll + i * w;
            int y = this.scroll.ey() - 12;
            String str = String.valueOf(i);
            this.func_73733_a(x + 1, y - 6, x + w, y + 12, 0, -2013265920);
            this.font.func_175063_a(str, (float)(x + (this.scroll.scrollItemSize - this.font.func_78256_a(str) + 2) / 2), (float)y, 0xFFFFFF);
        }
        this.scroll.drawScrollbar();
        this.vertical.drawScrollbar();
        if (this.cursor >= 0 && this.cursor < this.panel.record.actions.size()) {
            int x2 = this.scroll.x - this.scroll.scroll + this.cursor * w;
            int cursorX = x2 + 2;
            String label = this.cursor + "/" + this.panel.record.actions.size();
            int width = this.font.func_78256_a(label);
            int height = 2 + this.font.field_78288_b;
            int offsetY = this.scroll.ey() - height;
            if (cursorX + width + 4 > this.scroll.ex()) {
                cursorX -= width + 4 + 2;
            }
            Gui.func_73734_a((int)x2, (int)this.scroll.y, (int)(x2 + 2), (int)this.scroll.ey(), (int)-11012822);
            Gui.func_73734_a((int)cursorX, (int)offsetY, (int)(cursorX + width + 4), (int)(offsetY + height), (int)-1437076182);
            this.font.func_175063_a(label, (float)(cursorX + 2), (float)(offsetY + 2), 0xFFFFFF);
        }
        String label = this.panel.record.filename;
        GuiDraw.drawTextBackground((FontRenderer)this.font, (String)label, (int)(this.area.ex() - this.font.func_78256_a(label) - 5), (int)(this.area.ey() - 13), (int)0xFFFFFF, (int)(-1442840576 + (Integer)McLib.primaryColor.get()));
        GuiDraw.unscissor((GuiContext)context);
        if (this.moving) {
            int x3 = mouseX;
            int y = mouseY;
            int posX = w * this.lastClicked.tick + this.scroll.x - this.scroll.scroll;
            int posY = this.itemHeight * this.lastClicked.index + this.scroll.y - this.vertical.scroll;
            if (this.movingDx == -1) {
                this.movingDx = mouseX - posX;
            }
            if (this.movingDy == -1) {
                this.movingDy = mouseY - posY;
            }
            x3 -= this.movingDx - w * (this.fromTick - this.lastClicked.tick);
            int y0 = y -= this.movingDy + this.itemHeight * this.lastClicked.index;
            for (int tick = this.fromTick; tick < this.panel.record.actions.size(); ++tick) {
                List<Action> frame = this.panel.record.actions.get(tick);
                if (frame != null) {
                    for (int i2 = 0; i2 < frame.size(); ++i2) {
                        if (this.isInSelection(tick, i2)) {
                            this.drawAction(frame.get(i2), context, String.valueOf(i2), x3, y, true);
                        }
                        y += this.itemHeight;
                    }
                }
                y = y0;
                x3 += w;
            }
        } else {
            this.movingDx = -1;
            this.movingDy = -1;
        }
        if (this.selectingArea) {
            if (this.areaScrollDx == -1) {
                this.areaScrollDx = this.scroll.scroll;
            }
            if (this.areaScrollDy == -1) {
                this.areaScrollDy = this.vertical.scroll;
            }
            Gui.func_73734_a((int)(this.lastLeftX - (this.scroll.scroll - this.areaScrollDx)), (int)(this.lastLeftY - (this.vertical.scroll - this.areaScrollDy)), (int)mouseX, (int)mouseY, (int)1140885759);
        } else {
            this.areaScrollDy = -1;
            this.areaScrollDx = -1;
        }
        super.draw(context);
        this.cursor = -1;
    }

    private void drawAction(Action action, GuiContext context, String label, int x, int y, boolean selected) {
        int w = this.scroll.scrollItemSize;
        float hue = (float)(ActionRegistry.getType(action) - 1) / (float)ActionRegistry.getMaxID();
        int color = MathHelper.func_181758_c((float)hue, (float)1.0f, (float)1.0f);
        int offset = this.scroll.scrollItemSize < 18 ? (this.scroll.scrollItemSize - this.font.func_78256_a(label)) / 2 : 6;
        this.drawAnimationLength(action, context, x, y, color, selected);
        Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + this.itemHeight), (int)(color + -2013265920));
        this.font.func_175063_a(label, (float)(x + offset), (float)(y + 6), 0xFFFFFF);
        if (selected) {
            float hueSelected = MathUtils.clamp((float)(hue - 0.5f < 0.0f ? 0.5f + hue : hue - 0.5f), (float)0.0f, (float)0.5f);
            int c = action == this.current ? new Color(MathHelper.func_181758_c((float)hueSelected, (float)0.5f, (float)1.0f), false).getRGBAColor() : -1;
            int border = action == this.current ? 2 : 1;
            GuiDraw.drawOutline((int)x, (int)y, (int)(x + w), (int)(y + this.itemHeight), (int)c, (int)border);
        }
    }

    private void drawAnimationLength(Action action, GuiContext context, int x, int y, int color, boolean selected) {
        if (action instanceof MorphAction) {
            MorphAction morphAction = (MorphAction)action;
            int ticks = this.getAnimationLength(this.getMaxAnimationLengthMorph(morphAction.morph));
            if (this.movingMorphActionTimeHandle && this.selectedTimeHandles.contains(action) && this.clickedTick.containsKey(0)) {
                ticks = Math.max(0, ticks + this.scroll.getIndex(context.mouseX, context.mouseY) - this.clickedTick.get(0));
            }
            if (ticks > 1) {
                int offset = x + this.scroll.scrollItemSize;
                boolean timeHandleSelected = this.selectedTimeHandles.contains(action);
                Gui.func_73734_a((int)offset, (int)(y + 8), (int)(offset + --ticks * this.scroll.scrollItemSize), (int)(y + 12), (int)(selected ? -1 : color + 0x33000000));
                Gui.func_73734_a((int)(offset + ticks * this.scroll.scrollItemSize - this.morphActionHandleWidth), (int)y, (int)(offset + ticks * this.scroll.scrollItemSize), (int)(y + this.itemHeight), (int)(timeHandleSelected ? -1 : -16777216 + color));
            }
            this.adaptiveMaxIndex = Math.max(ticks, this.adaptiveMaxIndex);
        }
    }

    private AbstractMorph getMaxAnimationLengthMorph(AbstractMorph morph) {
        int ticks = this.getAnimationLength(morph);
        if (morph instanceof IBodyPartProvider) {
            BodyPartManager manager = ((IBodyPartProvider)morph).getBodyPart();
            for (BodyPart part : manager.parts) {
                AbstractMorph morph0;
                int ticks0;
                if (part.morph.isEmpty() || part.limb == null || part.limb.isEmpty() || (ticks0 = this.getAnimationLength(morph0 = this.getMaxAnimationLengthMorph(part.morph.get()))) <= ticks) continue;
                ticks = ticks0;
                morph = morph0;
            }
        }
        return morph;
    }

    private int getAnimationLength(AbstractMorph morph) {
        if (morph instanceof IAnimationProvider) {
            Animation animation = ((IAnimationProvider)morph).getAnimation();
            if (animation.animates) {
                return animation.duration;
            }
        } else if (morph instanceof SequencerMorph) {
            SequencerMorph sequencerMorph = (SequencerMorph)morph;
            return (int)sequencerMorph.getDuration();
        }
        return 0;
    }

    public static class Selection
    implements ICopy<Selection> {
        private int tick;
        private int index;

        public Selection(int tick, int index) {
            this.set(tick, index);
        }

        public void set(int tick, int index) {
            this.tick = tick;
            this.index = index;
        }

        public int getTick() {
            return this.tick;
        }

        public int getIndex() {
            return this.index;
        }

        public Selection copy() {
            Selection copy = new Selection(this.tick, this.index);
            return copy;
        }
    }
}

