/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.loaders.lazy.ModelLazyLoaderJSON;
import mchorse.blockbuster.api.resource.StreamEntry;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.GuiModelEditorPanel;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs.GuiModelEditorTab;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.parsing.ModelExporter;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringSearchListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiListModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiMessageModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Patterns;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GuiModelList
extends GuiModelEditorTab {
    public static final Pattern FILENAME_SLASHES = Pattern.compile(Patterns.FILENAME.pattern().replace("]*$", "/]*$"));
    public GuiStringSearchListElement models;
    private GuiIconElement dupe;
    private GuiIconElement export;
    private GuiIconElement folder;

    public GuiModelList(Minecraft mc, GuiModelEditorPanel panel) {
        super(mc, panel);
        this.title = IKey.lang((String)"blockbuster.gui.me.models.title");
        this.models = new GuiStringSearchListElement(mc, str -> this.panel.setModel((String)str.get(0)));
        this.models.flex().relative((IResizer)this.area).y(20).w(140).h(1.0f, -20);
        this.models.list.scroll.scrollSpeed = 16;
        this.dupe = new GuiIconElement(mc, Icons.DUPE, b -> this.saveModel());
        this.export = new GuiIconElement(mc, Icons.UPLOAD, b -> this.exportModel());
        this.folder = new GuiIconElement(mc, Icons.FOLDER, b -> this.openFolder());
        GuiElement sidebar = Elements.row((Minecraft)mc, (int)0, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.dupe, this.export, this.folder});
        sidebar.flex().relative((GuiElement)this.models).x(1.0f).y(-20).h(20).anchorX(1.0f).row(0).resize();
        this.add(new IGuiElement[]{this.models, sidebar});
    }

    public void updateModelList() {
        String current = (String)this.models.list.getCurrentFirst();
        this.models.list.clear();
        this.models.list.add(ModelCustom.MODELS.keySet());
        this.models.list.sort();
        if (current == null) {
            current = "steve";
        }
        this.models.list.setCurrentScroll((Object)current);
    }

    private void saveModel() {
        GuiModal.addFullModal((GuiElement)this, () -> {
            GuiPromptModal modal = new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.me.models.name"), this::saveModel).setValue(this.panel.modelName);
            modal.text.validator(string -> FILENAME_SLASHES.matcher((CharSequence)string).find());
            return modal;
        });
    }

    private void saveModel(String name) {
        boolean exists = ModelCustom.MODELS.containsKey(name);
        if (!exists) {
            if (!this.panel.saveModel(name)) {
                return;
            }
            this.models.list.add((Object)name);
            this.models.list.sort();
            this.models.list.setCurrent((Object)name);
        }
    }

    private void exportModel() {
        ArrayList<String> mobs = new ArrayList<String>();
        block0: for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            for (Class clazz = ((EntityEntry)entry.getValue()).getEntityClass(); clazz != null; clazz = clazz.getSuperclass()) {
                if (clazz != EntityLivingBase.class) continue;
                mobs.add(((ResourceLocation)entry.getKey()).toString());
                continue block0;
            }
        }
        Collections.sort(mobs);
        GuiModal.addFullModal((GuiElement)this, () -> {
            GuiListModal modal = new GuiListModal(this.mc, IKey.lang((String)"blockbuster.gui.me.models.pick"), this::exportModel);
            return modal.addValues((Collection)mobs);
        });
    }

    private void exportModel(String name) {
        if (name.isEmpty()) {
            return;
        }
        try {
            Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(name), (World)this.mc.field_71441_e);
            Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity);
            ModelExporter exporter = new ModelExporter((EntityLivingBase)entity, (RenderLivingBase<EntityLivingBase>)((RenderLivingBase)render));
            Model model = exporter.exportModel(name);
            name = name.replaceAll(":", "_");
            model.fillInMissing();
            this.panel.setModel(name, model, new ModelLazyLoaderJSON(new StreamEntry("", 0L)));
        }
        catch (Exception e) {
            GuiModal.addFullModal((GuiElement)this, () -> new GuiMessageModal(this.mc, IKey.str((String)I18n.func_135052_a((String)"blockbuster.gui.me.models.error", (Object[])new Object[]{e.getMessage()}))));
            e.printStackTrace();
        }
    }

    private void openFolder() {
        GuiUtils.openFolder((String)new File(ClientProxy.configFile, "models/" + this.panel.modelName).getAbsolutePath());
    }

    @Override
    public void draw(GuiContext context) {
        this.area.draw(-1442840576);
        super.draw(context);
    }
}

