/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.model_block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.client.gui.GuiImmersiveEditor;
import mchorse.blockbuster.client.gui.GuiImmersiveMorphMenu;
import mchorse.blockbuster.client.gui.dashboard.GuiBlockbusterPanel;
import mchorse.blockbuster.client.gui.dashboard.panels.model_block.GuiModelBlockList;
import mchorse.blockbuster.common.BlockbusterPermissions;
import mchorse.blockbuster.common.block.BlockModel;
import mchorse.blockbuster.common.tileentity.TileEntityModel;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketModifyModelBlock;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.mclib.GuiDashboard;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.permissions.PermissionCategory;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.OpHelper;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class GuiModelBlockPanel
extends GuiBlockbusterPanel {
    public static final List<BlockPos> lastBlocks = new ArrayList<BlockPos>();
    private TileEntityModel model;
    private GuiTrackpadElement yaw;
    private GuiTrackpadElement pitch;
    private GuiTrackpadElement body;
    private GuiModelBlockTransformations trans;
    private GuiNestedEdit pickMorph;
    private GuiCirculateElement order;
    private GuiToggleElement shadow;
    private GuiToggleElement global;
    private GuiToggleElement enabled;
    private GuiToggleElement excludeResetPlayback;
    private GuiToggleElement renderLast;
    private GuiToggleElement renderAlways;
    private GuiToggleElement enableBlockHitbox;
    private GuiTrackpadElement lightLevel;
    private GuiModelBlockList list;
    private GuiElement subChildren;
    private GuiSlotElement[] slots = new GuiSlotElement[6];
    private Map<BlockPos, TileEntityModel> old = new HashMap<BlockPos, TileEntityModel>();
    private AbstractMorph morph;
    private boolean opened;

    public static void tryAddingBlock(BlockPos pos) {
        for (BlockPos stored : lastBlocks) {
            if (!pos.equals((Object)stored)) continue;
            return;
        }
        lastBlocks.add(pos);
    }

    public GuiModelBlockPanel(Minecraft mc, GuiDashboard dashboard) {
        super(mc, dashboard);
        this.subChildren = new GuiElement(mc).noCulling();
        this.subChildren.setVisible(false);
        this.add((IGuiElement)this.subChildren);
        this.trans = new GuiModelBlockTransformations(mc);
        this.trans.flex().relative((GuiElement)this).x(0.5f, 42).y(1.0f, -10).wh(250, 70).anchor(0.5f, 1.0f);
        this.subChildren.add((IGuiElement)this.trans);
        this.yaw = new GuiTrackpadElement(mc, value -> this.model.getSettings().setRotateYawHead(value.floatValue()));
        this.subChildren.add((IGuiElement)this.yaw);
        this.yaw.tooltip(IKey.lang((String)"blockbuster.gui.model_block.yaw"));
        this.pitch = new GuiTrackpadElement(mc, value -> this.model.getSettings().setRotatePitch(value.floatValue()));
        this.subChildren.add((IGuiElement)this.pitch);
        this.pitch.tooltip(IKey.lang((String)"blockbuster.gui.model_block.pitch"));
        this.body = new GuiTrackpadElement(mc, value -> this.model.getSettings().setRotateBody(value.floatValue()));
        this.subChildren.add((IGuiElement)this.body);
        this.body.tooltip(IKey.lang((String)"blockbuster.gui.model_block.body"));
        this.yaw.flex().set(-85.0f, 0.0f, 80.0f, 20.0f).relative((GuiElement)this.trans);
        this.pitch.flex().set(0.0f, 25.0f, 80.0f, 20.0f).relative(this.yaw.resizer());
        this.body.flex().set(0.0f, 25.0f, 80.0f, 20.0f).relative(this.pitch.resizer());
        this.order = new GuiCirculateElement(mc, b -> {
            int index = 0;
            if (this.order.getValue() == 0) {
                index = 5;
            }
            this.model.getSettings().setOrder(MatrixUtils.RotationOrder.values()[index]);
        });
        this.subChildren.add((IGuiElement)this.order);
        this.order.addLabel(IKey.str((String)"ZYX"));
        this.order.addLabel(IKey.str((String)"XYZ"));
        this.order.flex().relative((GuiElement)this.trans.rx).set(40.0f, -22.0f, 40.0f, 20.0f);
        GuiElement column = new GuiElement(mc);
        column.flex().relative((GuiElement)this).w(120).column(5).vertical().stretch().height(20).padding(10);
        this.pickMorph = new GuiNestedEdit(mc, editing -> {
            if (((Boolean)Blockbuster.immersiveModelBlock.get()).booleanValue()) {
                GuiImmersiveEditor editor = ClientProxy.panels.showImmersiveEditor((boolean)editing, this.model.morph.get());
                editor.morphs.updateCallback = this::updateMorphEditor;
                editor.morphs.beforeRender = this::beforeEditorRender;
                editor.morphs.afterRender = this::afterEditorRender;
                editor.onClose = this::afterEditorClose;
                this.morph = this.model.morph.get();
                this.model.morph.setDirect(MorphUtils.copy((AbstractMorph)this.morph));
            } else {
                ClientProxy.panels.addMorphs((GuiElement)this, (boolean)editing, this.model.morph.get());
            }
        });
        GuiButtonElement look = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.model_block.look"), button -> {
            this.model.getSettings().setRy(180.0f - this.mc.field_71439_g.field_70177_z);
            this.fillData();
        });
        this.shadow = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.shadow"), false, button -> this.model.getSettings().setShadow(button.isToggled()));
        this.global = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.global"), false, button -> this.model.getSettings().setGlobal(button.isToggled()));
        this.global.tooltip(IKey.lang((String)"blockbuster.gui.model_block.global_tooltip"), Direction.BOTTOM);
        this.enabled = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.enabled"), false, button -> this.model.getSettings().setEnabled(button.isToggled()));
        this.enabled.tooltip(IKey.lang((String)"blockbuster.gui.model_block.enabled_tooltip"), Direction.BOTTOM);
        this.excludeResetPlayback = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.exlude_reset_playback"), false, button -> this.model.getSettings().setExcludeResetPlayback(button.isToggled()));
        this.excludeResetPlayback.tooltip(IKey.lang((String)"blockbuster.gui.model_block.exlude_reset_playback_tooltip"), Direction.BOTTOM);
        this.renderLast = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.render_last"), false, button -> this.model.getSettings().setRenderLast(button.isToggled()));
        this.renderLast.tooltip(IKey.lang((String)"blockbuster.gui.model_block.render_last_tooltip"), Direction.BOTTOM);
        this.renderAlways = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.render_always"), false, button -> this.model.getSettings().setRenderAlways(button.isToggled()));
        this.renderAlways.tooltip(IKey.lang((String)"blockbuster.gui.model_block.render_always_tooltip"), Direction.BOTTOM);
        this.enableBlockHitbox = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.enable_hitbox"), false, b -> this.model.getSettings().setEnableBlockHitbox(b.isToggled()));
        this.enableBlockHitbox.tooltip(IKey.lang((String)"blockbuster.gui.model_block.enable_hitbox_tooltip"), Direction.BOTTOM);
        this.lightLevel = new GuiTrackpadElement(mc, value -> {
            this.model.getSettings().setLightValue(value.intValue());
            this.model.func_145831_w().func_180501_a(this.model.func_174877_v(), this.model.func_145831_w().func_180495_p(this.model.func_174877_v()).func_177226_a((IProperty)BlockModel.LIGHT, (Comparable)Integer.valueOf(this.model.getSettings().getLightValue())), 2);
        });
        this.lightLevel.integer().limit(0.0, 15.0);
        this.lightLevel.tooltip(IKey.lang((String)"blockbuster.gui.model_block.light_level_tooltip"));
        column.add(new IGuiElement[]{this.pickMorph, look, this.shadow, this.global, this.enabled, this.excludeResetPlayback, this.renderLast, this.renderAlways, this.enableBlockHitbox, Elements.label((IKey)IKey.lang((String)"blockbuster.gui.model_block.light_level")), this.lightLevel});
        this.subChildren.add((IGuiElement)column);
        this.list = new GuiModelBlockList(mc, IKey.lang((String)"blockbuster.gui.model_block.title"), tile -> this.setModelBlock((TileEntityModel)tile.get(0)));
        this.list.flex().relative((IResizer)this.flex()).set(0.0f, 0.0f, 120.0f, 0.0f).h(1.0f).x(1.0f, -120);
        this.add((IGuiElement)this.list);
        GuiIconElement toggle = new GuiIconElement(mc, Icons.BLOCK, b -> this.list.toggleVisible());
        toggle.flex().set(0.0f, 2.0f, 24.0f, 24.0f).relative((GuiElement)this).x(1.0f, -28);
        this.add((IGuiElement)toggle);
        for (int i = 0; i < this.slots.length; ++i) {
            int slot = i;
            this.slots[i] = new GuiSlotElement(mc, i, stack -> this.pickItem((ItemStack)stack, slot));
            this.slots[i].flex().relative((IResizer)this.area).anchor(0.5f, 0.5f);
            this.subChildren.add((IGuiElement)this.slots[i]);
        }
        this.slots[0].flex().x(0.375f).y(0.5f, -15);
        this.slots[1].flex().x(0.375f).y(0.5f, 15);
        this.slots[2].flex().x(0.625f).y(0.5f, 45);
        this.slots[3].flex().x(0.625f).y(0.5f, 15);
        this.slots[4].flex().x(0.625f).y(0.5f, -15);
        this.slots[5].flex().x(0.625f).y(0.5f, -45);
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean isSelected(TileEntityModel tileEntityModel) {
        return this.model == tileEntityModel;
    }

    public PermissionCategory getRequiredPermission() {
        return BlockbusterPermissions.editModelBlock;
    }

    public boolean needsBackground() {
        return false;
    }

    private void pickItem(ItemStack stack, int slot) {
        this.model.getSettings().setSlot(stack, slot);
        this.model.updateEntity();
    }

    private void setMorph(AbstractMorph morph) {
        if (this.model != null) {
            if (((Boolean)Blockbuster.immersiveModelBlock.get()).booleanValue()) {
                this.morph = morph;
            } else {
                this.model.morph.setDirect(morph);
            }
        }
        this.pickMorph.setMorph(morph);
    }

    private void updateMorphEditor(GuiImmersiveMorphMenu menu) {
        if (this.model == null) {
            return;
        }
        TileEntity te = this.model.func_145831_w().func_175625_s(this.model.func_174877_v());
        if (te != this.model && te instanceof TileEntityModel) {
            this.setModelBlock((TileEntityModel)te);
        }
        menu.target = this.model.entity;
    }

    private void beforeEditorRender(GuiContext context) {
        GlStateManager.func_179094_E();
        ClientProxy.modelRenderer.transform(this.model);
    }

    private void afterEditorRender(GuiContext context) {
        GlStateManager.func_179121_F();
    }

    private void afterEditorClose(GuiImmersiveEditor editor) {
        this.model.morph.setDirect(this.morph);
    }

    @Override
    public void appear() {
        super.appear();
        ClientProxy.panels.picker(this::setMorph);
    }

    public void open() {
        this.opened = true;
        this.updateList();
        if (this.model != null && this.mc.field_71441_e.func_175625_s(this.model.func_174877_v()) == null) {
            this.setModelBlock(null);
        }
    }

    public void close() {
        this.save(null);
        this.opened = false;
    }

    public void save(TileEntityModel model) {
        this.save(model, false);
    }

    public void save(TileEntityModel model, boolean force) {
        if (!OpHelper.isPlayerOp()) {
            return;
        }
        if (!force) {
            if (this.model == null || this.model == model) {
                return;
            }
            if (model != null && this.model.func_174877_v().equals((Object)model.func_174877_v())) {
                return;
            }
        }
        if (ClientProxy.panels.morphs.hasParent()) {
            ClientProxy.panels.morphs.finish();
            ClientProxy.panels.morphs.removeFromParent();
        }
        Dispatcher.sendToServer(new PacketModifyModelBlock(this.model.func_174877_v(), this.model));
        if (((Boolean)Blockbuster.modelBlockRestore.get()).booleanValue()) {
            this.old.put(this.model.func_174877_v(), this.model);
        }
    }

    public GuiModelBlockPanel openModelBlock(TileEntityModel model) {
        if (model != null && ((Boolean)Blockbuster.modelBlockRestore.get()).booleanValue() && this.old.containsKey(model.func_174877_v())) {
            TileEntityModel old = this.old.get(model.func_174877_v());
            model.copyData(old, false);
        }
        GuiModelBlockPanel.tryAddingBlock(model.func_174877_v());
        this.updateList();
        this.list.setVisible(false);
        return this.setModelBlock(model);
    }

    public GuiModelBlockPanel setModelBlock(TileEntityModel model) {
        this.save(model);
        this.list.setCurrent(model);
        this.subChildren.setVisible(model != null);
        this.model = model;
        this.fillData();
        return this;
    }

    private void updateList() {
        this.list.clear();
        for (BlockPos pos : lastBlocks) {
            this.list.addBlock(pos);
        }
        this.list.setCurrent(this.model);
    }

    private void fillData() {
        if (this.model != null) {
            this.yaw.setValue((double)this.model.getSettings().getRotateYawHead());
            this.pitch.setValue((double)this.model.getSettings().getRotatePitch());
            this.body.setValue((double)this.model.getSettings().getRotateBody());
            this.trans.set(this.model);
            this.pickMorph.setMorph(this.model.morph.get());
            int orderIndex = this.model.getSettings().getOrder().ordinal();
            if (orderIndex == 5) {
                this.order.setValue(0);
            } else if (orderIndex == 0) {
                this.order.setValue(1);
            }
            this.shadow.toggled(this.model.getSettings().isShadow());
            this.global.toggled(this.model.getSettings().isGlobal());
            this.enabled.toggled(this.model.getSettings().isEnabled());
            this.excludeResetPlayback.toggled(this.model.getSettings().isExcludeResetPlayback());
            this.renderLast.toggled(this.model.getSettings().isRenderLast());
            this.renderAlways.toggled(this.model.getSettings().isRenderAlways());
            this.enableBlockHitbox.toggled(this.model.getSettings().isBlockHitbox());
            this.lightLevel.setValue((double)this.model.getSettings().getLightValue());
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].setStack(this.model.getSettings().getSlots()[i]);
            }
        }
    }

    public void draw(GuiContext context) {
        AbstractMorph morph;
        if (this.model != null && (morph = this.model.morph.get()) != null) {
            int x = this.area.mx();
            int y = this.area.y + 30;
            int w = Math.max(this.font.func_78256_a(morph.name), this.font.func_78256_a(morph.getDisplayName()));
            Gui.func_73734_a((int)(x - w / 2 - 3), (int)(y - 20), (int)(x + w / 2 + 3), (int)y, (int)-2013265920);
            this.func_73732_a(this.font, morph.getDisplayName(), x, y - this.font.field_78288_b * 2, 0xFFFFFF);
            this.func_73732_a(this.font, morph.name, x, y - this.font.field_78288_b, 0xCCCCCC);
        }
        if (this.subChildren.isVisible()) {
            this.func_73731_b(this.font, I18n.func_135052_a((String)"blockbuster.gui.model_block.entity", (Object[])new Object[0]), this.yaw.area.x + 2, this.yaw.area.y - 12, 0xFFFFFF);
        } else if (this.model == null) {
            this.func_73732_a(this.font, I18n.func_135052_a((String)"blockbuster.gui.model_block.not_selected", (Object[])new Object[0]), this.area.mx(), this.area.my() - 6, 0xFFFFFF);
        }
        super.draw(context);
    }

    public static class GuiModelBlockTransformations
    extends GuiTransformations {
        public TileEntityModel model;

        public GuiModelBlockTransformations(Minecraft mc) {
            super(mc);
            this.one.callback = toggle -> {
                boolean one = toggle.isToggled();
                this.model.getSettings().setUniform(one);
                this.updateScaleFields();
                if (!one) {
                    this.sy.setValueAndNotify(this.sx.value);
                    this.sz.setValueAndNotify(this.sx.value);
                }
            };
        }

        public void set(TileEntityModel model) {
            this.model = model;
            if (model != null) {
                this.fillT(model.getSettings().getX(), model.getSettings().getY(), model.getSettings().getZ());
                this.fillS(model.getSettings().getSx(), model.getSettings().getSy(), model.getSettings().getSz());
                this.fillR(model.getSettings().getRx(), model.getSettings().getRy(), model.getSettings().getRz());
                this.one.toggled(model.getSettings().isUniform());
                this.updateScaleFields();
            }
        }

        public void setT(double x, double y, double z) {
            this.model.getSettings().setX((float)x);
            this.model.getSettings().setY((float)y);
            this.model.getSettings().setZ((float)z);
        }

        public void setS(double x, double y, double z) {
            this.model.getSettings().setSx((float)x);
            this.model.getSettings().setSy((float)y);
            this.model.getSettings().setSz((float)z);
        }

        public void setR(double x, double y, double z) {
            this.model.getSettings().setRx((float)x);
            this.model.getSettings().setRy((float)y);
            this.model.getSettings().setRz((float)z);
        }

        protected void localTranslate(double x, double y, double z) {
            this.model.getSettings().addTranslation(x, y, z, GuiTransformations.GuiStaticTransformOrientation.getOrientation());
            this.fillT(this.model.getSettings().getX(), this.model.getSettings().getY(), this.model.getSettings().getZ());
        }

        protected void prepareRotation(Matrix4f mat) {
            MatrixUtils.RotationOrder order = MatrixUtils.RotationOrder.valueOf((String)this.model.getSettings().getOrder().toString());
            float[] rot = new float[]{(float)this.rx.value, (float)this.ry.value, (float)this.rz.value};
            Matrix4f trans = new Matrix4f();
            trans.setIdentity();
            trans.set(MatrixUtils.Transformation.getRotationMatrix((int)order.thirdIndex, (double)rot[order.thirdIndex]));
            mat.mul(trans);
            trans.set(MatrixUtils.Transformation.getRotationMatrix((int)order.secondIndex, (double)rot[order.secondIndex]));
            mat.mul(trans);
            trans.set(MatrixUtils.Transformation.getRotationMatrix((int)order.firstIndex, (double)rot[order.firstIndex]));
            mat.mul(trans);
        }

        protected void postRotation(MatrixUtils.Transformation transform) {
            Vector3f result = transform.getRotation(MatrixUtils.RotationOrder.valueOf((String)this.model.getSettings().getOrder().toString()), new Vector3f((float)this.rx.value, (float)this.ry.value, (float)this.rz.value));
            this.rx.setValueAndNotify((double)result.x);
            this.ry.setValueAndNotify((double)result.y);
            this.rz.setValueAndNotify((double)result.z);
        }
    }
}

