/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.client.gui.dashboard.GuiBlockbusterPanel;
import mchorse.blockbuster.client.textures.MipmapTexture;
import mchorse.blockbuster.utils.TextureUtils;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiResourceLocationListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiSearchListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiMessageModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.mclib.GuiDashboard;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.ReflectionUtils;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.lwjgl.opengl.GL11;

public class GuiTextureManagerPanel
extends GuiBlockbusterPanel {
    public GuiSearchResourceLocationList textures;
    public GuiToggleElement linear;
    public GuiToggleElement mipmap;
    public GuiButtonElement remove;
    public GuiButtonElement replace;
    public GuiButtonElement export;
    public GuiIconElement copy;
    private ResourceLocation rl;
    private String title = I18n.func_135052_a((String)"blockbuster.gui.texture.title", (Object[])new Object[0]);
    private String subtitle = I18n.func_135052_a((String)"blockbuster.gui.texture.subtitle", (Object[])new Object[0]);

    public GuiTextureManagerPanel(Minecraft mc, GuiDashboard dashboard) {
        super(mc, dashboard);
        this.textures = new GuiSearchResourceLocationList(mc, rl -> this.pickRL((ResourceLocation)rl.get(0)));
        this.textures.list.background();
        this.linear = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.texture.linear"), false, b -> this.setLinear(b.isToggled()));
        this.linear.tooltip(IKey.lang((String)"blockbuster.gui.texture.linear_tooltip"), Direction.LEFT);
        this.mipmap = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.texture.mipmap"), false, b -> this.setMipmap(b.isToggled()));
        this.mipmap.tooltip(IKey.lang((String)"blockbuster.gui.texture.mipmap_tooltip"), Direction.LEFT);
        this.remove = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.remove"), b -> this.remove());
        this.replace = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.texture.replace"), b -> this.replace());
        this.export = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.texture.export"), b -> this.export());
        this.copy = new GuiIconElement(mc, Icons.COPY, b -> this.copy());
        this.copy.tooltip(IKey.lang((String)"blockbuster.gui.texture.copy"), Direction.TOP).flex().wh(20, 20);
        GuiElement element = new GuiElement(mc);
        element.flex().relative((GuiElement)this).xy(1.0f, 1.0f).w(148).anchor(1.0f, 1.0f).column(5).vertical().stretch().padding(10);
        this.textures.flex().relative((IResizer)this.area).set(10.0f, 50.0f, 0.0f, 0.0f).w(1.0f, -158).h(1.0f, -60);
        element.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (int)0, (GuiElement[])new GuiElement[]{this.export, this.copy}));
        element.add(new IGuiElement[]{this.replace, this.remove, this.linear, this.mipmap});
        this.add(new IGuiElement[]{this.textures, element});
    }

    public boolean isClientSideOnly() {
        return true;
    }

    private void copy() {
        ResourceLocation location = (ResourceLocation)this.textures.list.getCurrentFirst();
        if (location == null) {
            return;
        }
        GuiScreen.func_146275_d((String)location.toString());
    }

    private void export() {
        ResourceLocation location = (ResourceLocation)this.textures.list.getCurrentFirst();
        if (location == null) {
            return;
        }
        String name = FilenameUtils.getBaseName((String)location.func_110623_a());
        File folder = new File(ClientProxy.configFile, "export");
        File file = TextureUtils.getFirstAvailableFile(folder, name);
        folder.mkdirs();
        this.mc.field_71446_o.func_110577_a(location);
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        ByteBuffer buffer = GLAllocation.func_74524_c((int)(w * h * 4));
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        BufferedImage image = new BufferedImage(w, h, 2);
        int[] pixelData = new int[w * h];
        int c = w * h;
        for (int i = 0; i < c; ++i) {
            int r = buffer.get() & 0xFF;
            int g = buffer.get() & 0xFF;
            int b = buffer.get() & 0xFF;
            int a = buffer.get() & 0xFF;
            pixelData[i] = a << 24 | r << 16 | g << 8 | b;
        }
        image.setRGB(0, 0, w, h, pixelData, 0, w);
        try {
            ImageIO.write((RenderedImage)image, "png", file);
            GuiModal.addFullModal((GuiElement)this, () -> {
                GuiMessageModal modal = new GuiMessageModal(this.mc, IKey.format((String)"blockbuster.gui.texture.export_modal", (Object[])new Object[]{file.getName()}));
                GuiButtonElement open = new GuiButtonElement(this.mc, IKey.lang((String)"blockbuster.gui.texture.open_folder"), b -> {
                    modal.removeFromParent();
                    GuiUtils.openFolder((String)new File(ClientProxy.configFile, "export").getAbsolutePath());
                });
                modal.bar.add((IGuiElement)open);
                return modal;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiModal.addFullModal((GuiElement)this, () -> new GuiMessageModal(this.mc, IKey.lang((String)"blockbuster.gui.texture.export_error")));
        }
    }

    private void pickRL(ResourceLocation rl) {
        if (this.rl == null) {
            this.linear.toggled(false);
            this.mipmap.toggled(false);
            this.rl = rl;
        } else {
            try {
                this.mc.field_71446_o.func_110577_a(rl);
                int filter = GL11.glGetTexParameteri((int)3553, (int)10240);
                boolean mipmap = ReflectionUtils.getTextures((TextureManager)this.mc.field_71446_o).get(rl) instanceof MipmapTexture;
                boolean linear = filter == 9729 || filter == 9987 || filter == 9985;
                this.linear.toggled(linear);
                this.mipmap.toggled(mipmap);
                this.rl = rl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setLinear(boolean linear) {
        if (this.rl == null) {
            return;
        }
        this.mc.field_71446_o.func_110577_a(this.rl);
        boolean mipmap = this.mipmap.isToggled();
        int mod = linear ? (mipmap ? 9987 : 9729) : (mipmap ? 9986 : 9728);
        int mag = linear ? 9729 : 9728;
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)mod);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)mag);
    }

    private void setMipmap(boolean mipmap) {
        if (this.rl == null) {
            return;
        }
        Map map = ReflectionUtils.getTextures((TextureManager)this.mc.field_71446_o);
        Object tex = (ITextureObject)map.get(this.rl);
        boolean mipmapped = tex instanceof MipmapTexture;
        if (mipmap && !mipmapped) {
            GlStateManager.func_179150_h((int)((ITextureObject)map.remove(this.rl)).func_110552_b());
            try {
                tex = new MipmapTexture(this.rl);
                tex.func_110551_a(Minecraft.func_71410_x().func_110442_L());
                map.put(this.rl, tex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!mipmap && mipmapped) {
            GlStateManager.func_179150_h((int)((ITextureObject)map.remove(this.rl)).func_110552_b());
        }
    }

    private void remove() {
        if (this.rl == null) {
            return;
        }
        Map map = ReflectionUtils.getTextures((TextureManager)this.mc.field_71446_o);
        GlStateManager.func_179150_h((int)((ITextureObject)map.remove(this.rl)).func_110552_b());
        this.textures.list.remove((Object)this.rl);
        this.textures.list.setIndex(this.textures.list.getIndex() - 1);
        this.pickRL((ResourceLocation)this.textures.list.getCurrentFirst());
    }

    private void replace() {
        if (this.rl == null || GuiModal.hasModal((GuiElement)this)) {
            return;
        }
        GuiModal.addModal((GuiElement)this, () -> {
            GuiPromptModal modal = new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.texture.replace_modal"), this::replace);
            modal.text.field.func_146203_f(2000);
            modal.setValue(this.rl.toString());
            modal.flex().relative((IResizer)this.area).set(10.0f, 50.0f, 0.0f, 0.0f).w(1.0f, -158).h(1.0f, -60);
            return modal;
        });
    }

    private void replace(String string) {
        if (this.rl.toString().equals(string)) {
            return;
        }
        Map map = ReflectionUtils.getTextures((TextureManager)this.mc.field_71446_o);
        ITextureObject texture = (ITextureObject)map.get(RLUtils.create((String)string));
        if (texture != null) {
            map.put(this.rl, texture);
        }
    }

    public void open() {
        Map map = ReflectionUtils.getTextures((TextureManager)this.mc.field_71446_o);
        this.textures.list.clear();
        this.textures.list.getList().addAll(map.keySet());
        this.textures.list.sort();
        this.textures.list.update();
        this.pickRL(this.rl);
        this.textures.list.setCurrent((Object)this.rl);
    }

    public void draw(GuiContext context) {
        this.font.func_78276_b(this.title, this.area.x + 10, this.area.y + 10, 0xFFFFFF);
        this.font.func_78279_b(this.subtitle, this.area.x + 10, this.area.y + 26, this.area.w - 158, 0xCCCCCC);
        if (this.rl != null) {
            this.mc.field_71446_o.func_110577_a(this.rl);
            int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            int x = this.area.ex();
            int y = this.area.y + 10;
            int fw = w;
            int fh = h;
            if (fw > 128 || fh > 128) {
                fh = 128;
                fw = 128;
                if (w > h) {
                    fh = (int)((float)h / (float)w * (float)fw);
                } else if (h > w) {
                    fw = (int)((float)w / (float)h * (float)fh);
                }
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            Icons.CHECKBOARD.renderArea(x -= fw + 10, y, fw, fh);
            GlStateManager.func_179141_d();
            this.mc.field_71446_o.func_110577_a(this.rl);
            GuiDraw.drawBillboard((int)x, (int)y, (int)0, (int)0, (int)fw, (int)fh, (int)fw, (int)fh);
        }
        super.draw(context);
    }

    public static class GuiSearchResourceLocationList
    extends GuiSearchListElement<ResourceLocation> {
        public GuiSearchResourceLocationList(Minecraft mc, Consumer<List<ResourceLocation>> callback) {
            super(mc, callback);
        }

        protected GuiListElement<ResourceLocation> createList(Minecraft mc, Consumer<List<ResourceLocation>> callback) {
            return new GuiResourceLocationListElement(mc, callback);
        }
    }
}

