/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.capabilities;

import java.util.Map;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.capabilities.recording.IRecording;
import mchorse.blockbuster.capabilities.recording.Recording;
import mchorse.blockbuster.capabilities.recording.RecordingProvider;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.scene.PacketSceneCast;
import mchorse.blockbuster.network.common.structure.PacketStructureList;
import mchorse.blockbuster.network.server.ServerHandlerStructureRequest;
import mchorse.blockbuster.recording.RecordPlayer;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.scene.Scene;
import mchorse.blockbuster.recording.scene.SceneLocation;
import mchorse.blockbuster.utils.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CapabilityHandler {
    public static final ResourceLocation RECORDING_CAP = new ResourceLocation("blockbuster", "recording_capability");

    @SubscribeEvent
    public void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(RECORDING_CAP, (ICapabilityProvider)new RecordingProvider());
    }

    @SubscribeEvent
    public void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        Scene scene;
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        IRecording recording = Recording.get((EntityPlayer)player);
        Dispatcher.sendTo(new PacketStructureList(ServerHandlerStructureRequest.getAllStructures()), player);
        if (recording.getLastScene() != null && (scene = CommonProxy.scenes.get(recording.getLastScene(), player.field_70170_p)) != null) {
            Dispatcher.sendTo(new PacketSceneCast(new SceneLocation(scene)).open(false), player);
        }
        for (Map.Entry<String, Scene> entry : CommonProxy.scenes.getScenes().entrySet()) {
            entry.getValue().syncAudio(player);
        }
    }

    @SubscribeEvent
    public void playerStartsTracking(PlayerEvent.StartTracking event) {
        RecordPlayer playback;
        Entity target = event.getTarget();
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        if (target instanceof EntityLivingBase && (playback = EntityUtils.getRecordPlayer((EntityLivingBase)target)) != null) {
            RecordUtils.sendRequestedRecord(target.func_145782_y(), playback.record.filename, player);
        }
    }
}

