/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.audio;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.audio.AudioFile;
import mchorse.blockbuster.audio.AudioState;
import mchorse.mclib.utils.LatencyTimer;
import mchorse.mclib.utils.wav.Wave;
import mchorse.mclib.utils.wav.WavePlayer;
import mchorse.mclib.utils.wav.WaveReader;
import mchorse.mclib.utils.wav.Waveform;

public class AudioLibrary {
    public File folder;
    public Map<String, AudioFile> files = new HashMap<String, AudioFile>();

    public AudioLibrary(File folder) {
        this.folder = folder;
        this.folder.mkdirs();
    }

    public List<File> getFiles() {
        File[] files = this.folder.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files) {
            if (!file.getName().endsWith(".wav")) continue;
            list.add(file);
        }
        return list;
    }

    public List<String> getFileNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (File file : this.getFiles()) {
            String name = file.getName();
            list.add(name.substring(0, name.length() - 4));
        }
        return list;
    }

    private AudioFile load(String name, File file) {
        AudioFile audio;
        if (!file.isFile()) {
            return null;
        }
        try {
            Wave wave = new WaveReader().read((InputStream)new FileInputStream(file));
            if (wave.getBytesPerSample() > 2) {
                wave = wave.convertTo16();
            }
            WavePlayer player = new WavePlayer().initialize(wave);
            Waveform waveform = new Waveform();
            waveform.populate(wave, ((Integer)Blockbuster.audioWaveformDensity.get()).intValue(), 40);
            audio = new AudioFile(name + ".wav", file, player, waveform, file.lastModified());
        }
        catch (Exception e) {
            e.printStackTrace();
            audio = new AudioFile(name + ".wav", file, null, null, file.lastModified());
        }
        this.files.put(name, audio);
        return audio;
    }

    public boolean handleAudio(String audio, AudioState state, int shift, @Nullable LatencyTimer delay) {
        AudioFile file = this.files.get(audio);
        if (file == null || file.canBeUpdated()) {
            file = this.load(audio, new File(this.folder, audio + ".wav"));
        }
        if (file == null || file.isEmpty()) {
            return false;
        }
        WavePlayer player = file.player;
        float seconds = (float)shift / 20.0f;
        float elapsedDelay = delay != null ? (float)delay.getElapsedTime() / 1000.0f : 0.0f;
        System.out.println("Received audio latency of: " + elapsedDelay + " seconds");
        this.handleAudioState(state, player, seconds, elapsedDelay);
        return true;
    }

    private void handleAudioState(AudioState state, WavePlayer player, float seconds, float elapsedDelay) {
        switch (state) {
            case REWIND: {
                player.stop();
                player.play();
                player.setPlaybackPosition(seconds + elapsedDelay);
                break;
            }
            case PAUSE: {
                elapsedDelay = player.isPlaying() ? elapsedDelay : 0.0f;
                player.pause();
                player.setPlaybackPosition((seconds == 0.0f ? player.getPlaybackPosition() : seconds) - elapsedDelay);
                break;
            }
            case PAUSE_SET: {
                if (player.isStopped()) {
                    player.play();
                }
                player.pause();
                player.setPlaybackPosition(seconds);
                break;
            }
            case RESUME: {
                player.play();
                player.setPlaybackPosition(player.getPlaybackPosition() + elapsedDelay);
                break;
            }
            case RESUME_SET: {
                player.play();
                player.setPlaybackPosition(seconds + elapsedDelay);
                break;
            }
            case SET: {
                elapsedDelay = player.isPlaying() ? elapsedDelay : 0.0f;
                player.setPlaybackPosition(seconds + elapsedDelay);
                break;
            }
            case STOP: {
                player.stop();
            }
        }
    }

    public void reset() {
        for (AudioFile file : this.files.values()) {
            file.delete();
        }
        this.files.clear();
    }

    public void pause(boolean pause) {
        for (AudioFile file : this.files.values()) {
            file.pause(pause);
        }
    }
}

