/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.audio;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.audio.AudioState;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.audio.PacketAudio;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueString;
import mchorse.mclib.network.IByteBufSerializable;
import mchorse.mclib.network.INBTSerializable;
import mchorse.mclib.utils.ForgeUtils;
import mchorse.mclib.utils.ICopy;
import mchorse.mclib.utils.LatencyTimer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;

public class AudioHandler
implements ICopy<AudioHandler>,
INBTSerializable,
IByteBufSerializable {
    private AudioState audioState = AudioState.STOP;
    private final ValueInt audioShift = new ValueInt("audio_shift");
    private final ValueString audio = new ValueString("audio_name");
    private int tick;

    public String getAudioName() {
        return (String)this.audio.get();
    }

    public void setAudioName(String audio) {
        this.audio.set((Object)(audio == null ? "" : audio));
    }

    public int getAudioShift() {
        return (Integer)this.audioShift.get();
    }

    public void setAudioShift(int audioShift) {
        this.audioShift.set((Number)audioShift);
    }

    public AudioState getAudioState() {
        return this.audioState;
    }

    public boolean hasAudio() {
        return this.audio.get() != null && !((String)this.audio.get()).isEmpty();
    }

    public boolean isPlaying() {
        switch (this.audioState) {
            case REWIND: 
            case RESUME_SET: 
            case RESUME: 
            case SET: {
                return true;
            }
            case PAUSE: 
            case STOP: 
            case PAUSE_SET: {
                return false;
            }
        }
        return false;
    }

    public void pauseAudio() {
        this.setAudioStateTick(AudioState.PAUSE, this.tick);
    }

    public void pauseAudio(int tick) {
        this.setAudioStateTick(AudioState.PAUSE_SET, tick);
    }

    public void resume(int tick) {
        this.setAudioStateTick(AudioState.RESUME_SET, tick);
    }

    public void stopAudio() {
        this.audioState = AudioState.STOP;
        this.sendAudioState(AudioState.STOP, (Boolean)Blockbuster.audioSync.get());
    }

    public void goTo(int tick) {
        this.setAudioStateTick(this.isPlaying() ? AudioState.SET : AudioState.PAUSE_SET, tick);
    }

    public void startAudio(int tick) {
        this.setAudioStateTick(AudioState.REWIND, tick);
    }

    private void setAudioStateTick(AudioState state, int tick) {
        this.tick = tick;
        if ((Integer)this.audioShift.get() < 0 && tick < -((Integer)this.audioShift.get()).intValue()) {
            this.stopAudio();
            return;
        }
        this.audioState = state;
        this.sendAudioState(state, (Boolean)Blockbuster.audioSync.get());
    }

    public void update() {
        if ((Integer)this.audioShift.get() < 0 && this.tick >= -((Integer)this.audioShift.get()).intValue() && !this.isPlaying()) {
            this.startAudio(this.tick);
        }
        ++this.tick;
    }

    private void sendAudioState(AudioState state, boolean sync) {
        if (!this.hasAudio()) {
            return;
        }
        for (EntityPlayerMP player : ForgeUtils.getServerPlayers()) {
            this.sendAudioStateToPlayer(state, sync ? new LatencyTimer() : null, player);
        }
    }

    public void syncPlayer(EntityPlayerMP player) {
        AudioState state = this.audioState;
        switch (this.audioState) {
            case PAUSE: {
                state = AudioState.PAUSE_SET;
                break;
            }
            case RESUME: {
                state = AudioState.RESUME_SET;
            }
        }
        this.sendAudioStateToPlayer(state, (Boolean)Blockbuster.audioSync.get() != false ? new LatencyTimer() : null, player);
    }

    private void sendAudioStateToPlayer(AudioState state, @Nullable LatencyTimer latencyTimer, EntityPlayerMP player) {
        if (!this.hasAudio()) {
            return;
        }
        int shift = 0;
        switch (state) {
            case REWIND: 
            case RESUME_SET: 
            case SET: 
            case PAUSE_SET: {
                shift = this.tick;
                break;
            }
            case PAUSE: 
            case STOP: {
                shift = -((Integer)this.audioShift.get()).intValue();
            }
        }
        PacketAudio packet = new PacketAudio((String)this.audio.get(), state, shift + (Integer)this.audioShift.get(), latencyTimer);
        if (player != null) {
            Dispatcher.sendTo(packet, player);
        }
    }

    public AudioHandler copy() {
        AudioHandler clone = new AudioHandler();
        clone.copy(this);
        return clone;
    }

    public void copy(AudioHandler origin) {
        this.audio.copy((Value)origin.audio);
        this.audioState = origin.audioState;
        this.audioShift.copy((Value)origin.audioShift);
        this.tick = origin.tick;
    }

    public void fromNBT(NBTTagCompound compound) {
        this.audio.set((Object)(compound.func_74764_b("Audio") ? compound.func_74779_i("Audio") : ""));
        if (compound.func_74764_b("AudioShift")) {
            if (compound.func_74781_a("AudioShift") instanceof NBTTagFloat) {
                this.audioShift.set((Number)((int)(compound.func_74760_g("AudioShift") * 20.0f)));
            } else {
                this.audioShift.set((Number)compound.func_74762_e("AudioShift"));
            }
        }
    }

    public NBTTagCompound toNBT(NBTTagCompound compound) {
        if (this.audio.hasChanged()) {
            compound.func_74782_a("Audio", this.audio.valueToNBT());
        }
        if (this.audioShift.hasChanged()) {
            compound.func_74782_a("AudioShift", this.audioShift.valueToNBT());
        }
        return compound;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.audio.fromBytes(byteBuf);
        this.audioShift.fromBytes(byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        this.audio.toBytes(byteBuf);
        this.audioShift.toBytes(byteBuf);
    }
}

