/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api.loaders.lazy;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.formats.IMeshes;
import mchorse.blockbuster.api.loaders.lazy.IModelLazyLoader;
import mchorse.blockbuster.api.resource.FileEntry;
import mchorse.blockbuster.api.resource.IResourceEntry;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.parsing.ModelExtrudedLayer;
import mchorse.blockbuster.client.model.parsing.ModelParser;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;

public class ModelLazyLoaderJSON
implements IModelLazyLoader {
    public IResourceEntry model;
    public long lastTime;
    public int lastCount = -1;

    public ModelLazyLoaderJSON(IResourceEntry model) {
        this.model = model;
    }

    public int count() {
        return this.model.exists() ? 1 : 0;
    }

    @Override
    public long getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(long lastTime) {
        if (this.lastCount == -1) {
            this.lastCount = this.count();
        }
        this.lastTime = lastTime;
    }

    @Override
    public boolean stillExists() {
        return this.lastCount == this.count();
    }

    @Override
    public boolean hasChanged() {
        return this.model.hasChanged();
    }

    @Override
    public Model loadModel(String key) throws Exception {
        if (!this.model.exists()) {
            return null;
        }
        return Model.parse(this.model.getStream());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelCustom loadClientModel(String key, Model model) throws Exception {
        ModelCustom modelCustom = ModelCustom.MODELS.get(key);
        Minecraft.func_71410_x().func_152344_a(() -> ModelExtrudedLayer.clearByModel(modelCustom));
        Map<String, IMeshes> meshes = this.getMeshes(key, model);
        if (meshes != null) {
            for (String limb : meshes.keySet()) {
                if (model.limbs.containsKey(limb)) continue;
                model.addLimb(limb);
            }
        }
        if (!model.model.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(model.model);
                return ModelParser.parse(key, model, clazz, meshes);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return ModelParser.parse(key, model, meshes);
    }

    @SideOnly(value=Side.CLIENT)
    protected Map<String, IMeshes> getMeshes(String key, Model model) throws Exception {
        return null;
    }

    @Override
    public boolean copyFiles(File folder) {
        if (this.model instanceof FileEntry) {
            FileEntry file = (FileEntry)this.model;
            if (!file.file.getParentFile().equals(folder)) {
                try {
                    FileUtils.copyDirectory((File)new File(file.file.getParentFile(), "skins"), (File)new File(folder, "skins"));
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        return true;
    }
}

