/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.api.json.ModelAdapter;

public class ModelPoseAdapter
implements JsonSerializer<ModelPose> {
    public JsonElement serialize(ModelPose src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement serial = ModelAdapter.plainGSON.toJsonTree((Object)src, typeOfSrc);
        JsonObject map = serial.getAsJsonObject();
        JsonObject limbs = new JsonObject();
        map.remove("limbs");
        if (src.shapes.isEmpty()) {
            map.remove("shapes");
        }
        for (Map.Entry<String, ModelTransform> limb : src.limbs.entrySet()) {
            ModelTransform trans = limb.getValue();
            JsonObject transform = new JsonObject();
            boolean empty = true;
            if (!ModelPoseAdapter.isDefault(trans.translate, 0.0f)) {
                ModelPoseAdapter.addFloatArray(transform, "translate", trans.translate);
                empty = false;
            }
            if (!ModelPoseAdapter.isDefault(trans.rotate, 0.0f)) {
                ModelPoseAdapter.addFloatArray(transform, "rotate", trans.rotate);
                empty = false;
            }
            if (!ModelPoseAdapter.isDefault(trans.scale, 1.0f)) {
                ModelPoseAdapter.addFloatArray(transform, "scale", trans.scale);
                empty = false;
            }
            if (empty) continue;
            limbs.add(limb.getKey(), (JsonElement)transform);
        }
        map.add("limbs", (JsonElement)limbs);
        return map;
    }

    public static boolean isDefault(float[] array, float defaultValue) {
        return array[0] == defaultValue && array[1] == defaultValue && array[2] == defaultValue;
    }

    public static void addFloatArray(JsonObject map, String name, float[] array) {
        JsonArray jsonArray = new JsonArray();
        for (float num : array) {
            jsonArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(num)));
        }
        map.add(name, (JsonElement)jsonArray);
    }
}

