/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api.formats.obj;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.api.formats.IMeshes;
import mchorse.blockbuster.api.formats.Mesh;
import mchorse.blockbuster.api.formats.obj.MeshOBJ;
import mchorse.blockbuster.api.formats.obj.MeshesOBJ;
import mchorse.blockbuster.api.formats.obj.OBJDataMesh;
import mchorse.blockbuster.api.formats.obj.OBJFace;
import mchorse.blockbuster.api.formats.obj.OBJIndexGroup;
import mchorse.blockbuster.api.formats.obj.OBJMaterial;
import mchorse.blockbuster.api.formats.obj.Vector2f;
import mchorse.blockbuster.api.formats.obj.Vector3f;
import mchorse.mclib.commands.SubCommandBase;
import mchorse.mclib.utils.resources.RLUtils;

public class OBJParser {
    public InputStream objFile;
    public InputStream mtlFile;
    public List<Vector3f> vertices = new ArrayList<Vector3f>();
    public List<Vector2f> textures = new ArrayList<Vector2f>();
    public List<Vector3f> normals = new ArrayList<Vector3f>();
    public List<OBJDataMesh> objects = new ArrayList<OBJDataMesh>();
    public Map<String, OBJMaterial> materials = new HashMap<String, OBJMaterial>();

    public static String processMaterialName(String name) {
        return name.replaceAll("[/|\\\\]+", "-");
    }

    public static List<String> readAllLines(InputStream stream) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public OBJParser(InputStream objFile, InputStream mtlFile) {
        this.objFile = objFile;
        this.mtlFile = mtlFile;
    }

    public boolean equalData(OBJParser parser) {
        boolean result = this.vertices.size() == parser.vertices.size();
        result = result && this.textures.size() == parser.textures.size();
        result = result && this.normals.size() == parser.normals.size();
        result = result && this.objects.size() == parser.objects.size();
        block0: for (OBJDataMesh mesh : this.objects) {
            for (OBJDataMesh dataMesh : parser.objects) {
                if (!mesh.name.equals(dataMesh.name)) continue;
                result = result && mesh.groups.size() == dataMesh.groups.size();
                continue block0;
            }
            return false;
        }
        return result;
    }

    public void read() throws Exception {
        this.vertices.clear();
        this.textures.clear();
        this.normals.clear();
        this.objects.clear();
        this.materials.clear();
        this.readMTL();
        this.readOBJ();
    }

    public void setupTextures(String key, File folder) {
        for (OBJMaterial material : this.materials.values()) {
            if (!material.useTexture || material.texture != null) continue;
            material.texture = RLUtils.create((String)"b.a", (String)(key + "/skins/" + material.name + "/default.png"));
            new File(folder, "skins/" + material.name + "/").mkdirs();
        }
    }

    public void readMTL() throws Exception {
        if (this.mtlFile == null) {
            return;
        }
        List<String> lines = OBJParser.readAllLines(this.mtlFile);
        OBJMaterial material = null;
        for (String line : lines) {
            if (line.isEmpty()) continue;
            String[] tokens = line.split("\\s+");
            String first = tokens[0];
            if (first.equals("newmtl")) {
                material = new OBJMaterial(OBJParser.processMaterialName(tokens[1]));
                this.materials.put(material.name, material);
                continue;
            }
            if (first.equals("Kd") && tokens.length == 4) {
                material.r = Float.parseFloat(tokens[1]);
                material.g = Float.parseFloat(tokens[2]);
                material.b = Float.parseFloat(tokens[3]);
                continue;
            }
            if (first.equals("map_Kd")) {
                material.useTexture = true;
                continue;
            }
            if (first.equals("map_Kd_linear")) {
                material.linear = true;
                continue;
            }
            if (!first.equals("map_Kd_path")) continue;
            String texture = String.join((CharSequence)" ", SubCommandBase.dropFirstArgument((String[])tokens));
            material.texture = RLUtils.create((String)texture);
        }
    }

    public void readOBJ() throws Exception {
        List<String> lines = OBJParser.readAllLines(this.objFile);
        OBJDataMesh mesh = null;
        OBJMaterial material = null;
        for (String line : lines) {
            String[] faces;
            String[] tokens = line.split("\\s+");
            String first = tokens[0];
            if ((first.equals("o") || first.equals("g")) && tokens.length >= 2) {
                String name = tokens[1];
                mesh = null;
                for (OBJDataMesh data : this.objects) {
                    if (!data.name.equals(name)) continue;
                    mesh = data;
                    break;
                }
                if (mesh == null) {
                    mesh = new OBJDataMesh();
                    mesh.name = name;
                    this.objects.add(mesh);
                }
            }
            if (first.equals("v")) {
                this.vertices.add(new Vector3f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3])));
                continue;
            }
            if (first.equals("vt")) {
                this.textures.add(new Vector2f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2])));
                continue;
            }
            if (first.equals("vn")) {
                this.normals.add(new Vector3f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3])));
                continue;
            }
            if (first.equals("usemtl")) {
                material = this.materials.get(OBJParser.processMaterialName(tokens[1]));
                continue;
            }
            if (!first.equals("f")) continue;
            List<OBJFace> faceList = mesh.groups.get(material);
            if (faceList == null) {
                faceList = new ArrayList<OBJFace>();
                mesh.groups.put(material, faceList);
            }
            if ((faces = SubCommandBase.dropFirstArgument((String[])tokens)).length == 4) {
                faceList.add(new OBJFace(new String[]{faces[0], faces[1], faces[2]}));
                faceList.add(new OBJFace(new String[]{faces[0], faces[2], faces[3]}));
                continue;
            }
            if (faces.length == 3) {
                faceList.add(new OBJFace(faces));
                continue;
            }
            if (faces.length <= 4) continue;
            int c = faces.length - 2;
            for (int i = 0; i < c; ++i) {
                faceList.add(new OBJFace(new String[]{faces[0], faces[i + 1], faces[i + 2]}));
            }
        }
    }

    public Map<String, IMeshes> compile() {
        HashMap<String, IMeshes> meshes = new HashMap<String, IMeshes>();
        for (OBJDataMesh obj : this.objects) {
            MeshesOBJ meshObject = new MeshesOBJ();
            for (Map.Entry<OBJMaterial, List<OBJFace>> group : obj.groups.entrySet()) {
                List<OBJFace> faces = group.getValue();
                MeshOBJ mesh = new MeshOBJ(faces.size());
                int i = 0;
                for (OBJFace face : faces) {
                    for (OBJIndexGroup indexGroup : face.idxGroups) {
                        this.processFaceVertex(i, indexGroup, mesh);
                        ++i;
                    }
                }
                mesh.material = group.getKey();
                meshObject.meshes.add(mesh);
            }
            meshes.put(obj.name, meshObject);
        }
        return meshes;
    }

    private void processFaceVertex(int i, OBJIndexGroup indices, Mesh mesh) {
        if (indices.idxPos >= 0) {
            Vector3f vertex = this.vertices.get(indices.idxPos);
            mesh.posData[i * 3] = vertex.x;
            mesh.posData[i * 3 + 1] = vertex.y;
            mesh.posData[i * 3 + 2] = vertex.z;
        }
        if (indices.idxTextCoord >= 0) {
            Vector2f coord = this.textures.get(indices.idxTextCoord);
            mesh.texData[i * 2] = coord.x;
            mesh.texData[i * 2 + 1] = 1.0f - coord.y;
        }
        if (indices.idxVecNormal >= 0) {
            Vector3f normal = this.normals.get(indices.idxVecNormal);
            mesh.normData[i * 3] = normal.x;
            mesh.normData[i * 3 + 1] = normal.y;
            mesh.normData[i * 3 + 2] = normal.z;
        }
    }
}

