/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.aperture.gui;

import java.util.List;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraAPI;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.destination.AbstractDestination;
import mchorse.aperture.camera.destination.ClientDestination;
import mchorse.aperture.client.gui.GuiProfilesManager;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.aperture.network.common.PacketRequestProfiles;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketPlaybackButton;
import mchorse.blockbuster.recording.scene.SceneLocation;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPlayback
extends GuiBase {
    private String stringTitle = I18n.func_135052_a((String)"blockbuster.gui.playback.title", (Object[])new Object[0]);
    private String stringCameraMode = I18n.func_135052_a((String)"blockbuster.gui.playback.camera_mode", (Object[])new Object[0]);
    private String stringProfile = I18n.func_135052_a((String)"blockbuster.gui.playback.profile", (Object[])new Object[0]);
    private String stringScene = I18n.func_135052_a((String)"blockbuster.gui.playback.scene", (Object[])new Object[0]);
    private GuiCirculateElement cameraMode;
    private GuiButtonElement done;
    public GuiStringListElement scenes;
    public GuiListElement profiles;
    public Area frame = new Area();
    private SceneLocation location;
    private String profile = "";
    private boolean aperture;
    private int frameWidth = 150;

    public GuiPlayback() {
        Minecraft mc = Minecraft.func_71410_x();
        this.aperture = CameraHandler.isApertureLoaded();
        this.scenes = new GuiStringListElement(mc, value -> {
            this.location = new SceneLocation((String)value.get(0));
        });
        this.scenes.background().flex().relative((IResizer)this.frame).y(35).w(1.0f).h(1.0f, -65);
        this.done = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.done"), b -> this.saveAndQuit());
        this.done.flex().relative((IResizer)this.frame).set(0.0f, 0.0f, 0.0f, 20.0f).y(1.0f, -20).w(1.0f, 0);
        if (this.aperture) {
            this.frameWidth = 300;
            this.profiles = this.createListElement(mc);
            this.profiles.background().flex().set(153.0f, 35.0f, 0.0f, 0.0f).relative((IResizer)this.frame).w(147).h(1.0f, -105);
            this.scenes.flex().w(147);
            this.cameraMode = new GuiCirculateElement(mc, b -> this.setValue(this.cameraMode.getValue()));
            this.cameraMode.addLabel(IKey.lang((String)"blockbuster.gui.playback.nothing"));
            this.cameraMode.addLabel(IKey.lang((String)"blockbuster.gui.playback.play"));
            this.cameraMode.addLabel(IKey.lang((String)"blockbuster.gui.playback.load_profile"));
            this.cameraMode.flex().relative((IResizer)this.frame).set(153.0f, 0.0f, 0.0f, 20.0f).y(1.0f, -50).w(147);
            this.root.add(new IGuiElement[]{this.profiles, this.cameraMode});
            this.fillData();
        }
        this.root.add(new IGuiElement[]{this.scenes, this.done});
    }

    @Optional.Method(modid="aperture")
    private GuiListElement createListElement(Minecraft mc) {
        return new GuiProfilesManager.GuiCameraProfilesList(mc, null);
    }

    @Optional.Method(modid="aperture")
    private void fillData() {
        NBTTagCompound compound;
        for (String filename : CameraAPI.getClientProfiles()) {
            this.addDestination((AbstractDestination)new ClientDestination(filename));
        }
        this.profiles.sort();
        if (ClientProxy.server) {
            Dispatcher.sendToServer(new PacketRequestProfiles());
        }
        if ((compound = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77978_p()) != null) {
            if (compound.func_74764_b("CameraPlay")) {
                this.setValue(1);
            } else if (compound.func_74764_b("CameraProfile")) {
                this.setValue(2, compound.func_74779_i("CameraProfile"));
            } else {
                this.setValue(0);
            }
        } else {
            this.setValue(0);
        }
    }

    @Optional.Method(modid="aperture")
    public void selectCurrent() {
        this.selectCurrent(this.profile);
    }

    @Optional.Method(modid="aperture")
    public void selectCurrent(String profile) {
        List list = this.profiles.getList();
        for (int i = 0; i < list.size(); ++i) {
            if (!((CameraProfile)list.get(i)).getDestination().toResourceLocation().toString().equals(profile)) continue;
            this.profiles.setIndex(i);
            break;
        }
    }

    @Optional.Method(modid="aperture")
    private void sendPlaybackButton() {
        Dispatcher.sendToServer(new PacketPlaybackButton(this.location, this.cameraMode.getValue(), this.getSelected()));
    }

    @Optional.Method(modid="aperture")
    private String getSelected() {
        CameraProfile current = (CameraProfile)this.profiles.getCurrentFirst();
        if (current != null) {
            return current.getDestination().toResourceLocation().toString();
        }
        return "";
    }

    @Optional.Method(modid="aperture")
    public void addDestination(AbstractDestination destination) {
        this.profiles.add((Object)new CameraProfile(destination));
    }

    public GuiPlayback setLocation(SceneLocation location, List<String> scenes) {
        this.location = location;
        this.scenes.clear();
        this.scenes.add(scenes);
        this.scenes.sort();
        this.scenes.setCurrentScroll((Object)location.getFilename());
        return this;
    }

    public void setValue(int value) {
        this.cameraMode.setValue(value);
        this.profiles.setVisible(value == 2);
    }

    public void setValue(int value, String profile) {
        this.profile = profile;
        this.setValue(value);
        if (this.aperture) {
            this.selectCurrent(profile);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void saveAndQuit() {
        if (this.aperture) {
            this.sendPlaybackButton();
        } else {
            Dispatcher.sendToServer(new PacketPlaybackButton(this.location, 0, ""));
        }
        this.field_146297_k.func_147108_a(null);
    }

    public void func_73866_w_() {
        this.frame.set(this.field_146294_l / 2 - this.frameWidth / 2, 10, this.frameWidth, this.field_146295_m - 20);
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiDraw.drawCustomBackground((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m);
        this.func_73731_b(this.field_146289_q, this.stringTitle, this.frame.x, this.frame.y, -1);
        if (this.cameraMode != null) {
            this.func_73731_b(this.field_146289_q, this.stringCameraMode, this.cameraMode.area.x, this.cameraMode.area.y - 12, -3355444);
            if (this.cameraMode.getValue() == 2) {
                this.func_73731_b(this.field_146289_q, this.stringProfile, this.profiles.area.x, this.profiles.area.y - 12, -3355444);
            }
        }
        this.func_73731_b(this.field_146289_q, this.stringScene, this.scenes.area.x, this.scenes.area.y - 12, -3355444);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

