/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.aperture.gui;

import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.config.GuiAbstractConfigOptions;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.aperture.network.common.PacketAudioShift;
import mchorse.blockbuster.client.gui.dashboard.panels.scene.GuiScenePanel;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.scene.sync.PacketScenePlay;
import mchorse.blockbuster.recording.scene.SceneLocation;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiDirectorConfigOptions
extends GuiAbstractConfigOptions {
    private static GuiDirectorConfigOptions instance;
    public GuiButtonElement detachScene;
    public GuiToggleElement actions;
    public GuiToggleElement reload;
    public GuiToggleElement stopScene;
    public GuiButtonElement reloadScene;
    public GuiTrackpadElement audioShift;

    public static GuiDirectorConfigOptions getInstance() {
        return instance;
    }

    public GuiDirectorConfigOptions(Minecraft mc, GuiCameraEditor editor) {
        super(mc, editor);
        this.detachScene = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.aperture.config.detach"), b -> {
            if (CameraHandler.location != null) {
                Dispatcher.sendToServer(new PacketScenePlay(CameraHandler.location, 0, 0));
                CameraHandler.location = null;
                b.setEnabled(false);
            }
        });
        this.reload = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.aperture.config.reload"), ((Boolean)CameraHandler.reload.get()).booleanValue(), b -> CameraHandler.reload.set((Object)this.reload.isToggled()));
        this.actions = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.aperture.config.actions"), ((Boolean)CameraHandler.actions.get()).booleanValue(), b -> CameraHandler.actions.set((Object)this.actions.isToggled()));
        this.stopScene = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.aperture.config.stop_scene"), ((Boolean)CameraHandler.stopScene.get()).booleanValue(), b -> CameraHandler.stopScene.set((Object)this.stopScene.isToggled()));
        this.reloadScene = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.aperture.config.reload_scene"), b -> {
            SceneLocation location = CameraHandler.get();
            if (location != null) {
                Dispatcher.sendToServer(new PacketScenePlay(location, 4, mchorse.aperture.ClientProxy.getCameraEditor().timeline.value));
            }
        });
        this.audioShift = new GuiTrackpadElement(mc, value -> {
            SceneLocation location = CameraHandler.get();
            if (location != null) {
                Dispatcher.sendToServer(new PacketAudioShift(location, value.intValue()));
                GuiScenePanel panel = ClientProxy.panels.scenePanel;
                if (panel.getLocation().equals(location)) {
                    panel.getLocation().getScene().setAudioShift(value.intValue());
                }
            }
        });
        this.audioShift.integer().tooltip(IKey.lang((String)"blockbuster.gui.director.audio_shift_tooltip"));
        this.add(new IGuiElement[]{this.detachScene, this.reload, this.actions, this.stopScene, this.reloadScene});
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.director.audio_shift")).background(), this.audioShift});
        instance = this;
    }

    public IKey getTitle() {
        return IKey.lang((String)"blockbuster.gui.aperture.config.title");
    }

    public void update() {
        this.reload.toggled(((Boolean)CameraHandler.reload.get()).booleanValue());
        this.actions.toggled(((Boolean)CameraHandler.actions.get()).booleanValue());
        this.stopScene.toggled(((Boolean)CameraHandler.stopScene.get()).booleanValue());
    }

    public void resize() {
        super.resize();
        this.detachScene.setEnabled(CameraHandler.location != null);
    }
}

