/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft.client;

import com.mia.craftstudio.libgdx.Vector3;
import com.mia.craftstudio.minecraft.CraftStudioRendererVBO;
import com.mia.craftstudio.minecraft.INodeProvider;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVBO;
import com.mia.craftstudio.minecraft.forge.CSLibMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.lwjgl.opengl.GL11;

public class CSClientModelWrapperVariableVBO
extends CSClientModelWrapperVBO {
    private Set<CraftStudioRendererVBO> staticNodes1st;
    private Set<CraftStudioRendererVBO> staticNodes2nd;
    private List<Pattern> staticFilters = new ArrayList<Pattern>();
    private List<Pattern> inventoryFilters = new ArrayList<Pattern>();
    private Map<String, CSClientModelWrapperVBO.RenderingObject> roMain = new HashMap<String, CSClientModelWrapperVBO.RenderingObject>();
    Set<CraftStudioRendererVBO> renderers1st = new HashSet<CraftStudioRendererVBO>();
    Set<CraftStudioRendererVBO> renderers2nd = new HashSet<CraftStudioRendererVBO>();

    public CSClientModelWrapperVariableVBO(ModelMetadata metadata) {
        super(metadata);
        String pattern;
        for (String s : metadata.tileParams.get("VarRend_STATIC").split(";")) {
            pattern = s.replace(".", "\\.").replace("*", ".*").replace("?", ".");
            this.staticFilters.add(Pattern.compile(pattern));
        }
        for (String s : metadata.tileParams.get("VarRend_INVENTORY").split(";")) {
            pattern = s.replace(".", "\\.").replace("*", ".*").replace("?", ".");
            this.inventoryFilters.add(Pattern.compile(pattern));
        }
    }

    private Set<CraftStudioRendererVBO> computeNodesSet(Set<CraftStudioRendererVBO> nodes, List<Pattern> filter) {
        HashSet<CraftStudioRendererVBO> outSet = new HashSet<CraftStudioRendererVBO>();
        for (CraftStudioRendererVBO node : nodes) {
            for (Pattern p : filter) {
                String fullName;
                if (!p.matcher(fullName = node.getNode().getFullName()).matches()) continue;
                outSet.add(node);
            }
        }
        return outSet;
    }

    @Override
    protected void precompute() {
        for (CraftStudioRendererVBO renderer : this.topRenderers) {
            renderer.collectRenderers(this.renderers1st, this.renderers2nd);
        }
        this.staticNodes1st = this.computeNodesSet(this.renderers1st, this.staticFilters);
        this.staticNodes2nd = this.computeNodesSet(this.renderers2nd, this.staticFilters);
        Set<CraftStudioRendererVBO> inventoryNodes1st = this.computeNodesSet(this.renderers1st, this.inventoryFilters);
        Set<CraftStudioRendererVBO> inventoryNodes2nd = this.computeNodesSet(this.renderers2nd, this.inventoryFilters);
        inventoryNodes1st.addAll(this.staticNodes1st);
        inventoryNodes2nd.addAll(this.staticNodes2nd);
        this.roDefault = new CSClientModelWrapperVBO.RenderingObject(this.generateVBOs(inventoryNodes1st, inventoryNodes2nd), new int[]{inventoryNodes1st.size(), inventoryNodes2nd.size()}, this.metadata.faceCulling);
        this.isPrecomputed = true;
    }

    @Override
    public void render(Object instanceRenderState, float timeSinceLastRender, int pass, boolean renderOutline, float rotationAngle, Vector3 rotationVector, Vector3 preRotataionTranslation, Vector3 postRotataionTranslation) {
        if (!this.isPrecomputed) {
            this.precompute();
        }
        GL11.glPushMatrix();
        if (!Vector3.Zero.equals(preRotataionTranslation)) {
            GL11.glTranslatef((float)preRotataionTranslation.x, (float)preRotataionTranslation.y, (float)preRotataionTranslation.z);
        }
        if (!Vector3.Zero.equals(rotationVector)) {
            GL11.glRotatef((float)rotationAngle, (float)rotationVector.x, (float)rotationVector.y, (float)rotationVector.z);
        }
        if (!Vector3.Zero.equals(postRotataionTranslation)) {
            GL11.glTranslatef((float)postRotataionTranslation.x, (float)postRotataionTranslation.y, (float)postRotataionTranslation.z);
        }
        if (instanceRenderState instanceof INodeProvider) {
            INodeProvider tile = (INodeProvider)instanceRenderState;
            String hash = tile.getStatusHash();
            if (hash == null) {
                return;
            }
            if (!this.roMain.containsKey(hash)) {
                Set<CraftStudioRendererVBO> nodes1st = tile.getNodes(this.renderers1st);
                Set<CraftStudioRendererVBO> nodes2nd = tile.getNodes(this.renderers2nd);
                nodes1st.addAll(this.staticNodes1st);
                nodes2nd.addAll(this.staticNodes2nd);
                this.roMain.put(hash, new CSClientModelWrapperVBO.RenderingObject(this.generateVBOs(nodes1st, nodes2nd), new int[]{nodes1st.size(), nodes2nd.size()}, this.metadata.faceCulling));
            }
            this.renderWithVBO(this.roMain.get(hash), instanceRenderState, timeSinceLastRender, pass);
            if (renderOutline && CSLibMod.displayOutline) {
                this.renderOutline(this.roMain.get(hash), instanceRenderState, timeSinceLastRender);
            }
        } else {
            this.renderWithVBO(this.roDefault, instanceRenderState, timeSinceLastRender, pass);
        }
        GL11.glPopMatrix();
    }
}

