/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft;

import com.google.common.collect.HashBiMap;
import com.mia.craftstudio.minecraft.AnimationState;
import java.util.ArrayList;

public enum AnimationManager {
    INSTANCE;

    private ArrayList<TrackedObjectAnimationStates> animationStates = new ArrayList();
    private HashBiMap<Object, TrackedObjectAnimationStates> animationsMap = HashBiMap.create();
    private final ArrayList<AnimationState> EMPTY_LIST = new ArrayList();

    public void update(float timeDelta) {
        for (int i = this.animationStates.size() - 1; i >= 0; --i) {
            TrackedObjectAnimationStates animState = this.animationStates.get(i);
            animState.update(timeDelta);
            if (!animState.activeAnimations.isEmpty()) continue;
            this.animationStates.remove(i);
            this.animationsMap.inverse().remove((Object)animState);
        }
    }

    public static ArrayList<AnimationState> getActiveAnimations(Object o) {
        TrackedObjectAnimationStates animObj = (TrackedObjectAnimationStates)AnimationManager.INSTANCE.animationsMap.get(o);
        return animObj != null ? animObj.activeAnimations : AnimationManager.INSTANCE.EMPTY_LIST;
    }

    public static boolean addAnimationState(Object o, AnimationState state) {
        TrackedObjectAnimationStates animObj = (TrackedObjectAnimationStates)AnimationManager.INSTANCE.animationsMap.get(o);
        if (animObj != null) {
            return false;
        }
        animObj = new TrackedObjectAnimationStates();
        AnimationManager.INSTANCE.animationsMap.put(o, (Object)animObj);
        AnimationManager.INSTANCE.animationStates.add(animObj);
        animObj.activeAnimations.add(state);
        return true;
    }

    public static class TrackedObjectAnimationStates {
        public ArrayList<AnimationState> activeAnimations = new ArrayList();

        public void update(float timeDelta) {
            for (int i = this.activeAnimations.size() - 1; i >= 0; --i) {
                AnimationState anim = this.activeAnimations.get(i);
                System.out.println(System.currentTimeMillis());
                System.out.println(anim.frameTime);
                short duration = anim.animation.getAnimationDuration();
                if (anim.frameTime >= (float)duration) {
                    if (anim.repeatCount > 0 && --anim.repeatCount == 0) {
                        this.activeAnimations.remove(i);
                        continue;
                    }
                    anim.frameTime -= (float)duration;
                    anim.lastFullFrameRendered -= duration;
                }
                anim.frameTime += timeDelta;
            }
        }
    }
}

