/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.redstone;

import cassiokf.industrialrenewal.blocks.redstone.BlockEntityDetector;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySync;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityEntityDetector
extends TileEntitySync
implements ITickable {
    private EnumFacing blockFacing = EnumFacing.DOWN;
    private int distanceD = 6;
    private int tick = 0;
    private entityEnum eEnum = entityEnum.ALL;

    private Class<? extends Entity> getEntityToFilter() {
        switch (this.eEnum) {
            default: {
                return Entity.class;
            }
            case PLAYERS: {
                return EntityPlayer.class;
            }
            case MOBHOSTIL: {
                return EntityMob.class;
            }
            case MOBPASSIVE: {
                return EntityCreature.class;
            }
            case ITEMS: {
                return EntityItem.class;
            }
            case CARTS: 
        }
        return EntityMinecart.class;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.tick % 10 == 0) {
            this.tick = 0;
            this.changeState(this.passRedstone());
        }
        ++this.tick;
    }

    private void changeState(boolean value) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c).func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c);
        boolean actualValue = (Boolean)state.func_177229_b((IProperty)BlockEntityDetector.ACTIVE);
        if (actualValue != value) {
            this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)BlockEntityDetector.ACTIVE, (Comparable)Boolean.valueOf(value)), 3);
            this.sync();
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(this.getBlockFacing()), state.func_177230_c(), true);
        }
    }

    public boolean passRedstone() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing inFace = (EnumFacing)state.func_177229_b(BlockEntityDetector.FACING);
        return this.checkEntity(this.getEntityToFilter(), inFace);
    }

    private boolean checkEntity(Class<? extends Entity> entity, EnumFacing facing) {
        int distance = this.distanceD + 1;
        double posX = this.field_174879_c.func_177958_n() + 1;
        double posY = this.field_174879_c.func_177956_o() + 1;
        double posZ = this.field_174879_c.func_177952_p() + 1;
        switch (facing) {
            case DOWN: {
                posY += (double)distance;
                break;
            }
            case UP: {
                posY -= (double)distance;
                break;
            }
            case NORTH: {
                posZ -= (double)distance;
                break;
            }
            case SOUTH: {
                posZ += (double)distance;
                break;
            }
            case WEST: {
                posX -= (double)distance;
                break;
            }
            case EAST: {
                posX += (double)distance;
            }
        }
        List entities = this.field_145850_b.func_72872_a(entity, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), posX, posY, posZ));
        return !entities.isEmpty();
    }

    public EnumFacing getBlockFacing() {
        return this.blockFacing;
    }

    public void setBlockFacing(EnumFacing facing) {
        this.blockFacing = facing;
        this.func_70296_d();
    }

    public entityEnum getEntityEnum() {
        return this.eEnum;
    }

    public void setNextEntityEnum(boolean value) {
        int old = this.getEntityEnum().intValue;
        if (value) {
            this.eEnum = entityEnum.valueOf(old + 1);
        }
        this.sync();
    }

    public void setNextDistance() {
        ++this.distanceD;
        if (this.distanceD > 8) {
            this.distanceD = 1;
        }
        this.sync();
    }

    public int getDistance() {
        return this.distanceD;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("baseFacing", this.blockFacing.func_176745_a());
        tag.func_74768_a("distance", this.distanceD);
        tag.func_74768_a("EnumConfig", this.eEnum.intValue);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.blockFacing = EnumFacing.func_82600_a((int)tag.func_74762_e("baseFacing"));
        this.distanceD = tag.func_74762_e("distance");
        this.eEnum = entityEnum.valueOf(tag.func_74762_e("EnumConfig"));
    }

    public static enum entityEnum {
        ALL(0),
        PLAYERS(1),
        MOBHOSTIL(2),
        MOBPASSIVE(3),
        ITEMS(4),
        CARTS(5);

        public int intValue;

        private entityEnum(int value) {
            this.intValue = value;
        }

        public static entityEnum valueOf(int no) {
            if (no > entityEnum.values().length - 1) {
                no = 0;
            }
            for (entityEnum l : entityEnum.values()) {
                if (l.intValue != no) continue;
                return l;
            }
            throw new IllegalArgumentException("entityEnum not found");
        }
    }
}

