/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.railroad;

import cassiokf.industrialrenewal.blocks.BlockChunkLoader;
import cassiokf.industrialrenewal.blocks.railroad.BlockCargoLoader;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.railroad.TileEntityBaseLoader;
import cassiokf.industrialrenewal.tileentity.railroad.TileEntityLoaderRail;
import cassiokf.industrialrenewal.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityCargoLoader
extends TileEntityBaseLoader
implements ITickable {
    public final ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            TileEntityCargoLoader.this.sync();
        }
    };
    private final int itemsPerTick;
    private int intUnloadActivity;
    private boolean checked;
    private boolean master;
    private int noActivity;

    public TileEntityCargoLoader() {
        this.itemsPerTick = IRConfig.MainConfig.Railroad.maxLoaderItemPerTick;
        this.intUnloadActivity = 0;
        this.checked = false;
        this.noActivity = 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isMaster() && this.isUnload()) {
            IItemHandler handler;
            TileEntity te;
            if (this.cartActivity > 0) {
                --this.cartActivity;
                this.sync();
            }
            if ((te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b().func_177972_a(this.getBlockFacing().func_176734_d()))) != null && (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getBlockFacing())) != null) {
                Utils.moveItemsBetweenInventories((IItemHandler)this.inventory, handler);
            }
        }
    }

    @Override
    public boolean onMinecartPass(EntityMinecart cart, TileEntityLoaderRail loaderRail) {
        if (!this.field_145850_b.field_72995_K) {
            this.cartActivity = 10;
            IItemHandler cartCapability = (IItemHandler)cart.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            if (cartCapability != null) {
                if (this.isUnload()) {
                    if (Utils.moveItemsBetweenInventories(cartCapability, (IItemHandler)this.inventory, this.itemsPerTick)) {
                        this.noActivity = 0;
                        this.intUnloadActivity = 0;
                        this.loading = true;
                        return true;
                    }
                    ++this.intUnloadActivity;
                    this.loading = false;
                    if (this.waitE == TileEntityBaseLoader.waitEnum.WAIT_EMPTY) {
                        return !Utils.IsInventoryEmpty(cartCapability);
                    }
                    if (this.waitE == TileEntityBaseLoader.waitEnum.WAIT_FULL) {
                        return this.intUnloadActivity < 10 || !Utils.IsInventoryFull(cartCapability);
                    }
                } else {
                    if (Utils.moveItemsBetweenInventories((IItemHandler)this.inventory, cartCapability, this.itemsPerTick)) {
                        this.noActivity = 0;
                        this.intUnloadActivity = 0;
                        this.loading = true;
                        return true;
                    }
                    ++this.intUnloadActivity;
                    this.loading = false;
                    if (this.waitE == TileEntityBaseLoader.waitEnum.WAIT_FULL) {
                        return this.intUnloadActivity < 10 || !Utils.IsInventoryFull(cartCapability);
                    }
                    if (this.waitE == TileEntityBaseLoader.waitEnum.WAIT_EMPTY) {
                        return !Utils.IsInventoryEmpty(cartCapability);
                    }
                }
                if (this.waitE == TileEntityBaseLoader.waitEnum.NO_ACTIVITY) {
                    ++this.noActivity;
                    return this.noActivity < 10;
                }
            }
        }
        return this.waitE == TileEntityBaseLoader.waitEnum.NEVER;
    }

    public String getModeText() {
        String mode = I18n.func_135052_a((String)"tesr.ir.mode", (Object[])new Object[0]) + ": ";
        if (this.isUnload()) {
            return mode + I18n.func_135052_a((String)"gui.industrialrenewal.button.unloader_mode", (Object[])new Object[0]);
        }
        return mode + I18n.func_135052_a((String)"gui.industrialrenewal.button.loader_mode", (Object[])new Object[0]);
    }

    public String getTankText() {
        return I18n.func_135052_a((String)"tesr.ir.inventory", (Object[])new Object[0]);
    }

    public float getCartFluidAngle() {
        return Utils.getInvNorm((IItemHandler)this.inventory) * 180.0f;
    }

    public boolean isMaster() {
        if (!this.checked) {
            this.master = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockChunkLoader.MASTER);
            this.checked = true;
        }
        return this.master;
    }

    private BlockPos getMasterPos() {
        if (!this.func_145837_r() && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockCargoLoader && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCargoLoader.MASTER)).booleanValue()) {
            return this.field_174879_c;
        }
        return BlockCargoLoader.getMasterPos((IBlockAccess)this.field_145850_b, this.field_174879_c, this.getBlockFacing());
    }

    @Override
    public boolean isUnload() {
        return this.unload;
    }

    @Override
    public EnumFacing getBlockFacing() {
        if (this.blockFacing == null) {
            this.blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCargoLoader.FACING);
        }
        return this.blockFacing;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("activity", this.cartActivity);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.cartActivity = compound.func_74762_e("activity");
        super.func_145839_a(compound);
    }

    public <T> T getInternalCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        BlockPos masterPos = this.getMasterPos();
        if (masterPos == null) {
            return (T)super.getCapability(capability, facing);
        }
        TileEntityCargoLoader te = (TileEntityCargoLoader)this.field_145850_b.func_175625_s(masterPos);
        if (te != null && this.field_174879_c.equals((Object)masterPos.func_177984_a()) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)te.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }
}

