/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.handlers.IRSoundHandler;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntityMultiBlockBase;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import cassiokf.industrialrenewal.util.interfaces.IDynamicSound;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntitySteamTurbine
extends TileEntityMultiBlockBase<TileEntitySteamTurbine>
implements IDynamicSound {
    private final VoltsEnergyContainer energyContainer = new VoltsEnergyContainer(100000, 10240, 10240){

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return false;
        }

        @Override
        public void onEnergyChange() {
            TileEntitySteamTurbine.this.sync();
        }
    };
    private static final float volume = IRConfig.MainConfig.Sounds.turbineVolume * IRConfig.MainConfig.Sounds.masterVolumeMult;
    public FluidTank waterTank = new FluidTank(32000){

        public boolean canFill() {
            return false;
        }

        public void onContentsChanged() {
            TileEntitySteamTurbine.this.sync();
        }
    };
    private final FluidStack waterStack = new FluidStack(IRConfig.getWaterFromSteamFluid(), 1000);
    private int rotation;
    private int oldRotation;
    private static final int maxRotation = 16000;
    private static final int energyPerTick = IRConfig.MainConfig.Main.steamTurbineEnergyPerTick;
    private static final int steamPerTick = IRConfig.MainConfig.Main.steamTurbineSteamPerTick;
    public final FluidTank steamTank;
    private float steamReceivedNorm;

    public TileEntitySteamTurbine() {
        this.steamTank = new FluidTank(IRConfig.MainConfig.Main.steamTurbineSteamPerTick){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && fluid.amount > 0 && fluid.getFluid().getName().equals("steam");
            }

            public boolean canDrain() {
                return false;
            }

            protected void onContentsChanged() {
                TileEntitySteamTurbine.this.func_70296_d();
            }
        };
        this.steamReceivedNorm = 0.0f;
    }

    @Override
    public void onTick() {
        if (this.isMaster()) {
            if (!this.field_145850_b.field_72995_K) {
                this.steamToRotation();
                this.generateEnergyBasedOnRotation();
                this.extractEnergy();
                this.extractWater();
                if (this.oldRotation != this.rotation) {
                    this.oldRotation = this.rotation;
                    this.sync();
                }
            } else {
                this.updateSound();
            }
        }
    }

    public void steamToRotation() {
        int steamAmount = this.rotation > 15990 ? Utils.roundtoInteger(steamPerTick * ((16000 - this.rotation) / 10)) : steamPerTick;
        FluidStack fluidStack = this.steamTank.drainInternal(steamAmount, true);
        if (fluidStack == null) {
            return;
        }
        this.steamReceivedNorm = Utils.normalizeClamped(fluidStack.amount, 0.0f, steamPerTick);
        int torqueSum = (int)(this.steamReceivedNorm * 10.0f);
        this.waterStack.amount = Utils.roundtoInteger((float)(fluidStack.amount / IRConfig.MainConfig.Main.steamBoilerConversionFactor) * 0.98f);
        this.waterTank.fillInternal(this.waterStack, true);
        this.rotation += torqueSum;
    }

    private void generateEnergyBasedOnRotation() {
        if (this.rotation >= 6000) {
            int energy = this.getEnergyProduction();
            this.energyContainer.receiveInternally(energy, false);
            this.load(energy);
        }
        this.rotationDecay();
        this.rotation = MathHelper.func_76125_a((int)this.rotation, (int)0, (int)16000);
    }

    private void extractEnergy() {
        IEnergyStorage upTank;
        EnumFacing facing = this.getMasterFacing();
        TileEntity eTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing.func_176734_d()).func_177977_b().func_177967_a(facing.func_176735_f(), 2));
        if (eTE != null && this.energyContainer.getEnergyStored() > 0 && (upTank = (IEnergyStorage)eTE.getCapability(CapabilityEnergy.ENERGY, facing.func_176746_e())) != null) {
            this.energyContainer.extractEnergyInternally(upTank.receiveEnergy(this.energyContainer.extractEnergyInternally(10240, true), false), false);
        }
    }

    private void extractWater() {
        IFluidHandler wTank;
        EnumFacing facing = this.getMasterFacing();
        TileEntity wTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(facing, 2).func_177977_b());
        if (wTE != null && this.waterTank.getFluidAmount() > 0 && (wTank = (IFluidHandler)wTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) != null) {
            this.waterTank.drain(wTank.fill(this.waterTank.drain(2000, false), true), true);
        }
    }

    @Override
    public float getPitch() {
        return Math.max(this.getRotation(), 0.1f);
    }

    @Override
    public float getVolume() {
        return volume;
    }

    private void updateSound() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.rotation > 0) {
            IRSoundHandler.playRepeatableSound(IRSoundRegister.MOTOR_ROTATION_RESOURCEL, volume, this.getPitch(), this.field_174879_c);
        } else {
            IRSoundHandler.stopTileSound(this.field_174879_c);
        }
    }

    @Override
    public void onMasterBreak() {
        if (this.field_145850_b.field_72995_K) {
            IRSoundHandler.stopTileSound(this.field_174879_c);
        }
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TileEntitySteamTurbine;
    }

    private int getEnergyProduction() {
        float factor;
        int energy = Math.round((float)energyPerTick * this.getRotation());
        int remainingEnergy = this.energyContainer.getMaxEnergyStored() - this.energyContainer.getEnergyStored();
        if (remainingEnergy < (energy = Utils.roundtoInteger((float)energy * (factor = this.waterTank.getFluidAmount() == 0 ? 1.0f : Math.max(0.5f, Math.min(1.0f, (float)this.waterTank.getCapacity() / (float)this.waterTank.getFluidAmount() - 0.5f)))))) {
            energy = remainingEnergy;
        }
        energy = MathHelper.func_76125_a((int)energy, (int)0, (int)energyPerTick);
        return energy;
    }

    private void load(int load) {
        float loadFactor = Utils.normalizeClamped(load, 0.0f, energyPerTick);
        int torque = loadFactor > 0.0f ? (int)(1.0f + loadFactor * 6.0f) : 0;
        this.rotation -= torque;
    }

    private void rotationDecay() {
        int decay = this.rotation < 6000 ? 3 : (int)(1.0f + this.getRotation() * 2.0f);
        this.rotation -= decay;
    }

    public String getWaterText() {
        return FluidRegistry.WATER.getName();
    }

    public String getSteamText() {
        return "Steam";
    }

    public String getGenerationText() {
        int energy = this.rotation >= 6000 && this.energyContainer.getEnergyStored() < this.energyContainer.getMaxEnergyStored() ? this.getEnergyProduction() : 0;
        return Utils.formatEnergyString(energy) + "/t";
    }

    public String getEnergyText() {
        int energy = this.energyContainer.getEnergyStored();
        return Utils.formatEnergyString(energy);
    }

    public String getRotationText() {
        return this.rotation / 10 + " rpm";
    }

    public float getEnergyFill() {
        return Utils.normalizeClamped(this.energyContainer.getEnergyStored(), 0.0f, this.energyContainer.getMaxEnergyStored());
    }

    private float getRotation() {
        return Utils.normalizeClamped(this.rotation, 0.0f, 16000.0f);
    }

    public float getGenerationFill() {
        float currentAmount = this.rotation >= 6000 && this.energyContainer.getEnergyStored() < this.energyContainer.getMaxEnergyStored() ? this.getEnergyProduction() : 0;
        return Utils.normalizeClamped(currentAmount, 0.0f, energyPerTick) * 90.0f;
    }

    public float getWaterFill() {
        return Utils.normalizeClamped(this.waterTank.getFluidAmount(), 0.0f, this.waterTank.getCapacity()) * 180.0f;
    }

    public float getSteamFill() {
        return this.steamReceivedNorm * 180.0f;
    }

    public float getRotationFill() {
        return this.getRotation() * 140.0f;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound waterTag = new NBTTagCompound();
        this.waterTank.writeToNBT(waterTag);
        compound.func_74782_a("water", (NBTBase)waterTag);
        compound.func_74782_a("StoredIR", (NBTBase)this.energyContainer.serializeNBT());
        compound.func_74768_a("heat", this.rotation);
        compound.func_74776_a("steamOnTick", this.steamReceivedNorm);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound waterTag = compound.func_74775_l("water");
        this.waterTank.readFromNBT(waterTag);
        this.energyContainer.deserializeNBT(compound.func_74775_l("StoredIR"));
        this.rotation = compound.func_74762_e("heat");
        this.steamReceivedNorm = compound.func_74760_g("steamOnTick");
        super.func_145839_a(compound);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntitySteamTurbine masterTE = (TileEntitySteamTurbine)this.getMaster();
        if (masterTE == null) {
            return (T)super.getCapability(capability, facing);
        }
        EnumFacing face = this.getMasterFacing();
        BlockPos masterPos = masterTE.func_174877_v();
        if (facing == EnumFacing.UP && this.field_174879_c.equals((Object)masterPos.func_177984_a()) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)masterTE.steamTank);
        }
        if (facing == face && this.field_174879_c.equals((Object)masterPos.func_177977_b().func_177972_a(face)) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)masterTE.waterTank);
        }
        if (facing == face.func_176735_f() && this.field_174879_c.equals((Object)masterPos.func_177977_b().func_177972_a(face.func_176734_d()).func_177972_a(face.func_176735_f())) && capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)masterTE.energyContainer);
        }
        return (T)super.getCapability(capability, facing);
    }
}

