/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.network;

import cassiokf.industrialrenewal.tileentity.redstone.TileEntityEntityDetector;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketReturnEntityDetector
implements IMessage {
    private BlockPos pos;
    private int dimension;
    private int ButtonId;
    private boolean messageValid;

    public PacketReturnEntityDetector() {
        this.messageValid = false;
    }

    public PacketReturnEntityDetector(BlockPos pos, int dimension, int ButtonId) {
        this.dimension = dimension;
        this.pos = pos;
        this.ButtonId = ButtonId;
        this.messageValid = true;
    }

    public PacketReturnEntityDetector(TileEntityEntityDetector te, int ButtonId) {
        this(te.func_174877_v(), te.func_145831_w().field_73011_w.getDimension(), ButtonId);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.dimension = buf.readInt();
            this.ButtonId = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.out.println(ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.dimension);
        buf.writeInt(this.ButtonId);
    }

    public static class Handler
    implements IMessageHandler<PacketReturnEntityDetector, IMessage> {
        public IMessage onMessage(PacketReturnEntityDetector message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension);
            TileEntityEntityDetector te = (TileEntityEntityDetector)world.func_175625_s(message.pos);
            if (te != null) {
                if (message.ButtonId == 1) {
                    te.setNextDistance();
                } else if (message.ButtonId == 2) {
                    te.setNextEntityEnum(true);
                }
                return null;
            }
            return null;
        }
    }
}

