/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.init;

import cassiokf.industrialrenewal.handlers.IRSoundHandler;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IRSoundRegister {
    public static final ObjectSet<String> TICKABLE_SOUNDS = new ObjectOpenHashSet();
    public static final ObjectSet<String> REPEATABLE_SOUNDS = new ObjectOpenHashSet();
    public static final ResourceLocation PUMP_ROTATION_RESOURCEL = new ResourceLocation("industrialrenewal", "pump_rotation");
    public static final ResourceLocation TILEENTITY_TRAINHORN_RESOURCEL = new ResourceLocation("industrialrenewal", "railroad.train_horn");
    public static final ResourceLocation TILEENTITY_VALVE_CHANGE_RESOURCEL = new ResourceLocation("industrialrenewal", "valve");
    public static final ResourceLocation TILEENTITY_ALARM_RESOURCEL = new ResourceLocation("industrialrenewal", "modern_alarm");
    public static final ResourceLocation ITEM_DRILL_RESOURCEL = new ResourceLocation("industrialrenewal", "drill");
    public static final ResourceLocation BLOCK_CATWALKGATE_OPEN_RESOURCEL = new ResourceLocation("industrialrenewal", "gate_opening");
    public static final ResourceLocation BLOCK_CATWALKGATE_CLOSE_RESOURCEL = new ResourceLocation("industrialrenewal", "gate_closing");
    public static final ResourceLocation EFFECT_SHOCK_RESOURCEL = new ResourceLocation("industrialrenewal", "spark");
    public static final ResourceLocation DISC_1_RESOURCEL = new ResourceLocation("industrialrenewal", "music.visager_royal_entrance");
    public static final ResourceLocation BOOK_FLIP_RESOURCEL = new ResourceLocation("industrialrenewal", "book_flip");
    public static final ResourceLocation MOTOR_ROTATION_RESOURCEL = new ResourceLocation("industrialrenewal", "motor_rotation");
    public static final ResourceLocation PUMP_START_RESOURCEL = new ResourceLocation("industrialrenewal", "pump_start");
    public static final ResourceLocation LATHE_RESOURCEL = new ResourceLocation("industrialrenewal", "lathe");
    public static final ResourceLocation LATHE_STOP_RESOURCEL = new ResourceLocation("industrialrenewal", "lathe_off");
    public static final ResourceLocation GENERATOR_RESOURCEL = new ResourceLocation("industrialrenewal", "port_generator");
    public static final ResourceLocation MINING_RESOURCEL = new ResourceLocation("industrialrenewal", "mining");
    public static SoundEvent TILEENTITY_TRAINHORN;
    public static SoundEvent TILEENTITY_VALVE_CHANGE;
    public static SoundEvent TILEENTITY_ALARM;
    public static SoundEvent ITEM_DRILL;
    public static SoundEvent BLOCK_CATWALKGATE_OPEN;
    public static SoundEvent BLOCK_CATWALKGATE_CLOSE;
    public static SoundEvent EFFECT_SHOCK;
    public static SoundEvent DISC_1;
    public static SoundEvent BOOK_FLIP;
    public static SoundEvent MOTOR_ROTATION;
    public static SoundEvent PUMP_ROTATION;
    public static SoundEvent PUMP_START;
    public static SoundEvent LATHE;
    public static SoundEvent LATHE_STOP;
    public static SoundEvent GENERATOR;
    public static SoundEvent MINING;

    public static void registerSounds() {
        TILEENTITY_TRAINHORN = IRSoundRegister.registerSound("railroad.train_horn", TILEENTITY_TRAINHORN_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        TILEENTITY_VALVE_CHANGE = IRSoundRegister.registerSound("valve", TILEENTITY_VALVE_CHANGE_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        TILEENTITY_ALARM = IRSoundRegister.registerSound("modern_alarm", TILEENTITY_ALARM_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        ITEM_DRILL = IRSoundRegister.registerSound("drill", ITEM_DRILL_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        BLOCK_CATWALKGATE_OPEN = IRSoundRegister.registerSound("gate_opening", BLOCK_CATWALKGATE_OPEN_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        BLOCK_CATWALKGATE_CLOSE = IRSoundRegister.registerSound("gate_closing", BLOCK_CATWALKGATE_CLOSE_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        EFFECT_SHOCK = IRSoundRegister.registerSound("spark", EFFECT_SHOCK_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        DISC_1 = IRSoundRegister.registerSound("music.visager_royal_entrance", DISC_1_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        BOOK_FLIP = IRSoundRegister.registerSound("book_flip", BOOK_FLIP_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        MOTOR_ROTATION = IRSoundRegister.registerSound("motor_rotation", MOTOR_ROTATION_RESOURCEL, IRSoundHandler.EnumSoundType.DYNAMIC);
        PUMP_ROTATION = IRSoundRegister.registerSound("pump_rotation", PUMP_ROTATION_RESOURCEL, IRSoundHandler.EnumSoundType.REPEATABLE_ONLY);
        PUMP_START = IRSoundRegister.registerSound("pump_start", PUMP_START_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        LATHE = IRSoundRegister.registerSound("lathe", LATHE_RESOURCEL, IRSoundHandler.EnumSoundType.REPEATABLE_ONLY);
        LATHE_STOP = IRSoundRegister.registerSound("lathe_off", LATHE_STOP_RESOURCEL, IRSoundHandler.EnumSoundType.NORMAL);
        GENERATOR = IRSoundRegister.registerSound("port_generator", GENERATOR_RESOURCEL, IRSoundHandler.EnumSoundType.REPEATABLE_ONLY);
        MINING = IRSoundRegister.registerSound("mining", MINING_RESOURCEL, IRSoundHandler.EnumSoundType.REPEATABLE_ONLY);
    }

    private static SoundEvent registerSound(String name, ResourceLocation location, IRSoundHandler.EnumSoundType type) {
        SoundEvent event = new SoundEvent(location);
        switch (type) {
            default: {
                break;
            }
            case REPEATABLE_ONLY: {
                REPEATABLE_SOUNDS.add((Object)location.toString());
                break;
            }
            case DYNAMIC: {
                TICKABLE_SOUNDS.add((Object)location.toString());
            }
        }
        event.setRegistryName(name);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
        return event;
    }
}

