/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.handlers;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.entity.LocomotiveBase;
import cassiokf.industrialrenewal.gui.GUIStorageChest;
import cassiokf.industrialrenewal.gui.GUIWire;
import cassiokf.industrialrenewal.handlers.CouplingHandler;
import cassiokf.industrialrenewal.item.ItemCartLinkable;
import cassiokf.industrialrenewal.recipes.LatheRecipe;
import cassiokf.industrialrenewal.world.generation.OreGeneration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="industrialrenewal")
public class EventHandler {
    public static final String id = "indr_" + IRConfig.MainConfig.Generation.deepVeinID;
    public static final String deepVeinKeyItem = id + "_id";
    public static final String deepVeinKeyQuantity = id + "_q";

    @SubscribeEvent
    public static void onMinecartUpdate(MinecartUpdateEvent event) {
        EntityMinecart cart = event.getMinecart();
        CouplingHandler.onMinecartTick(cart);
        if (cart instanceof LocomotiveBase) {
            ((LocomotiveBase)cart).onLocomotiveUpdate();
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractWithMineCarts(MinecartInteractEvent event) {
        if (!(event.getItem().func_77973_b() instanceof ItemCartLinkable)) {
            return;
        }
        event.setCanceled(true);
        EntityPlayer thePlayer = event.getPlayer();
        if (thePlayer.func_130014_f_().field_72995_K || !event.getHand().equals((Object)EnumHand.MAIN_HAND)) {
            return;
        }
        ItemCartLinkable.onPlayerUseLinkableItemOnCart(thePlayer, event.getMinecart());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> ev) {
        LatheRecipe.populateLatheRecipes();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onKeyboardEvent(GuiScreenEvent.KeyboardInputEvent event) {
        GuiScreen screen = event.getGui();
        if (screen instanceof GUIStorageChest) {
            ((GUIStorageChest)screen).onKeyboardEvent(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        new GUIWire(Minecraft.func_71410_x());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkDataEvent.Load event) {
        ItemStack stack;
        if (event.getWorld().field_72995_K || event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        NBTTagCompound data = event.getData();
        if (data.func_74764_b(deepVeinKeyItem) && data.func_74764_b(deepVeinKeyQuantity)) {
            int id = data.func_74762_e(deepVeinKeyItem);
            int count = data.func_74762_e(deepVeinKeyQuantity);
            if (count == 0) {
                count = 1;
            }
            stack = new ItemStack(Item.func_150899_d((int)id));
            stack.func_190920_e(count);
        } else {
            stack = OreGeneration.generateNewVein(event.getWorld());
            event.getChunk().func_76630_e();
        }
        if (!OreGeneration.CHUNKS_VEIN.containsKey(event.getChunk().func_76632_l())) {
            OreGeneration.CHUNKS_VEIN.put(event.getChunk().func_76632_l(), stack);
        }
    }

    @SubscribeEvent
    public static void onChunkSave(ChunkDataEvent.Save event) {
        if (event.getWorld().field_72995_K || event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        ItemStack stack = OreGeneration.CHUNKS_VEIN.get(event.getChunk().func_76632_l());
        if (stack == null) {
            stack = OreGeneration.generateNewVein(event.getWorld());
            OreGeneration.CHUNKS_VEIN.put(event.getChunk().func_76632_l(), stack);
        }
        NBTTagCompound data = event.getData();
        data.func_74768_a(deepVeinKeyItem, Item.func_150891_b((Item)stack.func_77973_b()));
        data.func_74768_a(deepVeinKeyQuantity, stack.func_190916_E() <= 0 ? 1 : stack.func_190916_E());
        if (!event.getChunk().func_177410_o()) {
            OreGeneration.CHUNKS_VEIN.remove(event.getChunk().func_76632_l());
        }
    }
}

