/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.entity;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.entity.EntitySteamLocomotive;
import cassiokf.industrialrenewal.entity.EntityTenderBase;
import cassiokf.industrialrenewal.entity.RotatableBase;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.item.ItemIronPlow;
import cassiokf.industrialrenewal.util.interfaces.ICoupleCart;
import cassiokf.industrialrenewal.util.interfaces.ISync;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class LocomotiveBase
extends RotatableBase
implements ICoupleCart,
ISync {
    private static final DataParameter<Boolean> PLOW = EntityDataManager.func_187226_a(EntitySteamLocomotive.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean hasPlowItem;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() instanceof ItemIronPlow;
        }

        protected void onContentsChanged(int slot) {
            LocomotiveBase.this.sync();
        }
    };
    public EntityTenderBase tender;

    public LocomotiveBase(World worldIn) {
        super(worldIn);
    }

    public LocomotiveBase(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public void onLocomotiveUpdate() {
    }

    public void moveForward() {
        EnumFacing cartDir = this.func_184172_bi();
        double acceleration = 0.04;
        this.field_70159_w += (double)cartDir.func_82601_c() * acceleration;
        this.field_70179_y += (double)cartDir.func_82599_e() * acceleration;
        this.field_70159_w = MathHelper.func_151237_a((double)this.field_70159_w, (double)(-this.getMaxCartSpeedOnRail()), (double)this.getMaxCartSpeedOnRail());
        this.field_70179_y = MathHelper.func_151237_a((double)this.field_70179_y, (double)(-this.getMaxCartSpeedOnRail()), (double)this.getMaxCartSpeedOnRail());
    }

    public void setTender(EntityTenderBase tender) {
        this.tender = tender;
    }

    private boolean hasPlowItem() {
        boolean temp = false;
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            temp = true;
        }
        this.hasPlowItem = temp;
        return this.hasPlowItem;
    }

    public void horn() {
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), IRSoundRegister.TILEENTITY_TRAINHORN, SoundCategory.NEUTRAL, 2.0f * IRConfig.MainConfig.Sounds.masterVolumeMult, 1.0f);
    }

    protected double getMaxSpeed() {
        return super.getMaxSpeed();
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_70099_a(new ItemStack((Item)ModItems.steamLocomotive, 1), 0.0f);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.sync();
    }

    @Override
    public void sync() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(PLOW, (Object)this.hasPlowItem());
        }
    }

    @Override
    public World getThisWorld() {
        return this.func_130014_f_();
    }

    @Override
    public BlockPos getThisPosition() {
        return this.func_180425_c();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, facing));
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.FURNACE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PLOW, (Object)false);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && key.equals(PLOW)) {
            this.hasPlowItem = (Boolean)this.field_70180_af.func_187225_a(PLOW);
        }
    }
}

