/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.redstone;

import cassiokf.industrialrenewal.blocks.abstracts.BlockTileEntity;
import cassiokf.industrialrenewal.tileentity.redstone.TileEntityTrafficLight;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTrafficLight
extends BlockTileEntity<TileEntityTrafficLight> {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ONWALL = PropertyBool.func_177716_a((String)"onwall");
    public static final PropertyInteger SIGNAL = PropertyInteger.func_177719_a((String)"signal", (int)0, (int)2);
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.875, 0.75);
    private static final AxisAlignedBB WEST_BLOCK_AABB = new AxisAlignedBB(0.0, 0.125, 0.25, 0.5, 0.875, 0.75);
    private static final AxisAlignedBB EAST_BLOCK_AABB = new AxisAlignedBB(1.0, 0.125, 0.25, 0.5, 0.875, 0.75);
    private static final AxisAlignedBB SOUTH_BLOCK_AABB = new AxisAlignedBB(0.25, 0.125, 0.5, 0.75, 0.875, 1.0);
    private static final AxisAlignedBB NORTH_BLOCK_AABB = new AxisAlignedBB(0.25, 0.125, 0.5, 0.75, 0.875, 0.0);

    public BlockTrafficLight(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.field_149784_t = 7;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ONWALL, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(0)));
    }

    private int getSignal(IBlockAccess world, BlockPos pos) {
        TileEntityTrafficLight te = (TileEntityTrafficLight)world.func_175625_s(pos);
        return te.active();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(this.getSignal(world, pos)));
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a());
        }
        return super.func_176196_c(worldIn, pos);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)ONWALL, (Comparable)Boolean.valueOf(facing != EnumFacing.UP));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ONWALL, SIGNAL});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)ONWALL, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ONWALL)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"tile.industrialrenewal.traffic_light.des0", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tile.industrialrenewal.traffic_light.des1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tile.industrialrenewal.traffic_light.des2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tile.industrialrenewal.traffic_light.des3", (Object[])new Object[0]));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)ONWALL)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                default: {
                    return NORTH_BLOCK_AABB;
                }
                case SOUTH: {
                    return SOUTH_BLOCK_AABB;
                }
                case EAST: {
                    return EAST_BLOCK_AABB;
                }
                case WEST: 
            }
            return WEST_BLOCK_AABB;
        }
        return BASE_AABB;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @Nullable
    public TileEntityTrafficLight createTileEntity(World world, IBlockState state) {
        return new TileEntityTrafficLight();
    }
}

