/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSignBase
extends BlockHorizontalFacing {
    public static final PropertyBool ONWALL = PropertyBool.func_177716_a((String)"onwall");
    public static final ArrayList<Block> signs = new ArrayList();
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB WEST_BLOCK_AABB = new AxisAlignedBB(0.0, 0.125, 0.125, 0.0625, 0.875, 0.875);
    private static final AxisAlignedBB EAST_BLOCK_AABB = new AxisAlignedBB(1.0, 0.125, 0.125, 0.9375, 0.875, 0.875);
    private static final AxisAlignedBB SOUTH_BLOCK_AABB = new AxisAlignedBB(0.125, 0.125, 0.9375, 0.875, 0.875, 1.0);
    private static final AxisAlignedBB NORTH_BLOCK_AABB = new AxisAlignedBB(0.125, 0.125, 0.0625, 0.875, 0.875, 0.0);

    public BlockSignBase(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
        signs.add(this);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ONWALL, (Comparable)Boolean.valueOf(false)));
    }

    public void changeSign(World world, BlockPos pos) {
        Block oldBlock = world.func_180495_p(pos).func_177230_c();
        IBlockState oldState = oldBlock.func_176221_a(world.func_180495_p(pos), (IBlockAccess)world, pos);
        int oldMeta = oldBlock.func_176201_c(oldState);
        EnumFacing oldFacing = EnumFacing.func_176731_b((int)oldMeta);
        boolean oldOnWall = (Boolean)oldState.func_177229_b((IProperty)ONWALL);
        int nextInt = signs.indexOf(oldBlock) + 1;
        if (nextInt > signs.size() - 1) {
            nextInt = 0;
        }
        Block nextBlock = signs.get(nextInt);
        world.func_175656_a(pos, nextBlock.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)oldFacing).func_177226_a((IProperty)ONWALL, (Comparable)Boolean.valueOf(oldOnWall)));
    }

    public Item func_180660_a(IBlockState state, Random par2Random, int par3) {
        return new ItemStack(Item.func_150898_a((Block)ModBlocks.signHV)).func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)ModBlocks.signHV));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)ONWALL, (Comparable)Boolean.valueOf(facing != EnumFacing.UP));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ONWALL});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)ONWALL, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ONWALL)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_185899_b(source, pos).func_177229_b((IProperty)ONWALL)).booleanValue()) {
            switch ((EnumFacing)state.func_185899_b(source, pos).func_177229_b((IProperty)FACING)) {
                default: {
                    return NORTH_BLOCK_AABB;
                }
                case SOUTH: {
                    return SOUTH_BLOCK_AABB;
                }
                case EAST: {
                    return EAST_BLOCK_AABB;
                }
                case WEST: 
            }
            return WEST_BLOCK_AABB;
        }
        return BASE_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"tile.industrialrenewal.sign_base.info", (Object[])new Object[0]));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

