/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.blocks.BlockBrace;
import cassiokf.industrialrenewal.blocks.BlockCatwalkLadder;
import cassiokf.industrialrenewal.blocks.BlockFireExtinguisher;
import cassiokf.industrialrenewal.blocks.BlockLight;
import cassiokf.industrialrenewal.blocks.BlockPillar;
import cassiokf.industrialrenewal.blocks.BlockSignBase;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorCable;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorLamp;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorPipe;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockIndustrialFloor;
import cassiokf.industrialrenewal.blocks.pipes.BlockCableTray;
import cassiokf.industrialrenewal.blocks.pipes.BlockFluidPipe;
import cassiokf.industrialrenewal.blocks.pipes.BlockHVConnectorBase;
import cassiokf.industrialrenewal.blocks.pipes.BlockPillarEnergyCable;
import cassiokf.industrialrenewal.blocks.pipes.BlockPillarFluidPipe;
import cassiokf.industrialrenewal.blocks.pipes.BlockPipeBase;
import cassiokf.industrialrenewal.blocks.redstone.BlockAlarm;
import cassiokf.industrialrenewal.util.enums.enumproperty.EnumBaseDirection;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockColumn
extends BlockBase {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyInteger PIPE = PropertyInteger.func_177719_a((String)"pipe", (int)0, (int)2);
    private static float NORTHZ1 = 0.25f;
    private static float SOUTHZ2 = 0.75f;
    private static float WESTX1 = 0.25f;
    private static float EASTX2 = 0.75f;
    private static float DOWNY1 = 0.3125f;
    private static final float UPY2 = 1.0f;

    public BlockColumn(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, PIPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected boolean isValidConnection(IBlockState neighbourState, IBlockState ownState, IBlockAccess world, BlockPos ownPos, EnumFacing neighbourDirection) {
        Block nb = neighbourState.func_177230_c();
        if ((nb.func_149686_d(neighbourState) || nb instanceof BlockIndustrialFloor || nb instanceof BlockFloorLamp || nb instanceof BlockFloorPipe || nb instanceof BlockFloorCable) && neighbourDirection != EnumFacing.UP && neighbourDirection != EnumFacing.DOWN) {
            Block oppositBlock = world.func_180495_p(ownPos.func_177972_a(neighbourDirection.func_176734_d())).func_177230_c();
            return oppositBlock instanceof BlockColumn || oppositBlock instanceof BlockPillar;
        }
        if (neighbourDirection != EnumFacing.UP && neighbourDirection != EnumFacing.DOWN) {
            if (nb instanceof BlockBrace) {
                return Objects.equals(((BlockBrace.EnumOrientation)((Object)neighbourState.func_177229_b(BlockBrace.FACING))).func_176610_l(), neighbourDirection.func_176734_d().func_176610_l()) || Objects.equals(((BlockBrace.EnumOrientation)((Object)neighbourState.func_177229_b(BlockBrace.FACING))).func_176610_l(), "down_" + neighbourDirection.func_176610_l());
            }
            return nb instanceof BlockColumn || nb instanceof BlockPillar || nb instanceof BlockHVConnectorBase && neighbourState.func_177229_b((IProperty)BlockHVConnectorBase.FACING) == neighbourDirection.func_176734_d() || nb instanceof BlockPillarEnergyCable || nb instanceof BlockPillarFluidPipe || nb instanceof BlockAlarm && neighbourState.func_177229_b(BlockAlarm.FACING) == neighbourDirection || nb instanceof BlockLight && neighbourState.func_177229_b((IProperty)BlockLight.FACING) == neighbourDirection.func_176734_d();
        }
        if (nb instanceof BlockLight) {
            return neighbourState.func_177229_b((IProperty)BlockLight.FACING) == EnumFacing.UP;
        }
        if (nb instanceof BlockBrace) {
            return Arrays.toString(EnumFacing.field_176754_o).contains(((BlockBrace.EnumOrientation)((Object)neighbourState.func_177229_b(BlockBrace.FACING))).toString());
        }
        if (nb instanceof BlockFluidPipe) {
            return (Integer)ownState.func_177229_b((IProperty)PIPE) > 0;
        }
        if (nb instanceof BlockCableTray) {
            return ((EnumBaseDirection)((Object)neighbourState.func_177229_b(BlockCableTray.BASE))).equals((Object)EnumBaseDirection.UP);
        }
        return !(nb instanceof BlockCatwalkLadder) && !(nb instanceof BlockSignBase) && !(nb instanceof BlockFireExtinguisher) && (!(nb instanceof BlockAlarm) || neighbourState.func_177229_b(BlockAlarm.FACING) == neighbourDirection) && !nb.isAir(neighbourState, world, ownPos.func_177972_a(neighbourDirection));
    }

    private boolean canConnectTo(IBlockState ownState, IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        Block neighbourBlock = neighbourState.func_177230_c();
        boolean neighbourIsValidForThis = this.isValidConnection(neighbourState, ownState, worldIn, ownPos, neighbourDirection);
        boolean thisIsValidForNeighbour = !(neighbourBlock instanceof BlockColumn) || ((BlockColumn)neighbourBlock).isValidConnection(ownState, neighbourState, worldIn, neighbourPos, neighbourDirection.func_176734_d());
        return neighbourIsValidForThis && thisIsValidForNeighbour;
    }

    private int canConnectPipe(IBlockAccess world, BlockPos pos) {
        IBlockState stateOffset = world.func_180495_p(pos.func_177977_b());
        if (stateOffset.func_177230_c() instanceof BlockPipeBase && !(stateOffset.func_177230_c() instanceof BlockCableTray)) {
            if (this.pipeConnected(world, pos.func_177977_b(), stateOffset, EnumFacing.DOWN)) {
                return 0;
            }
            if (!this.pipeConnected(world, pos.func_177977_b(), stateOffset, EnumFacing.NORTH) && !this.pipeConnected(world, pos.func_177977_b(), stateOffset, EnumFacing.SOUTH)) {
                return 2;
            }
            if (!this.pipeConnected(world, pos.func_177977_b(), stateOffset, EnumFacing.EAST) && !this.pipeConnected(world, pos.func_177977_b(), stateOffset, EnumFacing.WEST)) {
                return 1;
            }
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)PIPE, (Comparable)Integer.valueOf(this.canConnectPipe(world, pos)));
        state = state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.DOWN))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.EAST))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.WEST)));
        return state;
    }

    private boolean pipeConnected(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing facing) {
        Block blockOffset = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return blockOffset.equals(state.func_177230_c());
    }

    public final boolean isConnected(IBlockState state, EnumFacing facing) {
        if (facing == EnumFacing.UP) {
            return (Boolean)state.func_177229_b((IProperty)UP);
        }
        if (facing == EnumFacing.DOWN) {
            return (Boolean)state.func_177229_b((IProperty)DOWN);
        }
        if (facing == EnumFacing.NORTH) {
            return (Boolean)state.func_177229_b((IProperty)NORTH);
        }
        if (facing == EnumFacing.SOUTH) {
            return (Boolean)state.func_177229_b((IProperty)SOUTH);
        }
        if (facing == EnumFacing.EAST) {
            return (Boolean)state.func_177229_b((IProperty)EAST);
        }
        return (Boolean)state.func_177229_b((IProperty)WEST);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        if (this.isConnected(state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected(state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.25f;
        }
        if (this.isConnected(state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected(state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.75f;
        }
        if (this.isConnected(state, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected(state, EnumFacing.WEST)) {
            WESTX1 = 0.25f;
        }
        if (this.isConnected(state, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected(state, EnumFacing.EAST)) {
            EASTX2 = 0.75f;
        }
        if (this.isConnected(state, EnumFacing.DOWN)) {
            DOWNY1 = 0.0f;
        } else if (!this.isConnected(state, EnumFacing.DOWN)) {
            DOWNY1 = 0.3125f;
        }
        AxisAlignedBB AA_BB = new AxisAlignedBB((double)WESTX1, (double)DOWNY1, (double)NORTHZ1, (double)EASTX2, 1.0, (double)SOUTHZ2);
        BlockColumn.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AA_BB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(source, pos);
        if (this.isConnected(actualState, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected(actualState, EnumFacing.NORTH)) {
            NORTHZ1 = 0.25f;
        }
        if (this.isConnected(actualState, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected(actualState, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.75f;
        }
        if (this.isConnected(actualState, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected(actualState, EnumFacing.WEST)) {
            WESTX1 = 0.25f;
        }
        if (this.isConnected(actualState, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected(actualState, EnumFacing.EAST)) {
            EASTX2 = 0.75f;
        }
        if (this.isConnected(actualState, EnumFacing.DOWN)) {
            DOWNY1 = 0.0f;
        } else if (!this.isConnected(actualState, EnumFacing.DOWN)) {
            DOWNY1 = 0.3125f;
        }
        return new AxisAlignedBB((double)WESTX1, (double)DOWNY1, (double)NORTHZ1, (double)EASTX2, 1.0, (double)SOUTHZ2);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

