/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal;

import cassiokf.industrialrenewal.handlers.ChunkManagerCallback;
import cassiokf.industrialrenewal.handlers.EventHandler;
import cassiokf.industrialrenewal.init.EntityInit;
import cassiokf.industrialrenewal.init.FluidInit;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.init.NetworkHandler;
import cassiokf.industrialrenewal.proxy.CommonProxy;
import cassiokf.industrialrenewal.recipes.ModRecipes;
import cassiokf.industrialrenewal.world.generation.OreGeneration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="industrialrenewal", name="Industrial Renewal", version="0.21.8", guiFactory="cassiokf.industrialrenewal.config.IRConfigGuiFactory", updateJSON="https://raw.githubusercontent.com/Cassiobsk8/Industrial_Renewal/master/update.json", acceptedMinecraftVersions="[1.12.2]")
public class IndustrialRenewal {
    @Mod.Instance(value="industrialrenewal")
    public static IndustrialRenewal instance;
    @SidedProxy(clientSide="cassiokf.industrialrenewal.proxy.ClientProxy", serverSide="cassiokf.industrialrenewal.proxy.CommonProxy", modId="industrialrenewal")
    public static CommonProxy proxy;
    public static Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        LOGGER.info("Industrial Renewal is loading preInit!");
        FluidInit.registerFluids();
        IRSoundRegister.registerSounds();
        EntityInit.registerEntities();
        proxy.preInit();
        NetworkHandler.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGeneration(), (int)4);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new ChunkManagerCallback());
        proxy.registerRenderers();
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        LOGGER.info("Done!");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("Industrial Renewal is loading init!");
        ModRecipes.init();
        proxy.Init();
        LOGGER.info("Done!");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LOGGER.info("Industrial Renewal is loading posInit!");
        OreGeneration.init();
        LOGGER.info("Done!");
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ModItems.register((IForgeRegistry<Item>)event.getRegistry());
            ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
            ModItems.registerOreDict();
            ModBlocks.registerOreDict();
        }

        @SubscribeEvent
        public static void registerItems(ModelRegistryEvent event) {
            ModItems.registerModels();
            ModBlocks.registerItemModels();
        }

        @SubscribeEvent
        public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("industrialrenewal")) {
                ConfigManager.sync((String)"industrialrenewal", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

