/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.vec;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.collision.IntersectionHelperSolid;
import com.creativemd.creativecore.common.utils.math.geo.NormalPlane;
import com.creativemd.creativecore.common.utils.math.geo.Ray2d;
import com.creativemd.creativecore.common.utils.math.geo.Ray3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VectorFan {
    public static final float EPSILON = 1.0E-4f;
    protected Vector3f[] coords;

    public VectorFan(Vector3f[] coords) {
        this.coords = coords;
    }

    public Vector3f[] getCoords() {
        return this.coords;
    }

    public Vector3f get(int index) {
        return this.coords[index];
    }

    public int count() {
        return this.coords.length;
    }

    protected Vector3f[] cutMinMax(EnumFacing.Axis one, EnumFacing.Axis two, EnumFacing.Axis axis, float minOne, float minTwo, float maxOne, float maxTwo) {
        boolean allTheSame = true;
        boolean allValue = false;
        boolean[] inside = new boolean[this.coords.length];
        for (int i = 0; i < inside.length; ++i) {
            float valueOne = VectorUtils.get(one, (Tuple3f)this.coords[i]);
            float valueTwo = VectorUtils.get(two, (Tuple3f)this.coords[i]);
            boolean bl = inside[i] = valueOne >= minOne && valueOne <= maxOne && valueTwo >= minTwo && valueTwo <= maxTwo;
            if (!allTheSame) continue;
            if (i == 0) {
                allValue = inside[i];
                continue;
            }
            if (allValue == inside[i]) continue;
            allTheSame = false;
        }
        if (allTheSame && allValue) {
            return this.coords;
        }
        List<Vector2f> shape = IntersectionHelperSolid.cutMinMax(one, two, minOne, minTwo, maxOne, maxTwo, this.coords);
        if (shape == null) {
            return null;
        }
        NormalPlane plane = this.createPlane();
        Vector3f[] result = new Vector3f[shape.size()];
        for (int i = 0; i < result.length; ++i) {
            Vector3f vec = new Vector3f();
            Vector2f vec2d = shape.get(i);
            VectorUtils.set((Tuple3f)vec, vec2d.x, one);
            VectorUtils.set((Tuple3f)vec, vec2d.y, two);
            VectorUtils.set((Tuple3f)vec, plane.project(one, two, axis, vec2d.x, vec2d.y).floatValue(), axis);
            result[i] = vec;
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void generate(RenderBox.RenderInformationHolder holder, List<BakedQuad> quads) {
        int index;
        holder.normal = null;
        Vector3f[] coords = this.coords;
        if (!holder.getBox().allowOverlap && holder.hasBounds()) {
            float offsetTwo;
            float offsetOne;
            float scaleTwo;
            float scaleOne;
            EnumFacing.Axis one = RotationUtils.getOne(holder.facing.func_176740_k());
            EnumFacing.Axis two = RotationUtils.getTwo(holder.facing.func_176740_k());
            if (holder.scaleAndOffset) {
                scaleOne = 1.0f / VectorUtils.get(one, holder.scaleX, holder.scaleY, holder.scaleZ);
                scaleTwo = 1.0f / VectorUtils.get(two, holder.scaleX, holder.scaleY, holder.scaleZ);
                offsetOne = VectorUtils.get(one, holder.offsetX, holder.offsetY, holder.offsetZ);
                offsetTwo = VectorUtils.get(two, holder.offsetX, holder.offsetY, holder.offsetZ);
            } else {
                scaleOne = 1.0f;
                scaleTwo = 1.0f;
                offsetOne = 0.0f;
                offsetTwo = 0.0f;
            }
            float minOne = VectorUtils.get(one, holder.minX, holder.minY, holder.minZ) * scaleOne - offsetOne;
            float minTwo = VectorUtils.get(two, holder.minX, holder.minY, holder.minZ) * scaleTwo - offsetTwo;
            float maxOne = VectorUtils.get(one, holder.maxX, holder.maxY, holder.maxZ) * scaleOne - offsetOne;
            float maxTwo = VectorUtils.get(two, holder.maxX, holder.maxY, holder.maxZ) * scaleTwo - offsetTwo;
            coords = this.cutMinMax(one, two, holder.facing.func_176740_k(), minOne, minTwo, maxOne, maxTwo);
        }
        if (coords == null) {
            return;
        }
        for (index = 0; index < coords.length - 3; index += 2) {
            this.generate(holder, coords[0], coords[index + 1], coords[index + 2], coords[index + 3], quads);
        }
        if (index < coords.length - 2) {
            this.generate(holder, coords[0], coords[index + 1], coords[index + 2], coords[index + 2], quads);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void generate(RenderBox.RenderInformationHolder holder, Vector3f vec1, Vector3f vec2, Vector3f vec3, Vector3f vec4, List<BakedQuad> quads) {
        CreativeBakedQuad quad = new CreativeBakedQuad(holder.quad, holder.getBox(), holder.color, holder.shouldOverrideColor, holder.facing);
        RenderBox box = holder.getBox();
        for (int k = 0; k < 4; ++k) {
            float vOffset;
            float uOffset;
            float z;
            float y;
            float x;
            Vector3f vec = k == 0 ? vec1 : (k == 1 ? vec2 : (k == 2 ? vec3 : vec4));
            int index = k * quad.getFormat().func_181719_f();
            if (holder.scaleAndOffset) {
                x = vec.x * holder.scaleX + holder.offsetX - (float)holder.offset.func_177958_n();
                y = vec.y * holder.scaleY + holder.offsetY - (float)holder.offset.func_177956_o();
                z = vec.z * holder.scaleZ + holder.offsetZ - (float)holder.offset.func_177952_p();
            } else {
                x = vec.x - (float)holder.offset.func_177958_n();
                y = vec.y - (float)holder.offset.func_177956_o();
                z = vec.z - (float)holder.offset.func_177952_p();
            }
            if (this.doMinMaxLate() && !box.allowOverlap) {
                if (holder.facing.func_176740_k() != EnumFacing.Axis.X) {
                    x = MathHelper.func_76131_a((float)x, (float)holder.minX, (float)holder.maxX);
                }
                if (holder.facing.func_176740_k() != EnumFacing.Axis.Y) {
                    y = MathHelper.func_76131_a((float)y, (float)holder.minY, (float)holder.maxY);
                }
                if (holder.facing.func_176740_k() != EnumFacing.Axis.Z) {
                    z = MathHelper.func_76131_a((float)z, (float)holder.minZ, (float)holder.maxZ);
                }
            }
            float oldX = Float.intBitsToFloat(quad.func_178209_a()[index]);
            float oldY = Float.intBitsToFloat(quad.func_178209_a()[index + 1]);
            float oldZ = Float.intBitsToFloat(quad.func_178209_a()[index + 2]);
            quad.func_178209_a()[index] = Float.floatToIntBits(x + (float)holder.offset.func_177958_n());
            quad.func_178209_a()[index + 1] = Float.floatToIntBits(y + (float)holder.offset.func_177956_o());
            quad.func_178209_a()[index + 2] = Float.floatToIntBits(z + (float)holder.offset.func_177952_p());
            if (box.keepVU) continue;
            int uvIndex = index + quad.getFormat().func_177344_b(0) / 4;
            if (holder.uvInverted) {
                uOffset = (RotationUtils.getVFromFacing(holder.facing, oldX, oldY, oldZ) - RotationUtils.getVFromFacing(holder.facing, x, y, z)) / RotationUtils.getVFromFacing(holder.facing, holder.sizeX, holder.sizeY, holder.sizeZ) * holder.sizeU;
                vOffset = (RotationUtils.getUFromFacing(holder.facing, oldX, oldY, oldZ) - RotationUtils.getUFromFacing(holder.facing, x, y, z)) / RotationUtils.getUFromFacing(holder.facing, holder.sizeX, holder.sizeY, holder.sizeZ) * holder.sizeV;
            } else {
                uOffset = (RotationUtils.getUFromFacing(holder.facing, oldX, oldY, oldZ) - RotationUtils.getUFromFacing(holder.facing, x, y, z)) / RotationUtils.getUFromFacing(holder.facing, holder.sizeX, holder.sizeY, holder.sizeZ) * holder.sizeU;
                vOffset = (RotationUtils.getVFromFacing(holder.facing, oldX, oldY, oldZ) - RotationUtils.getVFromFacing(holder.facing, x, y, z)) / RotationUtils.getVFromFacing(holder.facing, holder.sizeX, holder.sizeY, holder.sizeZ) * holder.sizeV;
            }
            quad.func_178209_a()[uvIndex] = Float.floatToIntBits(Float.intBitsToFloat(quad.func_178209_a()[uvIndex]) - uOffset);
            quad.func_178209_a()[uvIndex + 1] = Float.floatToIntBits(Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]) - vOffset);
        }
        quads.add(quad);
    }

    protected boolean doMinMaxLate() {
        return false;
    }

    public void renderPreview(int red, int green, int blue, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < this.coords.length; ++i) {
            Vector3f vec = this.coords[i];
            bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public void renderPreview(float offX, float offY, float offZ, float scaleX, float scaleY, float scaleZ, int red, int green, int blue, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < this.coords.length; ++i) {
            Vector3f vec = this.coords[i];
            bufferbuilder.func_181662_b((double)(vec.x * scaleX + offX), (double)(vec.y * scaleY + offY), (double)(vec.z * scaleZ + offZ)).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public void renderLines(int red, int green, int blue, int alpha) {
        Vector3f vec;
        int i;
        int index;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (index = 0; index < this.coords.length - 3; index += 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 4; ++i) {
                vec = this.coords[i];
                bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181669_b(red, green, blue, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        if (index < this.coords.length - 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 3; ++i) {
                vec = this.coords[i];
                bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181669_b(red, green, blue, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
        }
    }

    public void renderLines(float offX, float offY, float offZ, float scaleX, float scaleY, float scaleZ, int red, int green, int blue, int alpha) {
        Vector3f vec;
        int i;
        int index;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (index = 0; index < this.coords.length - 3; index += 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 4; ++i) {
                vec = this.coords[i];
                bufferbuilder.func_181662_b((double)(vec.x * scaleX + offX), (double)(vec.y * scaleY + offY), (double)(vec.z * scaleZ + offZ)).func_181669_b(red, green, blue, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        if (index < this.coords.length - 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 3; ++i) {
                vec = this.coords[i];
                bufferbuilder.func_181662_b((double)(vec.x * scaleX + offX), (double)(vec.y * scaleY + offY), (double)(vec.z * scaleZ + offZ)).func_181669_b(red, green, blue, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
        }
    }

    public void renderLines(float offX, float offY, float offZ, float scaleX, float scaleY, float scaleZ, int red, int green, int blue, int alpha, Vector3d center, double grow) {
        int i;
        int index;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (index = 0; index < this.coords.length - 3; index += 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 4; ++i) {
                this.renderLinePoint(bufferbuilder, this.coords[i], offX, offY, offZ, scaleX, scaleY, scaleZ, red, green, blue, alpha, center, grow);
            }
            tessellator.func_78381_a();
        }
        if (index < this.coords.length - 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 3; ++i) {
                this.renderLinePoint(bufferbuilder, this.coords[i], offX, offY, offZ, scaleX, scaleY, scaleZ, red, green, blue, alpha, center, grow);
            }
            tessellator.func_78381_a();
        }
    }

    protected void renderLinePoint(BufferBuilder bufferbuilder, Vector3f vec, float offX, float offY, float offZ, float scaleX, float scaleY, float scaleZ, int red, int green, int blue, int alpha, Vector3d center, double grow) {
        float x = vec.x * scaleX + offX;
        x = (double)x > center.x ? (float)((double)x + grow) : (float)((double)x - grow);
        float y = vec.y * scaleY + offY;
        y = (double)y > center.y ? (float)((double)y + grow) : (float)((double)y - grow);
        float z = vec.z * scaleZ + offZ;
        z = (double)z > center.z ? (float)((double)z + grow) : (float)((double)z - grow);
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_181669_b(red, green, blue, alpha).func_181675_d();
    }

    protected void renderLinePoint(BufferBuilder bufferbuilder, Vector3f vec, int red, int green, int blue, int alpha, Vector3d center, double grow) {
        float x = vec.x;
        x = (double)x > center.x ? (float)((double)x + grow) : (float)((double)x - grow);
        float y = vec.y;
        y = (double)y > center.y ? (float)((double)y + grow) : (float)((double)y - grow);
        float z = vec.z;
        z = (double)z > center.z ? (float)((double)z + grow) : (float)((double)z - grow);
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_181669_b(red, green, blue, alpha).func_181675_d();
    }

    public void renderLines(int red, int green, int blue, int alpha, Vector3d center, double grow) {
        int i;
        int index;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (index = 0; index < this.coords.length - 3; index += 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 4; ++i) {
                this.renderLinePoint(bufferbuilder, this.coords[i], red, green, blue, alpha, center, grow);
            }
            tessellator.func_78381_a();
        }
        if (index < this.coords.length - 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 3; ++i) {
                this.renderLinePoint(bufferbuilder, this.coords[i], red, green, blue, alpha, center, grow);
            }
            tessellator.func_78381_a();
        }
    }

    private static boolean isPointBetween(Vector3f start, Vector3f end, Vector3f between) {
        float x = (end.y - start.y) * (between.z - start.z) - (end.z - start.z) * (between.y - start.y);
        float y = (between.x - start.x) * (end.z - start.z) - (between.z - start.z) * (end.x - start.x);
        float z = (end.x - start.x) * (between.y - start.y) - (end.y - start.y) * (between.x - start.x);
        float test = Math.abs(x) + Math.abs(y) + Math.abs(z);
        return Math.abs(test) < 1.0E-4f;
    }

    public void add(List<Vector3f> list, Vector3f toAdd) {
        if (!list.isEmpty() && list.get(list.size() - 1).equals((Tuple3f)toAdd)) {
            return;
        }
        if (list.size() > 1 && VectorFan.isPointBetween(list.get(list.size() - 2), toAdd, list.get(list.size() - 1))) {
            list.set(list.size() - 1, toAdd);
        } else {
            list.add(toAdd);
        }
    }

    public void set(VectorFan fan) {
        this.set(fan.coords);
    }

    public void set(Vector3f[] coords) {
        this.coords = new Vector3f[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            this.coords[i] = coords[i];
        }
    }

    public boolean cutWithoutCopy(NormalPlane[] planes) {
        for (int i = 0; i < planes.length; ++i) {
            this.cutWithoutCopy(planes[i]);
            if (!this.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void cutWithoutCopy(NormalPlane plane) {
        this.cutInternal(plane, false);
    }

    public boolean isEmpty() {
        return this.coords == null;
    }

    protected VectorFan cutInternal(NormalPlane plane, boolean copy) {
        boolean allTheSame = true;
        Boolean allValue = null;
        Boolean[] cutted = new Boolean[this.coords.length];
        for (int i = 0; i < cutted.length; ++i) {
            cutted[i] = plane.isInFront(this.coords[i]);
            if (cutted[i] != null) {
                cutted[i] = cutted[i] == false;
            }
            if (!allTheSame) continue;
            if (i == 0) {
                allValue = cutted[i];
                continue;
            }
            if (allValue == null) {
                allValue = cutted[i];
                continue;
            }
            if (allValue == cutted[i] || cutted[i] == null) continue;
            allTheSame = false;
        }
        if (allTheSame) {
            if (allValue == null) {
                if (!copy) {
                    this.coords = null;
                }
                return null;
            }
            if (allValue.booleanValue()) {
                return this;
            }
            if (!copy) {
                this.coords = null;
            }
            return null;
        }
        ArrayList<Vector3f> right = new ArrayList<Vector3f>();
        Boolean beforeCutted = cutted[cutted.length - 1];
        Vector3f beforeVec = this.coords[this.coords.length - 1];
        for (int i = 0; i < this.coords.length; ++i) {
            Vector3f intersection;
            Vector3f vec = this.coords[i];
            if (BooleanUtils.isTrue(cutted[i])) {
                if (BooleanUtils.isFalse(beforeCutted) && (intersection = plane.intersect(vec, beforeVec)) != null) {
                    right.add(intersection);
                }
                right.add(vec);
            } else if (BooleanUtils.isFalse(cutted[i])) {
                if (BooleanUtils.isTrue(beforeCutted) && (intersection = plane.intersect(vec, beforeVec)) != null) {
                    right.add(intersection);
                }
            } else {
                right.add(vec);
            }
            beforeCutted = cutted[i];
            beforeVec = vec;
        }
        if (VectorFan.isPointBetween((Vector3f)right.get(right.size() - 2), (Vector3f)right.get(0), (Vector3f)right.get(right.size() - 1))) {
            right.remove(right.size() - 1);
        }
        if (right.size() >= 3 && VectorFan.isPointBetween((Vector3f)right.get(right.size() - 1), (Vector3f)right.get(1), (Vector3f)right.get(0))) {
            right.remove(0);
        }
        if (right.size() < 3) {
            if (!copy) {
                this.coords = null;
            }
            return null;
        }
        if (copy) {
            return new VectorFan(right.toArray(new Vector3f[right.size()]));
        }
        if (right != null) {
            this.coords = right.toArray(new Vector3f[right.size()]);
        }
        return null;
    }

    public VectorFan cut(NormalPlane plane) {
        return this.cutInternal(plane, true);
    }

    public void move(float x, float y, float z) {
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i].x += x;
            this.coords[i].y += y;
            this.coords[i].z += z;
        }
    }

    public void scale(float ratio) {
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i].scale(ratio);
        }
    }

    public void divide(float ratio) {
        this.scale(1.0f / ratio);
    }

    public boolean intersects(NormalPlane plane1, NormalPlane plane2) {
        Boolean beforeOne = null;
        Boolean beforeTwo = null;
        Vector3f before = null;
        for (int i = 0; i <= this.coords.length; ++i) {
            Vector3f intersection;
            Vector3f vec = i == this.coords.length ? this.coords[0] : this.coords[i];
            Boolean one = plane1.isInFront(vec);
            Boolean two = plane2.isInFront(vec);
            if (BooleanUtils.isTrue(one) && BooleanUtils.isTrue(two)) {
                return true;
            }
            if (i > 0 && BooleanUtils.isTrue(one) != BooleanUtils.isTrue(beforeOne) && BooleanUtils.isTrue(two) != BooleanUtils.isTrue(beforeTwo) && (intersection = plane1.intersect(before, vec)) != null && BooleanUtils.isTrue(plane2.isInFront(intersection))) {
                return true;
            }
            before = vec;
            beforeOne = one;
            beforeTwo = two;
        }
        return false;
    }

    public VectorFan copy() {
        Vector3f[] coordsCopy = new Vector3f[this.coords.length];
        for (int i = 0; i < coordsCopy.length; ++i) {
            coordsCopy[i] = new Vector3f(this.coords[i]);
        }
        return new VectorFan(coordsCopy);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VectorFan) {
            int start;
            VectorFan other = (VectorFan)obj;
            if (this.coords.length != other.coords.length) {
                return false;
            }
            for (start = 0; start < this.coords.length && !this.coords[start].equals((Tuple3f)other.coords[0]); ++start) {
            }
            if (start < this.coords.length) {
                for (int i = 1; i < other.coords.length; ++i) {
                    if (this.coords[start = (start + 1) % this.coords.length].equals((Tuple3f)other.coords[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean equals(Vector3f vec, Vector3f other, EnumFacing.Axis one, EnumFacing.Axis two) {
        float diff = VectorUtils.get(one, (Tuple3f)vec) - VectorUtils.get(one, (Tuple3f)other);
        if (Float.isNaN(diff)) {
            return false;
        }
        float f = diff < 0.0f ? -diff : diff;
        if (f > 1.0E-4f) {
            return false;
        }
        diff = VectorUtils.get(two, (Tuple3f)vec) - VectorUtils.get(two, (Tuple3f)other);
        if (Float.isNaN(diff)) {
            return false;
        }
        float f2 = diff < 0.0f ? -diff : diff;
        return !(f2 > 1.0E-4f);
    }

    public boolean equalsIgnoreOrder(VectorFan other, EnumFacing.Axis toIgnore) {
        if (this.coords.length != other.coords.length) {
            return false;
        }
        EnumFacing.Axis one = RotationUtils.getOne(toIgnore);
        EnumFacing.Axis two = RotationUtils.getTwo(toIgnore);
        for (int i = 0; i < this.coords.length; ++i) {
            boolean found = false;
            for (int j = 0; j < other.coords.length; ++j) {
                if (!VectorFan.equals(this.coords[i], other.coords[j], one, two)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    protected static Vec3d calculateIntercept(Ray3f ray, Vector3f triangle0, Vector3f triangle1, Vector3f triangle2) throws ParallelException {
        Vector3f edge1 = new Vector3f();
        Vector3f edge2 = new Vector3f();
        Vector3f h = new Vector3f();
        Vector3f s = new Vector3f();
        Vector3f q = new Vector3f();
        edge1.sub((Tuple3f)triangle1, (Tuple3f)triangle0);
        edge2.sub((Tuple3f)triangle2, (Tuple3f)triangle0);
        h.cross(ray.direction, edge2);
        double a = edge1.dot(h);
        if (a > (double)-1.0E-4f && a < (double)1.0E-4f) {
            throw new ParallelException();
        }
        double f = 1.0 / a;
        s.sub((Tuple3f)ray.origin, (Tuple3f)triangle0);
        double u = f * (double)s.dot(h);
        if (u < 0.0 || u > 1.0) {
            return null;
        }
        q.cross(s, edge1);
        double v = f * (double)ray.direction.dot(q);
        if (v < 0.0 || u + v > 1.0) {
            return null;
        }
        double t = f * (double)edge2.dot(q);
        return new Vec3d((double)ray.direction.x * t + (double)ray.origin.x, (double)ray.direction.y * t + (double)ray.origin.y, (double)ray.direction.z * t + (double)ray.origin.z);
    }

    public Vec3d calculateIntercept(Ray3f ray) {
        try {
            Vector3f origin = this.coords[0];
            for (int i = 0; i < this.coords.length - 2; ++i) {
                Vec3d result = VectorFan.calculateIntercept(ray, this.coords[0], this.coords[i + 1], this.coords[i + 2]);
                if (result == null) continue;
                return result;
            }
        }
        catch (ParallelException parallelException) {
            // empty catch block
        }
        return null;
    }

    public NormalPlane createPlane() {
        Vector3f a = new Vector3f(this.coords[1]);
        a.sub((Tuple3f)this.coords[0]);
        Vector3f b = new Vector3f(this.coords[2]);
        b.sub((Tuple3f)this.coords[0]);
        Vector3f normal = new Vector3f();
        normal.cross(a, b);
        return new NormalPlane(this.coords[0], normal);
    }

    public NormalPlane createPlane(RenderBox.RenderInformationHolder holder) {
        Vector3f a = new Vector3f(this.coords[1]);
        a.sub((Tuple3f)this.coords[0]);
        if (holder.scaleAndOffset) {
            a.x *= holder.scaleX;
            a.y *= holder.scaleY;
            a.z *= holder.scaleZ;
        }
        Vector3f b = new Vector3f(this.coords[2]);
        b.sub((Tuple3f)this.coords[0]);
        if (holder.scaleAndOffset) {
            b.x *= holder.scaleX;
            b.y *= holder.scaleY;
            b.z *= holder.scaleZ;
        }
        Vector3f normal = new Vector3f();
        normal.cross(a, b);
        Vector3f origin = new Vector3f();
        if (holder.scaleAndOffset) {
            origin.x *= holder.scaleX;
            origin.x += holder.offsetX;
            origin.y *= holder.scaleY;
            origin.y += holder.offsetY;
            origin.z *= holder.scaleZ;
            origin.z += holder.offsetZ;
        }
        return new NormalPlane(origin, normal);
    }

    public boolean isInside(List<List<NormalPlane>> shapes) {
        for (int j = 0; j < shapes.size(); ++j) {
            List<NormalPlane> shape = shapes.get(j);
            Boolean[] firstOutside = null;
            Boolean[] beforeOutside = null;
            Vector3f before = null;
            for (int i = 0; i <= this.coords.length; ++i) {
                int k;
                Vector3f vec = i == this.coords.length ? this.coords[0] : this.coords[i];
                Boolean[] outside = new Boolean[shape.size()];
                boolean inside = true;
                for (k = 0; k < shape.size(); ++k) {
                    Boolean front = shape.get(k).isInFront(vec);
                    if (!BooleanUtils.isFalse(front)) {
                        inside = false;
                    }
                    outside[k] = front;
                }
                if (inside) {
                    return true;
                }
                if (i > 0) {
                    for (k = 0; k < shape.size(); ++k) {
                        if (!VectorFan.isInside(shape, before, vec, beforeOutside[k], outside[k], k)) continue;
                        return true;
                    }
                    if (i < this.coords.length - 1 && i % 2 == 0) {
                        for (k = 0; k < shape.size(); ++k) {
                            if (!VectorFan.isInside(shape, this.coords[0], vec, firstOutside[k], outside[k], k)) continue;
                            return true;
                        }
                    }
                } else {
                    firstOutside = outside;
                }
                before = vec;
                beforeOutside = outside;
            }
        }
        return false;
    }

    public boolean intersect2d(VectorFan other, EnumFacing.Axis one, EnumFacing.Axis two, boolean inverse) {
        if (this.equals(other)) {
            return true;
        }
        int parrallel = 0;
        Vector3f before1 = this.coords[0];
        Ray2d ray1 = new Ray2d(one, two, 0.0, 0.0, 0.0, 0.0);
        for (int i = 1; i <= this.coords.length; ++i) {
            Vector3f vec1 = i == this.coords.length ? this.coords[0] : this.coords[i];
            ray1.originOne = VectorUtils.get(one, (Tuple3f)before1);
            ray1.originTwo = VectorUtils.get(two, (Tuple3f)before1);
            ray1.directionOne = VectorUtils.get(one, (Tuple3f)vec1) - VectorUtils.get(one, (Tuple3f)before1);
            ray1.directionTwo = VectorUtils.get(two, (Tuple3f)vec1) - VectorUtils.get(two, (Tuple3f)before1);
            boolean edge = false;
            Vector3f before2 = other.coords[0];
            Ray2d ray2 = new Ray2d(one, two, 0.0, 0.0, 0.0, 0.0);
            for (int i2 = 1; i2 <= other.coords.length; ++i2) {
                Vector3f vec2;
                block6: {
                    vec2 = i2 == other.coords.length ? other.coords[0] : other.coords[i2];
                    ray2.originOne = VectorUtils.get(one, (Tuple3f)before2);
                    ray2.originTwo = VectorUtils.get(two, (Tuple3f)before2);
                    ray2.directionOne = VectorUtils.get(one, (Tuple3f)vec2) - VectorUtils.get(one, (Tuple3f)before2);
                    ray2.directionTwo = VectorUtils.get(two, (Tuple3f)vec2) - VectorUtils.get(two, (Tuple3f)before2);
                    try {
                        double t = ray1.intersectWhen(ray2);
                        double otherT = ray2.intersectWhen(ray1);
                        if (t > (double)1.0E-4f && t < (double)0.9999f && otherT > (double)1.0E-4f && otherT < (double)0.9999f) {
                            return true;
                        }
                    }
                    catch (ParallelException e) {
                        double startT = ray1.getT(one, ray2.originOne);
                        double endT = ray1.getT(one, ray2.originOne + ray2.directionOne);
                        if (!(startT > (double)1.0E-4f && startT < (double)0.9999f) && (!(endT > (double)1.0E-4f) || !(endT < (double)0.9999f)) || ++parrallel <= 1) break block6;
                        return true;
                    }
                }
                before2 = vec2;
            }
            before1 = vec1;
        }
        return this.isInside2d(one, two, other, inverse) || other.isInside2d(one, two, this, inverse);
    }

    private boolean isInside2d(EnumFacing.Axis one, EnumFacing.Axis two, VectorFan other, boolean inverse) {
        Ray2d temp = new Ray2d(one, two, 0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < other.coords.length; ++i) {
            float pointOne = VectorUtils.get(one, (Tuple3f)other.coords[i]);
            float pointTwo = VectorUtils.get(two, (Tuple3f)other.coords[i]);
            boolean inside = false;
            for (int index = 0; index < this.coords.length - 2; ++index) {
                float firstOne = VectorUtils.get(one, (Tuple3f)this.coords[0]);
                float firstTwo = VectorUtils.get(two, (Tuple3f)this.coords[0]);
                float secondOne = VectorUtils.get(one, (Tuple3f)this.coords[index + 1]);
                float secondTwo = VectorUtils.get(two, (Tuple3f)this.coords[index + 1]);
                float thirdOne = VectorUtils.get(one, (Tuple3f)this.coords[index + 2]);
                float thirdTwo = VectorUtils.get(two, (Tuple3f)this.coords[index + 2]);
                temp.set(one, two, firstOne, firstTwo, secondOne, secondTwo);
                Boolean result = temp.isCoordinateToTheRight(pointOne, pointTwo);
                if (result != null && BooleanUtils.isFalse(result) != inverse) continue;
                temp.set(one, two, secondOne, secondTwo, thirdOne, thirdTwo);
                result = temp.isCoordinateToTheRight(pointOne, pointTwo);
                if (result != null && BooleanUtils.isFalse(result) != inverse) continue;
                temp.set(one, two, thirdOne, thirdTwo, firstOne, firstTwo);
                result = temp.isCoordinateToTheRight(pointOne, pointTwo);
                if (result != null && BooleanUtils.isFalse(result) != inverse) continue;
                inside = true;
                break;
            }
            if (inside) continue;
            return false;
        }
        return true;
    }

    public List<VectorFan> cut2d(List<VectorFan> cutters, EnumFacing.Axis one, EnumFacing.Axis two, boolean inverse, boolean takeInner) {
        ArrayList<VectorFan> temp = new ArrayList<VectorFan>();
        ArrayList<VectorFan> next = new ArrayList<VectorFan>();
        temp.add(this);
        for (VectorFan cutter : cutters) {
            for (VectorFan fan2 : temp) {
                next.addAll(fan2.cut2d(cutter, one, two, inverse, takeInner));
            }
            temp.clear();
            temp.addAll(next);
            next.clear();
        }
        return temp;
    }

    public List<VectorFan> cut2d(VectorFan cutter, EnumFacing.Axis one, EnumFacing.Axis two, boolean inverse, boolean takeInner) {
        ArrayList<VectorFan> done = new ArrayList<VectorFan>();
        VectorFan toCut = this;
        Vector3f before = cutter.coords[0];
        Ray2d ray = new Ray2d(one, two, 0.0, 0.0, 0.0, 0.0);
        for (int i = 1; i <= cutter.coords.length; ++i) {
            boolean last = i == cutter.coords.length;
            Vector3f vec = last ? cutter.coords[0] : cutter.coords[i];
            ray.originOne = VectorUtils.get(one, (Tuple3f)before);
            ray.originTwo = VectorUtils.get(two, (Tuple3f)before);
            ray.directionOne = VectorUtils.get(one, (Tuple3f)vec) - VectorUtils.get(one, (Tuple3f)before);
            ray.directionTwo = VectorUtils.get(two, (Tuple3f)vec) - VectorUtils.get(two, (Tuple3f)before);
            if ((toCut = toCut.cut2d(ray, one, two, takeInner ? null : done, inverse)) == null) {
                return done;
            }
            before = vec;
        }
        if (takeInner) {
            done.add(toCut);
        }
        return done;
    }

    protected VectorFan cut2d(Ray2d ray, EnumFacing.Axis one, EnumFacing.Axis two, List<VectorFan> done, boolean inverse) {
        boolean allTheSame = true;
        Boolean allValue = null;
        Boolean[] cutted = new Boolean[this.coords.length];
        for (int i = 0; i < cutted.length; ++i) {
            cutted[i] = ray.isCoordinateToTheRight(VectorUtils.get(one, (Tuple3f)this.coords[i]), VectorUtils.get(two, (Tuple3f)this.coords[i]));
            if (inverse && cutted[i] != null) {
                cutted[i] = cutted[i] == false;
            }
            if (!allTheSame) continue;
            if (i == 0) {
                allValue = cutted[i];
                continue;
            }
            if (allValue == null) {
                allValue = cutted[i];
                continue;
            }
            if (allValue == cutted[i] || cutted[i] == null) continue;
            allTheSame = false;
        }
        if (allTheSame) {
            if (allValue == null) {
                return null;
            }
            if (allValue.booleanValue()) {
                return this;
            }
            if (done != null) {
                done.add(this);
            }
            return null;
        }
        float thirdAxisValue = VectorUtils.get(RotationUtils.getThird(one, two), (Tuple3f)this.coords[0]);
        ArrayList<Vector3f> left = new ArrayList<Vector3f>();
        ArrayList<Vector3f> right = new ArrayList<Vector3f>();
        Boolean beforeCutted = cutted[cutted.length - 1];
        Vector3f beforeVec = this.coords[this.coords.length - 1];
        for (int i = 0; i < this.coords.length; ++i) {
            Vector3f intersection;
            Vector3f vec = this.coords[i];
            if (BooleanUtils.isTrue(cutted[i])) {
                if (BooleanUtils.isFalse(beforeCutted) && (intersection = ray.intersect(vec, beforeVec, thirdAxisValue)) != null) {
                    left.add(intersection);
                    right.add(intersection);
                }
                right.add(vec);
            } else if (BooleanUtils.isFalse(cutted[i])) {
                if (BooleanUtils.isTrue(beforeCutted) && (intersection = ray.intersect(vec, beforeVec, thirdAxisValue)) != null) {
                    left.add(intersection);
                    right.add(intersection);
                }
                left.add(vec);
            } else {
                left.add(vec);
                right.add(vec);
            }
            beforeCutted = cutted[i];
            beforeVec = vec;
        }
        if (left.size() >= 3 && done != null) {
            done.add(new VectorFan(left.toArray(new Vector3f[left.size()])));
        }
        if (right.size() < 3) {
            return null;
        }
        return new VectorFan(right.toArray(new Vector3f[right.size()]));
    }

    public static boolean isInside(List<NormalPlane> shape, Vector3f before, Vector3f vec, Boolean beforeOutside, Boolean outside, int currentPlane) {
        Vector3f intersection;
        return BooleanUtils.isFalse(beforeOutside) ? (outside == null ? VectorFan.isInside(shape, vec, currentPlane) : outside == true && (intersection = shape.get(currentPlane).intersect(before, vec)) != null && VectorFan.isInside(shape, intersection, currentPlane)) : BooleanUtils.isFalse(outside) && (beforeOutside == null ? VectorFan.isInside(shape, before, currentPlane) : beforeOutside == true && (intersection = shape.get(currentPlane).intersect(before, vec)) != null && VectorFan.isInside(shape, intersection, currentPlane));
    }

    public static boolean isInside(List<NormalPlane> shape, Vector3f vec, int toSkip) {
        for (int i = 0; i < shape.size(); ++i) {
            if (i == toSkip || BooleanUtils.isFalse(shape.get(i).isInFront(vec))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.coords);
    }

    public static class ParallelException
    extends Exception {
    }
}

