/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import top.outlands.foundation.IExplicitTransformer;
import top.outlands.foundation.boot.Foundation;
import top.outlands.foundation.boot.TransformerHolder;

public class TransformerDelegate {
    private static final boolean VERBOSE = Boolean.parseBoolean(System.getProperty("foundation.verbose", "false"));

    public static List<IClassTransformer> getTransformers() {
        return TransformerHolder.transformers;
    }

    public static Map<String, PriorityQueue<IExplicitTransformer>> getExplicitTransformers() {
        return TransformerHolder.explicitTransformers;
    }

    public static void registerRenameTransformer(IClassNameTransformer transformer) {
        Foundation.LOGGER.debug("Registering rename transformer: {}", (Object)transformer.getClass().getSimpleName());
        if (TransformerHolder.renameTransformer == null) {
            TransformerHolder.renameTransformer = transformer;
            TransformerDelegate.registerTransformer((IClassTransformer)((Object)transformer));
        }
    }

    public static void registerExplicitTransformer(String className, String ... targets) {
        if (targets.length == 0) {
            return;
        }
        Foundation.LOGGER.debug("Registering explicit transformer: {}", (Object)className);
        if (!className.contains(".")) {
            className = className.replace('/', '.');
        }
        try {
            IExplicitTransformer instance = (IExplicitTransformer)Launch.classLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            TransformerDelegate.registerExplicitTransformer(instance, targets);
        }
        catch (Exception e) {
            Foundation.LOGGER.error("Error registering explicit transformer class {}", (Object)className, (Object)e);
        }
    }

    public static void registerExplicitTransformer(IExplicitTransformer transformer, String ... targets) {
        if (targets.length == 0) {
            return;
        }
        Foundation.LOGGER.debug("Registering explicit transformer instance: {}", (Object)transformer.getClass().getSimpleName());
        try {
            for (String target : targets) {
                if (TransformerHolder.explicitTransformers.containsKey(target)) {
                    TransformerHolder.explicitTransformers.get(target).add(transformer);
                    continue;
                }
                PriorityQueue<IExplicitTransformer> transformerSet = new PriorityQueue<IExplicitTransformer>(Comparator.comparingInt(IExplicitTransformer::getPriority));
                transformerSet.add(transformer);
                TransformerHolder.explicitTransformers.put(target, transformerSet);
            }
        }
        catch (Exception e) {
            Foundation.LOGGER.error("Error registering explicit transformer class {}", (Object)transformer.getClass().getSimpleName(), (Object)e);
        }
    }

    public static void registerTransformer(String transformerClassName) {
        if (!transformerClassName.contains(".")) {
            transformerClassName = transformerClassName.replace('/', '.');
        }
        Foundation.LOGGER.debug("Registering transformer: {}", (Object)transformerClassName);
        try {
            IClassTransformer transformer = (IClassTransformer)Launch.classLoader.loadClass(transformerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            TransformerHolder.transformers.add(transformer);
            TransformerHolder.transformers.sort(Comparator.comparingInt(IClassTransformer::getPriority));
        }
        catch (Exception e) {
            Foundation.LOGGER.error("Error registering transformer class {}", (Object)transformerClassName, (Object)e);
        }
    }

    public static void registerTransformer(IClassTransformer transformer) {
        Foundation.LOGGER.debug("Registering transformer instance: {}", (Object)transformer.getClass().getName());
        TransformerHolder.transformers.add(transformer);
    }

    public static void unRegisterTransformer(String name) {
        Foundation.LOGGER.debug("Unregistering all transformers call: {}", (Object)name);
        try {
            TransformerHolder.transformers.stream().filter(transformer -> transformer.getClass().getName().equals(name)).forEach(TransformerHolder.transformers::remove);
            TransformerHolder.transformers.sort(Comparator.comparingInt(IClassTransformer::getPriority));
        }
        catch (Exception e) {
            Foundation.LOGGER.error("Error removing transformer class {}", (Object)name, (Object)e);
        }
    }

    public static void unRegisterTransformer(IClassTransformer transformer) {
        Foundation.LOGGER.debug("Unregistering transformer: {}", (Object)transformer.getClass().getSimpleName());
        try {
            TransformerHolder.transformers.remove(transformer);
            TransformerHolder.transformers.sort(Comparator.comparingInt(IClassTransformer::getPriority));
        }
        catch (Exception e) {
            Foundation.LOGGER.error("Error removing transformer class {}", (Object)transformer, (Object)e);
        }
    }

    static void fillTransformerHolder(TransformerHolder holder) {
        TransformerHolder.explicitTransformers = new HashMap<String, PriorityQueue<IExplicitTransformer>>(20);
        TransformerHolder.transformers = new LinkedList<IClassTransformer>();
        holder.runTransformersFunction = (name, transformedName, basicClass) -> {
            for (IClassTransformer transformer : Collections.unmodifiableList(TransformerHolder.transformers)) {
                basicClass = transformer.transform(name, transformedName, basicClass);
            }
            return basicClass;
        };
        holder.registerTransformerFunction = s -> {
            if (!s.contains(".")) {
                s = s.replace('/', '.');
            }
            try {
                IClassTransformer transformer = (IClassTransformer)Launch.classLoader.loadClass((String)s).getConstructor(new Class[0]).newInstance(new Object[0]);
                TransformerHolder.transformers.add(transformer);
                TransformerHolder.transformers.sort(Comparator.comparingInt(IClassTransformer::getPriority));
            }
            catch (Exception e) {
                Foundation.LOGGER.error("Error registering transformer class {}", s, (Object)e);
            }
        };
        holder.runExplicitTransformersFunction = (name, basicClass) -> {
            PriorityQueue<IExplicitTransformer> queue;
            if (TransformerHolder.explicitTransformers.containsKey(name) && (queue = TransformerHolder.explicitTransformers.get(name)) != null) {
                while (!queue.isEmpty()) {
                    basicClass = queue.poll().transform(basicClass);
                }
                TransformerHolder.explicitTransformers.remove(name);
            }
            return basicClass;
        };
        holder.transformNameFunction = s -> {
            if (TransformerHolder.renameTransformer != null) {
                return TransformerHolder.renameTransformer.remapClassName((String)s);
            }
            return s;
        };
        holder.unTransformNameFunction = s -> {
            if (TransformerHolder.renameTransformer != null) {
                return TransformerHolder.renameTransformer.unmapClassName((String)s);
            }
            return s;
        };
        holder.debugPrinter = () -> {
            Foundation.LOGGER.debug("Running transformers: ");
            TransformerDelegate.getTransformers().stream().map(t -> t.toString() + " : " + t.getPriority()).forEach(s -> Foundation.LOGGER.info(s));
            TransformerHolder.explicitTransformers.forEach((s, t) -> Foundation.LOGGER.debug("{}'s transformers:{}", s, (Object)Arrays.toString(t.toArray())));
            Foundation.LOGGER.debug("Transformer Exclusions: ");
            Launch.classLoader.getTransformerExclusions().forEach(s -> Foundation.LOGGER.debug(s));
            Foundation.LOGGER.debug("Class Paths: ");
            Arrays.stream(Launch.classLoader.getURLs()).forEach(s -> Foundation.LOGGER.debug(s));
        };
    }
}

