/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import top.outlands.foundation.TransformerDelegate;
import top.outlands.foundation.boot.ActualClassLoader;
import top.outlands.foundation.boot.Foundation;
import top.outlands.foundation.transformer.ASMClassWriterTransformer;
import top.outlands.foundation.transformer.ASMVisitorTransformer;

public class LaunchHandler {
    public void launch(String[] args) {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        ArgumentAcceptingOptionSpec profileOption = parser.accepts("version", "The version we launched with").withRequiredArg();
        ArgumentAcceptingOptionSpec gameDirOption = parser.accepts("gameDir", "Alternative game directory").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec assetsDirOption = parser.accepts("assetsDir", "Assets directory").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec tweakClassOption = parser.accepts("tweakClass", "Tweak class(es) to load").withRequiredArg();
        NonOptionArgumentSpec nonOption = parser.nonOptions();
        OptionSet options = parser.parse(args);
        Launch.minecraftHome = (File)options.valueOf((OptionSpec)gameDirOption);
        if (Launch.minecraftHome != null) {
            Launch.minecraftHome = Launch.minecraftHome.getAbsoluteFile();
        }
        if ((Launch.assetsDir = (File)options.valueOf((OptionSpec)assetsDirOption)) != null) {
            Launch.assetsDir = Launch.assetsDir.getAbsoluteFile();
        }
        String profileName = (String)options.valueOf((OptionSpec)profileOption);
        ArrayList tweakClassNames = new ArrayList(options.valuesOf((OptionSpec)tweakClassOption));
        ArrayList<String> argumentList = new ArrayList<String>();
        Launch.blackboard = new HashMap<String, Object>();
        Thread.currentThread().setContextClassLoader(Launch.classLoader);
        TransformerDelegate.fillTransformerHolder(ActualClassLoader.getTransformerHolder());
        TransformerDelegate.registerExplicitTransformer(new ASMVisitorTransformer(), "org.objectweb.asm.FieldVisitor", "org.objectweb.asm.ClassVisitor", "org.objectweb.asm.MethodVisitor");
        TransformerDelegate.registerExplicitTransformer(new ASMClassWriterTransformer(), "org.objectweb.asm.ClassWriter");
        try {
            Launch.classLoader.findClass("net.minecraft.launchwrapper.IClassTransformer");
            Launch.classLoader.findClass("net.minecraft.launchwrapper.ITweaker");
            Launch.classLoader.findClass("net.minecraft.launchwrapper.IClassNameTransformer");
            Launch.classLoader.findClass("org.objectweb.asm.FieldVisitor");
            Launch.classLoader.findClass("org.objectweb.asm.ClassVisitor");
            Launch.classLoader.findClass("org.objectweb.asm.MethodVisitor");
            Launch.classLoader.findClass("org.objectweb.asm.ClassWriter");
        }
        catch (ClassNotFoundException e) {
            Foundation.LOGGER.error("Can't find ASM", (Throwable)e);
        }
        Launch.classLoader.addTransformerExclusion("org.objectweb.asm.");
        Launch.blackboard.put("TweakClasses", tweakClassNames);
        Launch.blackboard.put("ArgumentList", argumentList);
        HashSet<String> allTweakerNames = new HashSet<String>();
        ArrayList<Object> allTweakers = new ArrayList<Object>();
        try {
            ArrayList<ITweaker> tweakers = new ArrayList<ITweaker>(tweakClassNames.size() + 1);
            Launch.blackboard.put("Tweaks", tweakers);
            ITweaker primaryTweaker = null;
            while (true) {
                if (!tweakClassNames.isEmpty()) {
                    String tweakName = (String)tweakClassNames.getFirst();
                    if (allTweakerNames.contains(tweakName)) {
                        Foundation.LOGGER.warn("Tweak name {} has already been visited -- skipping", (Object)tweakName);
                        tweakClassNames.removeFirst();
                        continue;
                    }
                    allTweakerNames.add(tweakName);
                    Foundation.LOGGER.info("Loading tweak name {}", (Object)tweakName);
                    Launch.classLoader.addTransformerExclusion(tweakName.substring(0, tweakName.lastIndexOf(46)));
                    ITweaker iTweaker = (ITweaker)Class.forName(tweakName, true, Launch.classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
                    tweakers.add(iTweaker);
                    tweakClassNames.removeFirst();
                    if (primaryTweaker != null) continue;
                    Foundation.LOGGER.info("Using primary tweak name {}", (Object)tweakName);
                    primaryTweaker = iTweaker;
                    continue;
                }
                while (!tweakers.isEmpty()) {
                    ITweaker tweaker = (ITweaker)tweakers.getFirst();
                    Foundation.LOGGER.info("Calling tweak {}", (Object)tweaker.toString());
                    tweaker.acceptOptions(options.valuesOf((OptionSpec)nonOption), Launch.minecraftHome, Launch.assetsDir, profileName);
                    tweaker.injectIntoClassLoader(Launch.classLoader);
                    allTweakers.add(tweaker);
                    tweakers.remove(tweaker);
                }
                if (tweakClassNames.isEmpty()) break;
            }
            for (ITweaker iTweaker : allTweakers) {
                argumentList.addAll(Arrays.asList(iTweaker.getLaunchArguments()));
            }
            String launchTarget = primaryTweaker.getLaunchTarget();
            Class<?> clazz = Class.forName(launchTarget, false, Launch.classLoader);
            MethodHandle mainMethod = MethodHandles.lookup().findStatic(clazz, "main", MethodType.methodType(Void.TYPE, String[].class));
            Foundation.LOGGER.info("Launching wrapped minecraft {}", (Object)launchTarget);
            mainMethod.invoke(argumentList.toArray(new String[0]));
        }
        catch (Throwable e) {
            Foundation.LOGGER.fatal("Unable to launch", e);
            System.exit(1);
        }
    }
}

