/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launchwrapper;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.Launch;
import top.outlands.foundation.boot.ActualClassLoader;

public class LaunchClassLoader
extends ActualClassLoader {
    private Set<String> classLoaderExceptions = new HashSet<String>();
    private Set<String> transformerExceptions = new HashSet<String>();
    private Map<Package, Manifest> packageManifests = null;
    private static Manifest EMPTY = new Manifest();
    private final Map<String, Class<?>> cachedClasses = new ConcurrentHashMap();
    private final Set<String> invalidClasses = new HashSet<String>(0);
    private final Map<String, byte[]> resourceCache = new ConcurrentHashMap<String, byte[]>(0);
    private final Set<String> negativeResourceCache = ConcurrentHashMap.newKeySet();

    public LaunchClassLoader(URL[] sources) {
        super(sources, LaunchClassLoader.class.getClassLoader());
        Launch.classLoader = this;
    }

    public LaunchClassLoader(ClassLoader loader) {
        super(LaunchClassLoader.getUCP(), loader);
        Launch.classLoader = this;
    }

    private static URL[] getUCP() {
        String[] classpaths = System.getProperty("java.class.path").split(File.pathSeparator);
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String classpath : classpaths) {
                urls.add(new File(classpath).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return urls.toArray(new URL[0]);
    }

    @Override
    public byte[] runTransformers(String name, String transformedName, byte[] basicClass) {
        return super.runTransformers(name, transformedName, basicClass);
    }
}

