/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class RealmsNotificationsScreen
extends RealmsScreen {
    private static final String INVITE_ICON_LOCATION = "realms:textures/gui/realms/invite_icon.png";
    private static final String TRIAL_ICON_LOCATION = "realms:textures/gui/realms/trial_icon.png";
    private static final String NEWS_ICON_LOCATION = "realms:textures/gui/realms/news_notification_mainscreen.png";
    private static final RealmsDataFetcher realmsDataFetcher = new RealmsDataFetcher();
    private volatile int numberOfPendingInvites;
    private static boolean checkedMcoAvailability;
    private static boolean trialAvailable;
    private static boolean validClient;
    private static boolean hasUnreadNews;
    private static final List<RealmsDataFetcher.Task> tasks;

    public RealmsNotificationsScreen(RealmsScreen lastScreen) {
    }

    public void init() {
        this.checkIfMcoEnabled();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
    }

    public void tick() {
        if (!(Realms.getRealmsNotificationsEnabled() && Realms.inTitleScreen() && validClient || realmsDataFetcher.isStopped())) {
            realmsDataFetcher.stop();
            return;
        }
        if (!validClient || !Realms.getRealmsNotificationsEnabled()) {
            return;
        }
        realmsDataFetcher.initWithSpecificTaskList(tasks);
        if (realmsDataFetcher.isFetchedSinceLastTry(RealmsDataFetcher.Task.PENDING_INVITE)) {
            this.numberOfPendingInvites = realmsDataFetcher.getPendingInvitesCount();
        }
        if (realmsDataFetcher.isFetchedSinceLastTry(RealmsDataFetcher.Task.TRIAL_AVAILABLE)) {
            trialAvailable = realmsDataFetcher.isTrialAvailable();
        }
        if (realmsDataFetcher.isFetchedSinceLastTry(RealmsDataFetcher.Task.UNREAD_NEWS)) {
            hasUnreadNews = realmsDataFetcher.hasUnreadNews();
        }
        realmsDataFetcher.markClean();
    }

    private void checkIfMcoEnabled() {
        if (!checkedMcoAvailability) {
            checkedMcoAvailability = true;
            new Thread("Realms Notification Availability checker #1"){

                @Override
                public void run() {
                    RealmsClient client = RealmsClient.createRealmsClient();
                    try {
                        RealmsClient.CompatibleVersionResponse versionResponse = client.clientCompatible();
                        if (!versionResponse.equals((Object)RealmsClient.CompatibleVersionResponse.COMPATIBLE)) {
                            return;
                        }
                    }
                    catch (RealmsServiceException e) {
                        if (e.httpResultCode != 401) {
                            checkedMcoAvailability = false;
                        }
                        return;
                    }
                    catch (IOException ignored) {
                        checkedMcoAvailability = false;
                        return;
                    }
                    validClient = true;
                }
            }.start();
        }
    }

    public void render(int xm, int ym, float a) {
        if (validClient) {
            this.drawIcons(xm, ym);
        }
        super.render(xm, ym, a);
    }

    public void mouseClicked(int xm, int ym, int button) {
    }

    private void drawIcons(int xm, int ym) {
        int pendingInvitesCount = this.numberOfPendingInvites;
        int spacing = 24;
        int topPos = this.height() / 4 + 48;
        int baseX = this.width() / 2 + 80;
        int baseY = topPos + 48 + 2;
        int iconOffset = 0;
        if (hasUnreadNews) {
            RealmsScreen.bind((String)NEWS_ICON_LOCATION);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
            RealmsScreen.blit((int)((int)((double)(baseX + 2 - iconOffset) * 2.5)), (int)((int)((double)baseY * 2.5)), (float)0.0f, (float)0.0f, (int)40, (int)40, (float)40.0f, (float)40.0f);
            GL11.glPopMatrix();
            iconOffset += 14;
        }
        if (pendingInvitesCount != 0) {
            RealmsScreen.bind((String)INVITE_ICON_LOCATION);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            RealmsScreen.blit((int)(baseX - iconOffset), (int)(baseY - 6), (float)0.0f, (float)0.0f, (int)15, (int)25, (float)31.0f, (float)25.0f);
            GL11.glPopMatrix();
            iconOffset += 16;
        }
        if (trialAvailable) {
            RealmsScreen.bind((String)TRIAL_ICON_LOCATION);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            int ySprite = 0;
            if ((System.currentTimeMillis() / 800L & 1L) == 1L) {
                ySprite = 8;
            }
            RealmsScreen.blit((int)(baseX + 4 - iconOffset), (int)(baseY + 4), (float)0.0f, (float)ySprite, (int)8, (int)8, (float)8.0f, (float)16.0f);
            GL11.glPopMatrix();
        }
    }

    public void removed() {
        realmsDataFetcher.stop();
    }

    static {
        tasks = Arrays.asList(RealmsDataFetcher.Task.PENDING_INVITE, RealmsDataFetcher.Task.TRIAL_AVAILABLE, RealmsDataFetcher.Task.UNREAD_NEWS);
    }
}

