/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.refmap;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import org.spongepowered.asm.service.MixinService;

public final class RemappingReferenceMapper
implements IReferenceMapper {
    private static final ILogger logger = MixinService.getService().getLogger("mixin");
    private static final Map<String, Map<String, String>> srgs = new HashMap<String, Map<String, String>>();
    private final IReferenceMapper refMap;
    private final Map<String, String> mappings;
    private final Map<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();

    private RemappingReferenceMapper(MixinEnvironment env, IReferenceMapper refMap) {
        this.refMap = refMap;
        this.refMap.setContext(RemappingReferenceMapper.getMappingEnv(env));
        String resource = RemappingReferenceMapper.getResource(env);
        this.mappings = RemappingReferenceMapper.loadSrgs(resource);
        logger.info("Remapping refMap {} using {}", refMap.getResourceName(), resource);
    }

    @Override
    public boolean isDefault() {
        return this.refMap.isDefault();
    }

    @Override
    public String getResourceName() {
        return this.refMap.getResourceName();
    }

    @Override
    public String getStatus() {
        return this.refMap.getStatus();
    }

    @Override
    public String getContext() {
        return this.refMap.getContext();
    }

    @Override
    public void setContext(String context) {
    }

    @Override
    public String remap(String className, String reference) {
        Map<String, String> classCache = this.getCache(className);
        String remapped = classCache.get(reference);
        if (remapped == null) {
            remapped = this.refMap.remap(className, reference);
            for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
                remapped = remapped.replace(entry.getKey(), entry.getValue());
            }
            classCache.put(reference, remapped);
        }
        return remapped;
    }

    private Map<String, String> getCache(String className) {
        return this.cache.computeIfAbsent(className, k -> new HashMap());
    }

    @Override
    public String remapWithContext(String context, String className, String reference) {
        return this.refMap.remapWithContext(context, className, reference);
    }

    private static Map<String, String> loadSrgs(String fileName) {
        if (srgs.containsKey(fileName)) {
            return srgs.get(fileName);
        }
        final LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        srgs.put(fileName, map);
        File file = new File(fileName);
        if (!file.isFile()) {
            return map;
        }
        try {
            Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).readLines((LineProcessor)new LineProcessor<Object>(){

                public Object getResult() {
                    return null;
                }

                public boolean processLine(@Nonnull String line) throws IOException {
                    if (Strings.isNullOrEmpty((String)line) || !line.startsWith("\t")) {
                        return true;
                    }
                    String[] entry = line.substring(1).split(" ");
                    if (entry.length > 2) {
                        map.put(entry[0], entry[2]);
                    } else {
                        map.put(entry[0], entry[1]);
                    }
                    return true;
                }
            });
        }
        catch (IOException ex) {
            logger.warn("Could not read input SRG file: {}", fileName);
            logger.catching(ex);
        }
        return map;
    }

    public static IReferenceMapper of(MixinEnvironment env, IReferenceMapper refMap) {
        if (!refMap.isDefault() && RemappingReferenceMapper.hasData(env)) {
            return new RemappingReferenceMapper(env, refMap);
        }
        return refMap;
    }

    private static boolean hasData(MixinEnvironment env) {
        String fileName = RemappingReferenceMapper.getResource(env);
        return fileName != null && new File(fileName).exists();
    }

    private static String getResource(MixinEnvironment env) {
        String resource = env.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_RESOURCE);
        return Strings.isNullOrEmpty((String)resource) ? System.getProperty("net.minecraftforge.gradle.GradleStart.srg.srg-mcp") : resource;
    }

    private static String getMappingEnv(MixinEnvironment env) {
        String resource = env.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_SOURCE_ENV);
        return Strings.isNullOrEmpty((String)resource) ? "searge" : resource;
    }
}

