/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch.platform;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.platform.IMixinPlatformAgent;
import org.spongepowered.asm.launch.platform.IMixinPlatformServiceAgent;
import org.spongepowered.asm.launch.platform.MixinPlatformAgentAbstract;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.launch.platform.container.ContainerHandleURI;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IRemapper;
import org.spongepowered.asm.service.mojang.MixinServiceLaunchWrapper;

public class MixinPlatformAgentFMLLegacy
extends MixinPlatformAgentAbstract
implements IMixinPlatformServiceAgent {
    private static final Set<String> loadedCoreMods = new HashSet<String>();
    private ITweaker coreModWrapper;
    private Class<?> clCoreModManager;
    private boolean initInjectionState;

    @Override
    public IMixinPlatformAgent.AcceptResult accept(MixinPlatformManager manager, IContainerHandle handle) {
        if (this.getCoreModManagerClass() == null) {
            return IMixinPlatformAgent.AcceptResult.INVALID;
        }
        if (!(handle instanceof ContainerHandleURI) || super.accept(manager, handle) != IMixinPlatformAgent.AcceptResult.ACCEPTED) {
            return IMixinPlatformAgent.AcceptResult.REJECTED;
        }
        return IMixinPlatformAgent.AcceptResult.ACCEPTED;
    }

    @Override
    public String getPhaseProvider() {
        return MixinPlatformAgentFMLLegacy.class.getName() + "$PhaseProvider";
    }

    @Override
    public void prepare() {
        this.initInjectionState |= MixinPlatformAgentFMLLegacy.isTweakerQueued("FMLInjectionAndSortingTweaker");
    }

    @Override
    public void inject() {
        if (this.coreModWrapper != null && this.checkForCoInitialisation()) {
            MixinPlatformAgentAbstract.logger.debug("FML agent is co-initiralising coremod instance {} for {}", this.coreModWrapper, this.handle);
            this.coreModWrapper.injectIntoClassLoader(Launch.classLoader);
        }
    }

    protected final boolean checkForCoInitialisation() {
        boolean injectionTweaker = MixinPlatformAgentFMLLegacy.isTweakerQueued("FMLInjectionAndSortingTweaker");
        boolean terminalTweaker = MixinPlatformAgentFMLLegacy.isTweakerQueued("TerminalTweaker");
        if (this.initInjectionState && terminalTweaker || injectionTweaker) {
            MixinPlatformAgentAbstract.logger.debug("FML agent is skipping co-init for {} because FML will inject it normally", this.coreModWrapper);
            return false;
        }
        return !MixinPlatformAgentFMLLegacy.isTweakerQueued("FMLDeobfTweaker");
    }

    private Class<?> getCoreModManagerClass() {
        if (this.clCoreModManager != null) {
            return this.clCoreModManager;
        }
        try {
            this.clCoreModManager = Class.forName(GlobalProperties.getString(GlobalProperties.Keys.FML_CORE_MOD_MANAGER, "net.minecraftforge.fml.relauncher.CoreModManager"));
        }
        catch (ClassNotFoundException ex) {
            MixinPlatformAgentAbstract.logger.info("FML platform manager could not load class {}. Proceeding without FML support.", ex.getMessage());
        }
        return this.clCoreModManager;
    }

    private static boolean isTweakerQueued(String tweakerName) {
        for (String tweaker : (List)GlobalProperties.get(MixinServiceLaunchWrapper.BLACKBOARD_KEY_TWEAKCLASSES)) {
            if (!tweaker.endsWith(tweakerName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void init() {
    }

    public static void injectRemapper(IRemapper remapper) {
        try {
            MixinEnvironment defaultEnv = MixinEnvironment.getDefaultEnvironment();
            if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                defaultEnv.setOption(MixinEnvironment.Option.REFMAP_REMAP, true);
                defaultEnv.setOption(MixinEnvironment.Option.REFMAP_REMAP_RESOURCE, true);
                defaultEnv.setOption(MixinEnvironment.Option.REFMAP_REMAP_SOURCE_ENV, true);
                System.setProperty("mixin.env.refMapRemapping", "build/createSrg2Mcp/output.tsrg");
                System.setProperty("mixin.env.refMapRemappingEnv", "mcp");
            }
            defaultEnv.getRemappers().add(remapper);
        }
        catch (Exception ex) {
            MixinPlatformAgentAbstract.logger.debug("Failed instancing FML remapper adapter, things will probably go horribly for notch-obf'd mods!", new Object[0]);
        }
    }

    @Override
    public String getSideName() {
        List tweakerList = (List)GlobalProperties.get(MixinServiceLaunchWrapper.BLACKBOARD_KEY_TWEAKS);
        if (tweakerList == null) {
            return null;
        }
        for (ITweaker tweaker : tweakerList) {
            if (tweaker.getClass().getName().endsWith(".common.launcher.FMLServerTweaker")) {
                return "SERVER";
            }
            if (!tweaker.getClass().getName().endsWith(".common.launcher.FMLTweaker")) continue;
            return "CLIENT";
        }
        return MixinPlatformAgentAbstract.invokeStringMethod((ClassLoader)Launch.classLoader, "net.minecraftforge.fml.relauncher.FMLLaunchHandler", "side");
    }

    @Override
    public Collection<IContainerHandle> getMixinContainers() {
        return null;
    }

    static {
        for (String cmdLineCoreMod : System.getProperty("fml.coreMods.load", "").split(",")) {
            if (cmdLineCoreMod.isEmpty()) continue;
            MixinPlatformAgentAbstract.logger.debug("FML platform agent will ignore coremod {} specified on the command line", cmdLineCoreMod);
            loadedCoreMods.add(cmdLineCoreMod);
        }
    }
}

