/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.opengl;

import com.sun.jna.platform.unix.LibC;
import java.awt.Canvas;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeEarlyConfig;
import net.minecraftforge.common.config.ConfigManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCharModsCallback;
import org.lwjgl.glfw.GLFWCharModsCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Struct;
import org.lwjglx.Sys;
import org.lwjglx.input.KeyCodes;
import org.lwjglx.input.KeyEvent;
import org.lwjglx.input.KeyState;
import org.lwjglx.input.Keyboard;
import org.lwjglx.input.Mouse;
import org.lwjglx.opengl.ContextAttribs;
import org.lwjglx.opengl.DisplayImplementation;
import org.lwjglx.opengl.DisplayMode;
import org.lwjglx.opengl.Drawable;
import org.lwjglx.opengl.DrawableGL;
import org.lwjglx.opengl.PixelFormat;
import org.lwjglx.opengl.Sync;
import org.lwjglx.util.Rectangle;
import oshi.SystemInfo;

public class Display {
    private static String windowTitle = "Game";
    private static boolean displayCreated = false;
    private static boolean displayFocused = false;
    private static boolean displayVisible = true;
    private static boolean displayDirty = false;
    private static boolean displayResizable = false;
    private static boolean startFullscreen = false;
    private static boolean borderlessInsteadOfFullscreen = true;
    private static DisplayMode mode = new DisplayMode(854, 480);
    private static DisplayMode desktopDisplayMode;
    private static int latestEventKey;
    private static int displayX;
    private static int displayY;
    private static boolean displayResized;
    private static int displayWidth;
    private static int displayHeight;
    private static int displayFramebufferWidth;
    private static int displayFramebufferHeight;
    private static boolean latestResized;
    private static int latestWidth;
    private static int latestHeight;
    private static ByteBuffer[] savedIcons;
    private static boolean cancelNextChar;
    private static KeyEvent ingredientKeyEvent;
    private static boolean lastAltIsRightAlt;
    private static HashMap<Integer, String> glfwKeycodeNames;
    private static boolean hasPixelFormat;
    private static PixelFormat attachmentPixelFormat;
    private static boolean hasContextAttribs;
    private static ContextAttribs attachmentContextAttribs;
    private static boolean hasDrawable;
    private static Drawable attachmentDrawable;
    private static int[] savedX;
    private static int[] savedY;
    private static int[] savedW;
    private static int[] savedH;
    protected static DrawableGL drawable;

    public static void create(PixelFormat pixel_format, Drawable shared_drawable) {
        hasPixelFormat = true;
        attachmentPixelFormat = pixel_format;
        hasDrawable = true;
        attachmentDrawable = shared_drawable;
        System.out.println("[LWJGLXX] TODO: Implement Display.create(PixelFormat, Drawable)");
        Display.create();
    }

    public static void create(PixelFormat pixel_format, ContextAttribs attribs) {
        hasPixelFormat = true;
        attachmentPixelFormat = pixel_format;
        hasContextAttribs = true;
        attachmentContextAttribs = attribs;
        System.out.println("[LWJGLXX] TODO: Implement Display.create(PixelFormat, ContextAttribs)");
        Display.create();
    }

    public static void create(PixelFormat pixel_format) {
        hasPixelFormat = true;
        attachmentPixelFormat = pixel_format;
        Display.create();
    }

    private static void processAttachments() {
        if (hasPixelFormat) {
            int perChannel;
            if (attachmentPixelFormat.getBitsPerPixel() > 0) {
                perChannel = attachmentPixelFormat.getBitsPerPixel() / 3;
                GLFW.glfwWindowHint((int)135169, (int)perChannel);
                GLFW.glfwWindowHint((int)135170, (int)perChannel);
                GLFW.glfwWindowHint((int)135171, (int)perChannel);
            }
            GLFW.glfwWindowHint((int)135172, (int)attachmentPixelFormat.getAlphaBits());
            GLFW.glfwWindowHint((int)135173, (int)attachmentPixelFormat.getDepthBits());
            GLFW.glfwWindowHint((int)135174, (int)attachmentPixelFormat.getStencilBits());
            GLFW.glfwWindowHint((int)135181, (int)attachmentPixelFormat.getSamples());
            if (attachmentPixelFormat.getAccumulationBitsPerPixel() > 0) {
                perChannel = attachmentPixelFormat.getAccumulationBitsPerPixel() / 3;
                GLFW.glfwWindowHint((int)135175, (int)perChannel);
                GLFW.glfwWindowHint((int)135176, (int)perChannel);
                GLFW.glfwWindowHint((int)135177, (int)perChannel);
            }
            if (attachmentPixelFormat.getAccumulationAlpha() > 0) {
                GLFW.glfwWindowHint((int)135178, (int)attachmentPixelFormat.getAccumulationAlpha());
            }
            if (attachmentPixelFormat.isStereo()) {
                GLFW.glfwWindowHint((int)135180, (int)1);
            }
            if (attachmentPixelFormat.isSRGB()) {
                GLFW.glfwWindowHint((int)135182, (int)1);
            }
        }
        if (hasContextAttribs) {
            // empty if block
        }
        if (hasDrawable) {
            // empty if block
        }
    }

    public static void create() {
        String[] parts;
        if (displayCreated) {
            return;
        }
        System.out.println("[LWJGLXX] Creating Display");
        int versionMajor = ForgeEarlyConfig.OPENGL_VERSION_MAJOR;
        int versionMinor = ForgeEarlyConfig.OPENGL_VERSION_MINOR;
        System.out.println("[LWJGLXX] Preferred OpenGL version from forge_early.cfg is " + versionMajor + "." + versionMinor);
        if (versionMajor == 1) {
            versionMajor = 2;
            versionMinor = 1;
        } else if (versionMajor == 2) {
            if (versionMinor != 1) {
                versionMinor = 1;
            }
        } else if (versionMajor == 3) {
            if (versionMinor < 0) {
                versionMinor = 0;
            } else if (versionMinor > 3) {
                versionMinor = 3;
            }
        } else if (versionMajor == 4) {
            if (versionMinor < 0) {
                versionMinor = 0;
            } else if (versionMinor > 6) {
                versionMinor = 6;
            }
        } else if (versionMajor < 1) {
            versionMajor = 2;
            versionMinor = 1;
        } else {
            versionMajor = 4;
            versionMinor = 6;
        }
        System.out.println("[LWJGLXX] OpenGL version after validation is " + versionMajor + "." + versionMinor);
        while (true) {
            SystemInfo si;
            GLFW.glfwDefaultWindowHints();
            Display.processAttachments();
            GLFW.glfwWindowHint((int)131076, (int)1);
            GLFW.glfwWindowHint((int)131075, (int)1);
            GLFW.glfwWindowHint((int)139266, (int)versionMajor);
            GLFW.glfwWindowHint((int)139267, (int)versionMinor);
            if (versionMajor > 3 || versionMajor == 3 && versionMinor >= 2) {
                GLFW.glfwWindowHint((int)139272, (int)(ForgeEarlyConfig.OPENGL_COMPAT_PROFILE ? 204802 : 204801));
            }
            GLFW.glfwWindowHint((int)131080, (int)(ForgeEarlyConfig.WINDOW_START_MAXIMIZED ? 1 : 0));
            GLFW.glfwWindowHint((int)131073, (int)(ForgeEarlyConfig.WINDOW_START_FOCUSED ? 1 : 0));
            displayFocused = ForgeEarlyConfig.WINDOW_START_FOCUSED;
            GLFW.glfwWindowHint((int)131074, (int)(ForgeEarlyConfig.WINDOW_START_ICONIFIED ? 1 : 0));
            displayVisible = !ForgeEarlyConfig.WINDOW_START_ICONIFIED;
            GLFW.glfwWindowHint((int)131077, (int)(ForgeEarlyConfig.WINDOW_DECORATED ? 1 : 0));
            displayX = (desktopDisplayMode.getWidth() - mode.getWidth()) / 2;
            displayY = (desktopDisplayMode.getHeight() - mode.getHeight()) / 2;
            GLFW.glfwWindowHint((int)131086, (int)displayX);
            GLFW.glfwWindowHint((int)131087, (int)displayY);
            GLFW.glfwWindowHint((int)135183, (int)desktopDisplayMode.getFrequency());
            GLFW.glfwWindowHint((int)135182, (int)(ForgeEarlyConfig.OPENGL_SRGB_CONTEXT ? 1 : 0));
            GLFW.glfwWindowHint((int)135184, (int)(ForgeEarlyConfig.OPENGL_DOUBLEBUFFER ? 1 : 0));
            GLFW.glfwWindowHint((int)139274, (int)(ForgeEarlyConfig.OPENGL_CONTEXT_NO_ERROR ? 1 : 0));
            GLFW.glfwWindowHint((int)139271, (int)(ForgeEarlyConfig.OPENGL_DEBUG_CONTEXT ? 1 : 0));
            GLFW.glfwWindowHint((int)131077, (int)(ForgeEarlyConfig.DECORATED ? 1 : 0));
            GLFW.glfwWindowHintString((int)147457, (CharSequence)ForgeEarlyConfig.X11_CLASS_NAME);
            GLFW.glfwWindowHintString((int)143362, (CharSequence)ForgeEarlyConfig.COCOA_FRAME_NAME);
            GLFW.glfwWindowHint((int)143361, (int)(ForgeEarlyConfig.COCOA_RETINA_FRAMEBUFFER ? 1 : 0));
            if (ForgeEarlyConfig.WINDOW_CENTERED) {
                GLFW.glfwWindowHint((int)131086, (int)((desktopDisplayMode.getWidth() - mode.getWidth()) / 2));
                GLFW.glfwWindowHint((int)131087, (int)((desktopDisplayMode.getHeight() - mode.getHeight()) / 2));
            }
            if ((Platform.get() == Platform.LINUX || Platform.get() == Platform.FREEBSD) && (si = new SystemInfo()).getHardware().getGraphicsCards().stream().anyMatch(graphicsCard -> graphicsCard.getVendor().startsWith("NVIDIA"))) {
                LibC.INSTANCE.setenv("__GL_THREADED_OPTIMIZATIONS", "0", 1);
            }
            System.out.println("[LWJGLXX] Attempting to create OpenGL " + versionMajor + "." + versionMinor + " context");
            Window.handle = GLFW.glfwCreateWindow((int)mode.getWidth(), (int)mode.getHeight(), (CharSequence)windowTitle, (long)0L, (long)0L);
            GLFW.glfwSetInputMode((long)Window.handle, (int)208897, (int)212993);
            if (Window.handle == 0L && versionMajor == 2 && versionMinor == 1) {
                System.out.println("[LWJGLXX] Failed to get OpenGL " + versionMajor + "." + versionMinor + " window handle");
                throw new IllegalStateException("Failed to create Display window.");
            }
            if (Window.handle != 0L) break;
            System.out.println("[LWJGLXX] Failed to get OpenGL " + versionMajor + "." + versionMinor + " window handle");
            if (versionMinor - 1 < 0) {
                if (--versionMajor == 3) {
                    versionMinor = 3;
                    continue;
                }
                if (versionMajor != 2) continue;
                versionMinor = 1;
                continue;
            }
            --versionMinor;
        }
        System.out.println("[LWJGLXX] Obtained OpenGL " + versionMajor + "." + versionMinor + " window handle");
        if (GLFW.glfwRawMouseMotionSupported() && ForgeEarlyConfig.RAW_INPUT) {
            GLFW.glfwSetInputMode((long)Window.handle, (int)208901, (int)1);
        }
        Window.keyCallback = new GLFWKeyCallback(){

            public void invoke(long window, int key, int scancode, int action, int mods) {
                cancelNextChar = false;
                if (action == 1) {
                    if (key == 342) {
                        lastAltIsRightAlt = false;
                    } else if (key == 346) {
                        lastAltIsRightAlt = true;
                    }
                }
                if (key > 32 && key <= 96) {
                    boolean ctrlGraphicalMode;
                    boolean isAlt = (4 & mods) != 0;
                    boolean isAltGr = lastAltIsRightAlt;
                    if (isAlt) {
                        ctrlGraphicalMode = isAltGr ? !ForgeEarlyConfig.INPUT_ALTGR_ESCAPE_CODES : ForgeEarlyConfig.INPUT_CTRL_ALT_TEXT;
                        if (ctrlGraphicalMode) {
                            Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, (char)(key & 0x1F));
                        }
                    } else {
                        ctrlGraphicalMode = false;
                    }
                    if ((2 & mods) != 0 && !ctrlGraphicalMode) {
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, (char)(key & 0x1F));
                        cancelNextChar = true;
                    } else if (action > 0) {
                        ingredientKeyEvent = new KeyEvent(KeyCodes.toLwjglKey(key), '\u0000', action > 1 ? KeyState.REPEAT : KeyState.PRESS, Sys.getNanoTime());
                    } else {
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, '\u0000');
                    }
                } else {
                    Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, KeyCodes.glfwToASCII(key));
                }
            }
        };
        Window.charCallback = new GLFWCharCallback(){

            public void invoke(long window, int codepoint) {
                if (cancelNextChar) {
                    cancelNextChar = false;
                } else {
                    Keyboard.addCharEvent(0, (char)codepoint);
                }
            }
        };
        Window.charModsCallback = new GLFWCharModsCallback(){

            public void invoke(long window, int codepoint, int mods) {
                if (cancelNextChar) {
                    cancelNextChar = false;
                } else if (ingredientKeyEvent != null) {
                    Display.ingredientKeyEvent.aChar = (char)codepoint;
                    Keyboard.addKeyEvent(ingredientKeyEvent);
                    ingredientKeyEvent = null;
                    cancelNextChar = true;
                }
            }
        };
        Window.cursorPosCallback = new GLFWCursorPosCallback(){

            public void invoke(long window, double xpos, double ypos) {
                Mouse.addMoveEvent(xpos, ypos);
            }
        };
        Window.mouseButtonCallback = new GLFWMouseButtonCallback(){

            public void invoke(long window, int button, int action, int mods) {
                Mouse.addButtonEvent(button, action == 1);
            }
        };
        Window.scrollCallback = new GLFWScrollCallback(){

            public void invoke(long window, double xoffset, double yoffset) {
                Mouse.addWheelEvent(yoffset == 0.0 ? xoffset : yoffset);
            }
        };
        Window.windowFocusCallback = new GLFWWindowFocusCallback(){

            public void invoke(long window, boolean focused) {
                displayFocused = focused;
            }
        };
        Window.windowIconifyCallback = new GLFWWindowIconifyCallback(){

            public void invoke(long window, boolean iconified) {
                displayVisible = !iconified;
            }
        };
        Window.windowSizeCallback = new GLFWWindowSizeCallback(){

            public void invoke(long window, int width, int height) {
                if (width != 0 && height != 0) {
                    latestResized = true;
                    latestWidth = width;
                    latestHeight = height;
                }
            }
        };
        Window.windowPosCallback = new GLFWWindowPosCallback(){

            public void invoke(long window, int xpos, int ypos) {
                displayX = xpos;
                displayY = ypos;
            }
        };
        Window.windowRefreshCallback = new GLFWWindowRefreshCallback(){

            public void invoke(long window) {
                displayDirty = true;
            }
        };
        Window.framebufferSizeCallback = new GLFWFramebufferSizeCallback(){

            public void invoke(long window, int width, int height) {
                displayFramebufferWidth = width;
                displayFramebufferHeight = height;
            }
        };
        Window.setCallbacks();
        displayWidth = desktopDisplayMode.getWidth();
        displayHeight = desktopDisplayMode.getHeight();
        IntBuffer fbw = org.lwjglx.BufferUtils.createIntBuffer(1);
        IntBuffer fbh = org.lwjglx.BufferUtils.createIntBuffer(1);
        GLFW.glfwGetFramebufferSize((long)Window.handle, (IntBuffer)fbw, (IntBuffer)fbh);
        displayFramebufferWidth = fbw.get(0);
        displayFramebufferHeight = fbh.get(0);
        GLFW.glfwMakeContextCurrent((long)Window.handle);
        drawable = new DrawableGL();
        GL.createCapabilities();
        if (savedIcons != null) {
            Display.setIcon(savedIcons);
            savedIcons = null;
        }
        GLFW.glfwSwapInterval((int)1);
        if (startFullscreen) {
            Display.setFullscreen(true);
        }
        displayCreated = true;
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetWindowSize((long)Window.handle, (int[])x, (int[])y);
        Window.windowSizeCallback.invoke(Window.handle, x[0], y[0]);
        GLFW.glfwGetFramebufferSize((long)Window.handle, (int[])x, (int[])y);
        Window.framebufferSizeCallback.invoke(Window.handle, x[0], y[0]);
        ForgeEarlyConfig.OPENGL_VERSION_MAJOR = versionMajor;
        ForgeEarlyConfig.OPENGL_VERSION_MINOR = versionMinor;
        String rawGLVersion = GL11.glGetString((int)7938);
        if (rawGLVersion != null && (parts = rawGLVersion.split("\\s+")[0].split("\\.")).length >= 2) {
            try {
                ForgeEarlyConfig.OPENGL_VERSION_MAJOR = Integer.parseInt(parts[0]);
                ForgeEarlyConfig.OPENGL_VERSION_MINOR = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.out.println("[LWJGLXX] Current OpenGL version is " + ForgeEarlyConfig.OPENGL_VERSION_MAJOR + "." + ForgeEarlyConfig.OPENGL_VERSION_MINOR);
        ConfigManager.sync(ForgeEarlyConfig.class);
        System.out.println("[LWJGLXX] Cached current OpenGL version to forge_early.cfg");
    }

    public static boolean isCreated() {
        return displayCreated;
    }

    public static boolean isActive() {
        return displayFocused;
    }

    public static boolean isVisible() {
        return displayVisible;
    }

    public static void setLocation(int new_x, int new_y) {
        if (!displayCreated) {
            displayX = new_x;
            displayY = new_y;
        } else {
            GLFW.glfwSetWindowPos((long)Window.handle, (int)new_x, (int)new_y);
        }
    }

    public static void setVSyncEnabled(boolean sync) {
        GLFW.glfwSwapInterval((int)(sync ? 1 : 0));
    }

    public static long getWindow() {
        return Window.handle;
    }

    public static void update() {
        Display.update(true);
    }

    public static void update(boolean processMessages) {
        Display.swapBuffers();
        displayDirty = false;
        if (processMessages) {
            Display.processMessages();
        }
    }

    public static void processMessages() {
        GLFW.glfwPollEvents();
        Keyboard.poll();
        Mouse.poll();
        if (latestResized) {
            latestResized = false;
            displayResized = true;
            displayWidth = latestWidth;
            displayHeight = latestHeight;
        } else {
            displayResized = false;
        }
    }

    public static void swapBuffers() {
        GLFW.glfwSwapBuffers((long)Window.handle);
    }

    public static void destroy() {
        Window.releaseCallbacks();
        GLFW.glfwDestroyWindow((long)Window.handle);
        displayCreated = false;
    }

    public static void setDisplayMode(DisplayMode dm) {
        mode = dm;
    }

    public static DisplayMode getDisplayMode() {
        return mode;
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        IntBuffer count = org.lwjglx.BufferUtils.createIntBuffer(1);
        GLFWVidMode.Buffer modes = GLFW.glfwGetVideoModes((long)GLFW.glfwGetPrimaryMonitor());
        DisplayMode[] displayModes = new DisplayMode[count.get(0)];
        for (int i = 0; i < count.get(0); ++i) {
            modes.position(i * GLFWVidMode.SIZEOF);
            int w = modes.width();
            int h = modes.height();
            int b = modes.redBits() + modes.greenBits() + modes.blueBits();
            int r = modes.refreshRate();
            displayModes[i] = new DisplayMode(w, h, b, r);
        }
        return displayModes;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktopDisplayMode;
    }

    public static boolean wasResized() {
        return displayResized;
    }

    public static int getX() {
        return displayX;
    }

    public static int getY() {
        return displayY;
    }

    public static int getWidth() {
        return displayFramebufferWidth;
    }

    public static int getHeight() {
        return displayFramebufferHeight;
    }

    public static int getFramebufferWidth() {
        return displayFramebufferWidth;
    }

    public static int getFramebufferHeight() {
        return displayFramebufferHeight;
    }

    public static String getTitle() {
        return windowTitle;
    }

    public static float getPixelScaleFactor() {
        if (!Display.isCreated()) {
            return 1.0f;
        }
        int[] windowWidth = new int[1];
        int[] windowHeight = new int[1];
        int[] framebufferWidth = new int[1];
        int[] framebufferHeight = new int[1];
        GLFW.glfwGetWindowSize((long)Display.getWindow(), (int[])windowWidth, (int[])windowHeight);
        GLFW.glfwGetFramebufferSize((long)Display.getWindow(), (int[])framebufferWidth, (int[])framebufferHeight);
        float xScale = (float)framebufferWidth[0] / (float)windowWidth[0];
        float yScale = (float)framebufferHeight[0] / (float)windowHeight[0];
        return Math.max(xScale, yScale);
    }

    public static void setTitle(String title) {
        if (Display.getWindow() != 0L) {
            GLFW.glfwSetWindowTitle((long)Window.handle, (CharSequence)title);
        }
        windowTitle = title;
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose((long)Window.handle);
    }

    public static boolean isDirty() {
        return displayDirty;
    }

    public static void setInitialBackground(float red, float green, float blue) {
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (Display.getWindow() == 0L) {
            savedIcons = icons;
            return 0;
        }
        GLFWImage.Buffer glfwImages = GLFWImage.calloc((int)icons.length);
        ByteBuffer[] nativeBuffers = new ByteBuffer[icons.length];
        for (int icon = 0; icon < icons.length; ++icon) {
            nativeBuffers[icon] = BufferUtils.createByteBuffer((int)icons[icon].capacity());
            nativeBuffers[icon].put(icons[icon]);
            nativeBuffers[icon].flip();
            int dimension = (int)Math.sqrt((double)nativeBuffers[icon].limit() / 4.0);
            if (dimension * dimension * 4 != nativeBuffers[icon].limit()) {
                throw new IllegalStateException();
            }
            glfwImages.put(icon, (Struct)GLFWImage.create().set(dimension, dimension, nativeBuffers[icon]));
        }
        GLFW.glfwSetWindowIcon((long)Display.getWindow(), (GLFWImage.Buffer)glfwImages);
        glfwImages.free();
        return 0;
    }

    public static void setResizable(boolean resizable) {
        displayResizable = resizable;
    }

    public static boolean isResizable() {
        return displayResizable;
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) {
        System.out.println("TODO: Implement Display.setDisplayModeAndFullscreen(DisplayMode)");
    }

    public static PositionedGLFWVidMode getTargetFullscreenMonitor() {
        int x = savedX[0] + savedW[0] / 2;
        int y = savedY[0] + savedH[0] / 2;
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        assert (monitors != null);
        ArrayList<PositionedGLFWVidMode> monitorInfos = new ArrayList<PositionedGLFWVidMode>(monitors.limit());
        for (int i = 0; i < monitors.limit(); ++i) {
            long monitor = monitors.get(i);
            PositionedGLFWVidMode monitorInfo = Display.getPositionedMonitorInfo(monitor);
            monitorInfos.add(monitorInfo);
            if (!monitorInfo.bounds.contains(x, y)) continue;
            return monitorInfo;
        }
        Rectangle windowBounds = new Rectangle(savedX[0], savedY[0], savedW[0], savedH[0]);
        Optional<PositionedGLFWVidMode> targetMonitor = monitorInfos.stream().filter(o -> !o.bounds.intersection(windowBounds, null).isEmpty()).max(Comparator.comparingInt(o -> o.bounds.intersection(windowBounds, null).getArea()));
        return targetMonitor.orElse(Display.getPositionedMonitorInfo(GLFW.glfwGetPrimaryMonitor()));
    }

    private static PositionedGLFWVidMode getPositionedMonitorInfo(long monitorId) {
        IntBuffer posX = org.lwjglx.BufferUtils.createIntBuffer(1);
        IntBuffer posY = org.lwjglx.BufferUtils.createIntBuffer(1);
        GLFW.glfwGetMonitorPos((long)monitorId, (IntBuffer)posX, (IntBuffer)posY);
        int x = posX.get(0);
        int y = posY.get(0);
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitorId);
        assert (vidmode != null);
        return new PositionedGLFWVidMode(x, y, new Rectangle(x, y, vidmode.width(), vidmode.height()), monitorId, vidmode);
    }

    public static void setFullscreen(boolean fullscreen) {
        long window = Display.getWindow();
        if (window == 0L) {
            startFullscreen = fullscreen;
            return;
        }
        boolean currentState = Display.isFullscreen();
        if (currentState == fullscreen) {
            return;
        }
        GLFW.glfwSetWindowSizeLimits((long)window, (int)0, (int)0, (int)-1, (int)-1);
        if (fullscreen) {
            GLFW.glfwGetWindowPos((long)window, (int[])savedX, (int[])savedY);
            GLFW.glfwGetWindowSize((long)window, (int[])savedW, (int[])savedH);
            PositionedGLFWVidMode monitorInfo = Display.getTargetFullscreenMonitor();
            GLFWVidMode vidMode = monitorInfo.vidMode;
            GLFW.glfwSetWindowMonitor((long)window, (long)monitorInfo.monitorId, (int)0, (int)0, (int)vidMode.width(), (int)vidMode.height(), (int)vidMode.refreshRate());
            if (displayCreated) {
                Minecraft.func_71410_x().func_71370_a(vidMode.width(), vidMode.height());
            }
        } else {
            GLFW.glfwSetWindowSize((long)window, (int)savedW[0], (int)savedH[0]);
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)savedX[0], (int)savedY[0], (int)savedW[0], (int)savedH[0], (int)0);
        }
    }

    public static void toggleBorderless() {
        Display.setBorderless(!Display.isBorderless());
    }

    public static void setBorderless(boolean toBorderless) {
        long window = Display.getWindow();
        if (window == 0L) {
            return;
        }
        if (toBorderless) {
            GLFW.glfwGetWindowPos((long)window, (int[])savedX, (int[])savedY);
            GLFW.glfwGetWindowSize((long)window, (int[])savedW, (int[])savedH);
            PositionedGLFWVidMode monitorInfo = Display.getTargetFullscreenMonitor();
            GLFWVidMode vidMode = monitorInfo.vidMode;
            int height = vidMode.height();
            if (ForgeEarlyConfig.WINDOW_BORDERLESS_WINDOWS_COMPATIBILITY && System.getProperty("os.name").toLowerCase().contains("win")) {
                ++height;
            }
            GLFW.glfwSetWindowSizeLimits((long)window, (int)0, (int)0, (int)vidMode.width(), (int)height);
            GLFW.glfwSetWindowSize((long)window, (int)vidMode.width(), (int)height);
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)monitorInfo.x, (int)monitorInfo.y, (int)vidMode.width(), (int)height, (int)vidMode.refreshRate());
        } else {
            GLFW.glfwSetWindowSizeLimits((long)window, (int)0, (int)0, (int)-1, (int)-1);
            GLFW.glfwSetWindowSize((long)window, (int)savedW[0], (int)savedH[0]);
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)savedX[0], (int)savedY[0], (int)savedW[0], (int)savedH[0], (int)0);
        }
    }

    public static boolean isBorderless() {
        long window = Display.getWindow();
        long windowMonitor = GLFW.glfwGetWindowMonitor((long)Display.getWindow());
        if (Display.getWindow() != 0L && windowMonitor == 0L) {
            IntBuffer windowX = org.lwjglx.BufferUtils.createIntBuffer(1);
            IntBuffer windowY = org.lwjglx.BufferUtils.createIntBuffer(1);
            IntBuffer windowWidth = org.lwjglx.BufferUtils.createIntBuffer(1);
            IntBuffer windowHeight = org.lwjglx.BufferUtils.createIntBuffer(1);
            GLFW.glfwGetWindowPos((long)window, (IntBuffer)windowX, (IntBuffer)windowY);
            GLFW.glfwGetWindowSize((long)window, (IntBuffer)windowWidth, (IntBuffer)windowHeight);
            PositionedGLFWVidMode monitorInfo = Display.getTargetFullscreenMonitor();
            GLFWVidMode vidMode = monitorInfo.vidMode();
            return windowX.get(0) == monitorInfo.x() && windowY.get(0) == monitorInfo.y() && windowWidth.get(0) == vidMode.width() && windowHeight.get(0) >= vidMode.height();
        }
        return false;
    }

    public static boolean isFullscreen() {
        if (Display.getWindow() != 0L) {
            return GLFW.glfwGetWindowMonitor((long)Display.getWindow()) != 0L;
        }
        return false;
    }

    public static void setParent(Canvas parent) {
    }

    public static Canvas getParent() {
        return null;
    }

    public static void setSwapInterval(int value) {
        GLFW.glfwSwapInterval((int)value);
    }

    public static void setDisplayConfiguration(float gamma, float brightness, float contrast) {
    }

    public static void releaseContext() {
        GLFW.glfwMakeContextCurrent((long)0L);
    }

    public static boolean isCurrent() {
        return true;
    }

    public static void makeCurrent() {
        GLFW.glfwMakeContextCurrent((long)Window.handle);
    }

    public static String getAdapter() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7936);
        }
        return "Unknown";
    }

    public static String getVersion() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7938);
        }
        return "Unknown";
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static Drawable getDrawable() {
        return drawable;
    }

    static DisplayImplementation getImplementation() {
        return null;
    }

    static {
        latestEventKey = 0;
        displayX = 0;
        displayY = 0;
        displayResized = false;
        displayWidth = 0;
        displayHeight = 0;
        displayFramebufferWidth = 0;
        displayFramebufferHeight = 0;
        latestResized = false;
        latestWidth = 0;
        latestHeight = 0;
        cancelNextChar = false;
        lastAltIsRightAlt = false;
        glfwKeycodeNames = new HashMap();
        Sys.initialize();
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitor);
        int monitorWidth = vidmode.width();
        int monitorHeight = vidmode.height();
        int monitorBitPerPixel = vidmode.redBits() + vidmode.greenBits() + vidmode.blueBits();
        int monitorRefreshRate = vidmode.refreshRate();
        desktopDisplayMode = new DisplayMode(monitorWidth, monitorHeight, monitorBitPerPixel, monitorRefreshRate);
        try {
            Class<GLFW> glfwClass = GLFW.class;
            for (Field f : glfwClass.getFields()) {
                if (!f.getName().startsWith("GLFW_KEY_") || f.getType() != Integer.TYPE || !Modifier.isStatic(f.getModifiers())) continue;
                int value = f.getInt(null);
                glfwKeycodeNames.put(value, f.getName());
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        hasPixelFormat = false;
        attachmentPixelFormat = null;
        hasContextAttribs = false;
        attachmentContextAttribs = null;
        hasDrawable = false;
        attachmentDrawable = null;
        savedX = new int[1];
        savedY = new int[1];
        savedW = new int[1];
        savedH = new int[1];
        drawable = null;
    }

    private static class Window {
        static long handle;
        static GLFWKeyCallback keyCallback;
        static GLFWCharCallback charCallback;
        static GLFWCharModsCallback charModsCallback;
        static GLFWCursorPosCallback cursorPosCallback;
        static GLFWMouseButtonCallback mouseButtonCallback;
        static GLFWScrollCallback scrollCallback;
        static GLFWWindowFocusCallback windowFocusCallback;
        static GLFWWindowIconifyCallback windowIconifyCallback;
        static GLFWWindowSizeCallback windowSizeCallback;
        static GLFWWindowPosCallback windowPosCallback;
        static GLFWWindowRefreshCallback windowRefreshCallback;
        static GLFWFramebufferSizeCallback framebufferSizeCallback;

        private Window() {
        }

        public static void setCallbacks() {
            GLFW.glfwSetKeyCallback((long)handle, (GLFWKeyCallbackI)keyCallback);
            GLFW.glfwSetCharCallback((long)handle, (GLFWCharCallbackI)charCallback);
            GLFW.glfwSetCharModsCallback((long)handle, (GLFWCharModsCallbackI)charModsCallback);
            GLFW.glfwSetCursorPosCallback((long)handle, (GLFWCursorPosCallbackI)cursorPosCallback);
            GLFW.glfwSetMouseButtonCallback((long)handle, (GLFWMouseButtonCallbackI)mouseButtonCallback);
            GLFW.glfwSetScrollCallback((long)handle, (GLFWScrollCallbackI)scrollCallback);
            GLFW.glfwSetWindowFocusCallback((long)handle, (GLFWWindowFocusCallbackI)windowFocusCallback);
            GLFW.glfwSetWindowIconifyCallback((long)handle, (GLFWWindowIconifyCallbackI)windowIconifyCallback);
            GLFW.glfwSetWindowSizeCallback((long)handle, (GLFWWindowSizeCallbackI)windowSizeCallback);
            GLFW.glfwSetWindowPosCallback((long)handle, (GLFWWindowPosCallbackI)windowPosCallback);
            GLFW.glfwSetWindowRefreshCallback((long)handle, (GLFWWindowRefreshCallbackI)windowRefreshCallback);
            GLFW.glfwSetFramebufferSizeCallback((long)handle, (GLFWFramebufferSizeCallbackI)framebufferSizeCallback);
        }

        public static void releaseCallbacks() {
            keyCallback.free();
            charCallback.free();
            cursorPosCallback.free();
            mouseButtonCallback.free();
            scrollCallback.free();
            windowFocusCallback.free();
            windowIconifyCallback.free();
            windowSizeCallback.free();
            windowPosCallback.free();
            windowRefreshCallback.free();
            framebufferSizeCallback.free();
        }
    }

    public record PositionedGLFWVidMode(int x, int y, Rectangle bounds, long monitorId, GLFWVidMode vidMode) {
    }
}

