/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.opengl;

import java.util.HashMap;
import java.util.Map;
import org.lwjglx.opengl.ContextCapabilities;
import org.lwjglx.opengl.GLContext;

final class CallbackUtil {
    private static final Map<ContextCapabilities, Long> contextUserParamsARB = new HashMap<ContextCapabilities, Long>();
    private static final Map<ContextCapabilities, Long> contextUserParamsAMD = new HashMap<ContextCapabilities, Long>();
    private static final Map<ContextCapabilities, Long> contextUserParamsKHR = new HashMap<ContextCapabilities, Long>();

    private CallbackUtil() {
    }

    static long createGlobalRef(Object obj) {
        return obj == null ? 0L : CallbackUtil.ncreateGlobalRef(obj);
    }

    private static long ncreateGlobalRef(Object obj) {
        return 0L;
    }

    private static void deleteGlobalRef(long ref) {
    }

    private static void registerContextCallback(long userParam, Map<ContextCapabilities, Long> contextUserData) {
        ContextCapabilities caps = GLContext.getCapabilities();
        if (caps == null) {
            CallbackUtil.deleteGlobalRef(userParam);
            throw new IllegalStateException("No context is current.");
        }
        Long userParam_old = contextUserData.remove(caps);
        if (userParam_old != null) {
            CallbackUtil.deleteGlobalRef(userParam_old);
        }
        if (userParam != 0L) {
            contextUserData.put(caps, userParam);
        }
    }

    static void unregisterCallbacks(Object context) {
        ContextCapabilities caps = GLContext.getCapabilities();
        Long userParam = contextUserParamsARB.remove(caps);
        if (userParam != null) {
            CallbackUtil.deleteGlobalRef(userParam);
        }
        if ((userParam = contextUserParamsAMD.remove(caps)) != null) {
            CallbackUtil.deleteGlobalRef(userParam);
        }
        if ((userParam = contextUserParamsKHR.remove(caps)) != null) {
            CallbackUtil.deleteGlobalRef(userParam);
        }
    }

    static long getDebugOutputCallbackARB() {
        return 0L;
    }

    static void registerContextCallbackARB(long userParam) {
        CallbackUtil.registerContextCallback(userParam, contextUserParamsARB);
    }

    static long getDebugOutputCallbackAMD() {
        return 0L;
    }

    static void registerContextCallbackAMD(long userParam) {
        CallbackUtil.registerContextCallback(userParam, contextUserParamsAMD);
    }

    static long getDebugCallbackKHR() {
        return 0L;
    }

    static void registerContextCallbackKHR(long userParam) {
        CallbackUtil.registerContextCallback(userParam, contextUserParamsKHR);
    }
}

