/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraftforge.common.ForgeEarlyConfig;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjglx.LWJGLException;
import org.lwjglx.Sys;
import org.lwjglx.input.Cursor;
import org.lwjglx.input.EventQueue;
import org.lwjglx.opengl.Display;

public class Mouse {
    public static final int EVENT_SIZE = 22;
    private static ByteBuffer buttons = BufferUtils.createByteBuffer((int)32);
    private static IntBuffer coord_buffer = BufferUtils.createIntBuffer((int)32);
    private static ByteBuffer readBuffer = BufferUtils.createByteBuffer((int)32);
    private static boolean grabbed = false;
    private static int lastEventX = 0;
    private static int lastEventY = 0;
    private static int latestX = 0;
    private static int latestY = 0;
    private static int x = 0;
    private static int y = 0;
    private static int dx = 0;
    private static int dy = 0;
    private static int dwheel = 0;
    private static EventQueue queue = new EventQueue(512);
    private static int[] buttonEvents = new int[queue.getMaxEvents()];
    private static boolean[] buttonEventStates = new boolean[queue.getMaxEvents()];
    private static int[] xEvents = new int[queue.getMaxEvents()];
    private static int[] yEvents = new int[queue.getMaxEvents()];
    private static int[] wheelEvents = new int[queue.getMaxEvents()];
    private static int[] lastxEvents = new int[queue.getMaxEvents()];
    private static int[] lastyEvents = new int[queue.getMaxEvents()];
    private static long[] nanoTimeEvents = new long[queue.getMaxEvents()];
    private static boolean clipPostionToDisplay = true;
    private static int ignoreNextDelta = 0;
    private static int ignoreNextMove = 0;
    private static Cursor currentCursor = null;
    static double fractionalWheelPosition = 0.0;
    public static double totalScrollAmount = 0.0;

    public static void addMoveEvent(double mouseX, double mouseY) {
        if (ignoreNextMove > 0) {
            --ignoreNextMove;
            return;
        }
        float scale = Display.getPixelScaleFactor();
        dx += (int)(mouseX *= (double)scale) - latestX;
        dy += Display.getHeight() - (int)(mouseY *= (double)scale) - latestY;
        latestX = (int)mouseX;
        latestY = Display.getHeight() - (int)mouseY;
        if (ignoreNextDelta > 0) {
            --ignoreNextDelta;
            x = latestX;
            y = latestY;
            lastEventX = latestX;
            lastEventY = latestY;
            dx = 0;
            dy = 0;
        }
        Mouse.lastxEvents[Mouse.queue.getNextPos()] = lastEventX;
        Mouse.lastyEvents[Mouse.queue.getNextPos()] = lastEventY;
        lastEventX = latestX;
        lastEventY = latestY;
        Mouse.xEvents[Mouse.queue.getNextPos()] = latestX;
        Mouse.yEvents[Mouse.queue.getNextPos()] = latestY;
        Mouse.wheelEvents[Mouse.queue.getNextPos()] = 0;
        Mouse.buttonEvents[Mouse.queue.getNextPos()] = -1;
        Mouse.buttonEventStates[Mouse.queue.getNextPos()] = false;
        Mouse.nanoTimeEvents[Mouse.queue.getNextPos()] = Sys.getNanoTime();
        queue.add();
    }

    public static void addButtonEvent(int button, boolean pressed) {
        Mouse.lastxEvents[Mouse.queue.getNextPos()] = lastEventX;
        Mouse.lastyEvents[Mouse.queue.getNextPos()] = lastEventY;
        lastEventX = latestX;
        lastEventY = latestY;
        Mouse.xEvents[Mouse.queue.getNextPos()] = latestX;
        Mouse.yEvents[Mouse.queue.getNextPos()] = latestY;
        Mouse.wheelEvents[Mouse.queue.getNextPos()] = 0;
        Mouse.buttonEvents[Mouse.queue.getNextPos()] = button;
        Mouse.buttonEventStates[Mouse.queue.getNextPos()] = pressed;
        Mouse.nanoTimeEvents[Mouse.queue.getNextPos()] = Sys.getNanoTime();
        queue.add();
    }

    public static void addWheelEvent(double delta) {
        if (ForgeEarlyConfig.INPUT_INVERT_WHEEL) {
            delta = -delta;
        }
        int lastWheel = (int)fractionalWheelPosition;
        totalScrollAmount += delta;
        int newWheel = (int)(fractionalWheelPosition += (delta *= ForgeEarlyConfig.INPUT_SCROLL_SPEED));
        if (newWheel != lastWheel) {
            Mouse.lastxEvents[Mouse.queue.getNextPos()] = lastEventX;
            Mouse.lastyEvents[Mouse.queue.getNextPos()] = lastEventY;
            lastEventX = latestX;
            lastEventY = latestY;
            dwheel += newWheel - lastWheel;
            Mouse.xEvents[Mouse.queue.getNextPos()] = latestX;
            Mouse.yEvents[Mouse.queue.getNextPos()] = latestY;
            Mouse.wheelEvents[Mouse.queue.getNextPos()] = newWheel - lastWheel;
            Mouse.buttonEvents[Mouse.queue.getNextPos()] = -1;
            Mouse.buttonEventStates[Mouse.queue.getNextPos()] = false;
            Mouse.nanoTimeEvents[Mouse.queue.getNextPos()] = Sys.getNanoTime();
            queue.add();
        }
        fractionalWheelPosition %= 1.0;
    }

    public static void poll() {
        if (!grabbed && clipPostionToDisplay) {
            if (latestX < 0) {
                latestX = 0;
            }
            if (latestY < 0) {
                latestY = 0;
            }
            if (latestX > Display.getWidth() - 1) {
                latestX = Display.getWidth() - 1;
            }
            if (latestY > Display.getHeight() - 1) {
                latestY = Display.getHeight() - 1;
            }
        }
        x = latestX;
        y = latestY;
    }

    public static void create() throws LWJGLException {
    }

    public static boolean isCreated() {
        return Display.isCreated();
    }

    public static void setGrabbed(boolean grab) {
        if (grabbed == grab) {
            return;
        }
        GLFW.glfwSetInputMode((long)Display.getWindow(), (int)208897, (int)(grab ? 212995 : 212993));
        grabbed = grab;
        if (!grab) {
            ignoreNextMove += 2;
            Mouse.setCursorPosition(Display.getWidth() / 2, Display.getHeight() / 2);
            latestX = Display.getWidth() / 2;
            latestY = Display.getHeight() / 2;
            lastEventX = latestX;
            lastEventY = latestY;
            x = latestX;
            y = latestY;
            Mouse.xEvents[Mouse.queue.getNextPos()] = latestX;
            Mouse.yEvents[Mouse.queue.getNextPos()] = latestY;
            Mouse.lastxEvents[Mouse.queue.getNextPos()] = latestX;
            Mouse.lastyEvents[Mouse.queue.getNextPos()] = latestY;
            Mouse.wheelEvents[Mouse.queue.getNextPos()] = 0;
            Mouse.buttonEvents[Mouse.queue.getNextPos()] = -1;
            Mouse.buttonEventStates[Mouse.queue.getNextPos()] = false;
            Mouse.nanoTimeEvents[Mouse.queue.getNextPos()] = Sys.getNanoTime();
            queue.add();
        } else {
            ++ignoreNextDelta;
            dx = 0;
            dy = 0;
        }
    }

    public static boolean isGrabbed() {
        return grabbed;
    }

    public static boolean isButtonDown(int button) {
        return GLFW.glfwGetMouseButton((long)Display.getWindow(), (int)button) == 1;
    }

    public static boolean next() {
        return queue.next();
    }

    public static int getEventX() {
        return xEvents[queue.getCurrentPos()];
    }

    public static int getEventY() {
        return yEvents[queue.getCurrentPos()];
    }

    public static int getEventDX() {
        return xEvents[queue.getCurrentPos()] - lastxEvents[queue.getCurrentPos()];
    }

    public static int getEventDY() {
        return yEvents[queue.getCurrentPos()] - lastyEvents[queue.getCurrentPos()];
    }

    public static long getEventNanoseconds() {
        return nanoTimeEvents[queue.getCurrentPos()];
    }

    public static int getEventButton() {
        return buttonEvents[queue.getCurrentPos()];
    }

    public static boolean getEventButtonState() {
        return buttonEventStates[queue.getCurrentPos()];
    }

    public static int getEventDWheel() {
        return wheelEvents[queue.getCurrentPos()] * 120;
    }

    public static int getX() {
        return x;
    }

    public static int getY() {
        return y;
    }

    public static int getDX() {
        int value = dx;
        dx = 0;
        return value;
    }

    public static int getDY() {
        int value = dy;
        dy = 0;
        return value;
    }

    public static int getDWheel() {
        int value = dwheel;
        dwheel = 0;
        return value * 120;
    }

    public static int getButtonCount() {
        return 8;
    }

    public static void setClipMouseCoordinatesToWindow(boolean clip) {
        clipPostionToDisplay = clip;
    }

    public static void setCursorPosition(int new_x, int new_y) {
        if (grabbed) {
            return;
        }
        float inv_scale = 1.0f / Display.getPixelScaleFactor();
        GLFW.glfwSetCursorPos((long)Display.getWindow(), (double)(new_x *= (int)inv_scale), (double)(new_y *= (int)inv_scale));
        Mouse.addMoveEvent(new_x, new_y);
    }

    public static Cursor setNativeCursor(Cursor cursor) throws LWJGLException {
        GLFW.glfwSetCursor((long)Display.getWindow(), (long)cursor.getNativeCursor());
        currentCursor = cursor;
        return cursor;
    }

    public static void destroy() {
    }

    public static int getButtonIndex(String buttonName) {
        if (buttonName.matches("BUTTON[0-9]+")) {
            return Integer.parseInt(StringUtils.removeStart((String)buttonName, (String)"BUTTON"));
        }
        return -1;
    }

    public static String getButtonName(int button) {
        return "BUTTON" + button;
    }

    public static Cursor getNativeCursor() {
        return currentCursor;
    }

    public static boolean hasWheel() {
        return true;
    }

    public static boolean isClipMouseCoordinatesToWindow() {
        return clipPostionToDisplay;
    }

    public static boolean isInsideWindow() {
        return Display.isVisible();
    }

    public static void updateCursor() {
    }
}

