/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjglx.BufferUtils;
import org.lwjglx.LWJGLException;

public class Cursor {
    public static final int CURSOR_ONE_BIT_TRANSPARENCY = 1;
    public static final int CURSOR_8_BIT_ALPHA = 2;
    public static final int CURSOR_ANIMATION = 4;
    private final CursorElement[] cursors;
    private int index;
    private boolean destroyed;
    private final long addr;

    public Cursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        int[] fixed = new int[images.remaining()];
        int[] array = new int[images.remaining()];
        int i = 0;
        while (images.remaining() > 0) {
            array[i++] = images.get();
        }
        for (i = 0; i < array.length; ++i) {
            fixed[i] = array[width * (height - i / width - 1) + i % width];
        }
        ByteBuffer bb = BufferUtils.createByteBuffer(images.capacity() * 4);
        bb.asIntBuffer().put(fixed);
        GLFWImage image = new GLFWImage(BufferUtils.createByteBuffer(GLFWImage.SIZEOF));
        image.set(width, height, bb);
        this.addr = GLFW.glfwCreateCursor((GLFWImage)image, (int)xHotspot, (int)(height - yHotspot));
        this.cursors = null;
    }

    public static int getMinCursorSize() {
        return 0;
    }

    public static int getMaxCursorSize() {
        return 0;
    }

    public static int getCapabilities() {
        return 0;
    }

    private static CursorElement[] createCursors(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        return null;
    }

    private static void convertARGBtoABGR(IntBuffer imageBuffer) {
        for (int i = 0; i < imageBuffer.limit(); ++i) {
            int argbColor = imageBuffer.get(i);
            byte alpha = (byte)(argbColor >>> 24);
            byte blue = (byte)(argbColor >>> 16);
            byte green = (byte)(argbColor >>> 8);
            byte red = (byte)argbColor;
            int abgrColor = ((alpha & 0xFF) << 24) + ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF);
            imageBuffer.put(i, abgrColor);
        }
    }

    private static void flipImages(int width, int height, int numImages, IntBuffer images, IntBuffer images_copy) {
        for (int i = 0; i < numImages; ++i) {
            int start_index = i * width * height;
            Cursor.flipImage(width, height, start_index, images, images_copy);
        }
    }

    private static void flipImage(int width, int height, int start_index, IntBuffer images, IntBuffer images_copy) {
        for (int y = 0; y < height >> 1; ++y) {
            int index_y_1 = y * width + start_index;
            int index_y_2 = (height - y - 1) * width + start_index;
            for (int x = 0; x < width; ++x) {
                int index1 = index_y_1 + x;
                int index2 = index_y_2 + x;
                int temp_pixel = images.get(index1 + images.position());
                images_copy.put(index1, images.get(index2 + images.position()));
                images_copy.put(index2, temp_pixel);
            }
        }
    }

    Object getHandle() {
        this.checkValid();
        return this.cursors[this.index].cursorHandle;
    }

    private void checkValid() {
        if (this.destroyed) {
            throw new IllegalStateException("The cursor is destroyed");
        }
    }

    public void destroy() {
    }

    protected void setTimeout() {
        this.checkValid();
        this.cursors[this.index].timeout = System.currentTimeMillis() + this.cursors[this.index].delay;
    }

    protected boolean hasTimedOut() {
        this.checkValid();
        return this.cursors.length > 1 && this.cursors[this.index].timeout < System.currentTimeMillis();
    }

    protected void nextCursor() {
        this.checkValid();
        ++this.index;
        this.index %= this.cursors.length;
    }

    public long getNativeCursor() {
        return this.addr;
    }

    private static class CursorElement {
        final Object cursorHandle;
        final long delay;
        long timeout;

        CursorElement(Object cursorHandle, long delay, long timeout) {
            this.cursorHandle = cursorHandle;
            this.delay = delay;
            this.timeout = timeout;
        }
    }
}

