/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.net.URI;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.minecraftforge.common.ForgeEarlyConfig;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import org.lwjglx.LWJGLUtil;
import org.lwjglx.opengl.Display;

public class Sys {
    public static void initialize() {
    }

    public static String getVersion() {
        return Version.getVersion();
    }

    public static long getTimerResolution() {
        return 1000L;
    }

    public static long getTime() {
        return (long)(GLFW.glfwGetTime() * 1000.0);
    }

    public static long getNanoTime() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }

    public static boolean openURL(String url) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        try {
            desktop.browse(new URI(url));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void alert(String title, String message) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LWJGLUtil.log("Caught exception while setting LAF: " + String.valueOf(e));
        }
        JOptionPane.showMessageDialog(null, message, title, 2);
    }

    public static boolean is64Bit() {
        return Platform.getArchitecture().toString().endsWith("64");
    }

    public static String getClipboard() {
        return GLFW.glfwGetClipboardString((long)Display.getWindow());
    }

    static {
        if (Platform.get() == Platform.MACOSX) {
            Configuration.GLFW_CHECK_THREAD0.set((Object)false);
            Configuration.GLFW_LIBRARY_NAME.set((Object)"glfw_async");
            Toolkit.getDefaultToolkit();
        }
        if (Objects.requireNonNullElse(System.getenv("XDG_SESSION_TYPE"), "").toLowerCase().startsWith("wayland")) {
            if (!ForgeEarlyConfig.FORCE_WAYLAND) {
                GLFW.glfwInitHint((int)327683, (int)393220);
            } else {
                GLFW.glfwInitHint((int)327683, (int)393219);
            }
        }
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize glfw");
        }
    }
}

