/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.terminalconsole;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.jline.reader.LineReader;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

@Plugin(name="TerminalConsole", category="Core", elementType="appender", printObject=true)
public class TerminalConsoleAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "TerminalConsole";
    public static final String PROPERTY_PREFIX = "terminal";
    public static final String JLINE_OVERRIDE_PROPERTY = "terminal.jline";
    public static final String ANSI_OVERRIDE_PROPERTY = "terminal.ansi";
    public static final Boolean ANSI_OVERRIDE = TerminalConsoleAppender.getOptionalBooleanProperty("terminal.ansi");
    private static final PrintStream stdout = System.out;
    private static boolean initialized;
    @Nullable
    private static Terminal terminal;
    @Nullable
    private static LineReader reader;

    @Nullable
    public static synchronized Terminal getTerminal() {
        return terminal;
    }

    @Nullable
    public static synchronized LineReader getReader() {
        return reader;
    }

    public static synchronized void setReader(@Nullable LineReader newReader) {
        if (newReader != null && newReader.getTerminal() != terminal) {
            throw new IllegalArgumentException("Reader was not created with TerminalConsoleAppender.getTerminal()");
        }
        reader = newReader;
    }

    public static boolean isAnsiSupported() {
        return ANSI_OVERRIDE != null ? ANSI_OVERRIDE : terminal != null;
    }

    protected TerminalConsoleAppender(String name, @Nullable Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        TerminalConsoleAppender.initializeTerminal();
    }

    private static synchronized void initializeTerminal() {
        if (!initialized) {
            boolean dumb;
            initialized = true;
            Boolean jlineOverride = TerminalConsoleAppender.getOptionalBooleanProperty(JLINE_OVERRIDE_PROPERTY);
            boolean bl2 = dumb = jlineOverride == Boolean.TRUE || System.getProperty("java.class.path").contains("idea_rt.jar");
            if (jlineOverride != Boolean.FALSE) {
                try {
                    terminal = TerminalBuilder.builder().dumb(dumb).build();
                }
                catch (IllegalStateException e2) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.warn("Disabling terminal, you're running in an unsupported environment.", (Throwable)e2);
                    } else {
                        LOGGER.warn("Disabling terminal, you're running in an unsupported environment.");
                    }
                }
                catch (IOException e3) {
                    LOGGER.error("Failed to initialize terminal. Falling back to standard output", (Throwable)e3);
                }
            }
        }
    }

    @Nullable
    private static Boolean getOptionalBooleanProperty(String name) {
        String value = PropertiesUtil.getProperties().getStringProperty(name);
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        LOGGER.warn("Invalid value for boolean input property '{}': {}", (Object)name, (Object)value);
        return null;
    }

    public void append(LogEvent event) {
        this.print(this.getLayout().toSerializable(event).toString());
    }

    private synchronized void print(String text) {
        if (terminal != null) {
            if (reader != null) {
                reader.printAbove(text);
            } else {
                terminal.writer().print(text);
                terminal.writer().flush();
            }
            terminal.writer().flush();
        } else {
            stdout.print(text);
        }
    }

    public static synchronized void close() throws IOException {
        if (initialized) {
            initialized = false;
            if (terminal != null) {
                try {
                    terminal.close();
                }
                finally {
                    terminal = null;
                }
            }
        }
    }

    @PluginFactory
    public static TerminalConsoleAppender createAppender(@Required(message="No name provided for TerminalConsoleAppender") @PluginAttribute(value="name") String name, @PluginElement(value="Filter") @Nullable Filter filter, @PluginElement(value="Layout") @Nullable Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions) {
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new TerminalConsoleAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions);
    }
}

